/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.plugins.checks.client;

import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.plugins.checks.api.CheckerInfo;
import com.google.gerrit.plugins.checks.api.CheckerInput;
import com.google.gerrit.plugins.checks.client.AbstractEndpoint;
import com.google.gson.reflect.TypeToken;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.eclipse.jgit.transport.URIish;

public class Checkers
extends AbstractEndpoint {
    protected Checkers(URIish gerritBaseUrl, CloseableHttpClient client, boolean isAuthenticated) throws URISyntaxException {
        super(gerritBaseUrl, client, isAuthenticated);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CheckerInfo create(CheckerInput input) throws RestApiException {
        try {
            HttpPost request = new HttpPost(this.buildRequestUrl());
            String inputString = AbstractEndpoint.JsonBodyParser.createRequestBody(input, new TypeToken<CheckerInput>(){}.getType());
            request.setEntity((HttpEntity)new StringEntity(inputString));
            request.setHeader("Content-type", "application/json");
            try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);){
                if (response.getStatusLine().getStatusCode() == 201) {
                    CheckerInfo checkerInfo = (CheckerInfo)AbstractEndpoint.JsonBodyParser.parseResponse(EntityUtils.toString((HttpEntity)response.getEntity()), new TypeToken<CheckerInfo>(){}.getType());
                    return checkerInfo;
                }
                throw new RestApiException(String.format("Request returned status %s", response.getStatusLine().getStatusCode()));
            }
        }
        catch (Exception e) {
            throw new RestApiException("Could not create checker", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CheckerInfo get(String checkerUuid) throws RestApiException {
        try {
            HttpGet request = new HttpGet(this.buildRequestUrl(checkerUuid));
            try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);){
                if (response.getStatusLine().getStatusCode() == 200) {
                    CheckerInfo checkerInfo = (CheckerInfo)AbstractEndpoint.JsonBodyParser.parseResponse(EntityUtils.toString((HttpEntity)response.getEntity()), new TypeToken<CheckerInfo>(){}.getType());
                    return checkerInfo;
                }
                throw new RestApiException(String.format("Request failed with status: %d", response.getStatusLine().getStatusCode()));
            }
        }
        catch (Exception e) {
            throw new RestApiException("Failed to get checker info: ", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CheckerInfo update(CheckerInput input) throws RestApiException {
        try {
            HttpPost request = new HttpPost(this.buildRequestUrl(input.uuid));
            String inputString = AbstractEndpoint.JsonBodyParser.createRequestBody(input, new TypeToken<CheckerInput>(){}.getType());
            request.setEntity((HttpEntity)new StringEntity(inputString));
            request.setHeader("Content-type", "application/json");
            try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);){
                if (response.getStatusLine().getStatusCode() == 200) {
                    CheckerInfo checkerInfo = (CheckerInfo)AbstractEndpoint.JsonBodyParser.parseResponse(EntityUtils.toString((HttpEntity)response.getEntity()), new TypeToken<CheckerInfo>(){}.getType());
                    return checkerInfo;
                }
                throw new RestApiException(String.format("Request returned status %s", response.getStatusLine().getStatusCode()));
            }
        }
        catch (Exception e) {
            throw new RestApiException("Could not update checker", (Throwable)e);
        }
    }

    private URI buildRequestUrl() throws URISyntaxException {
        return this.buildRequestUrl("");
    }

    private URI buildRequestUrl(String suffixPath) throws URISyntaxException {
        return this.uriBuilder.setPath(String.format("%splugins/checks/checkers/%s", this.getPrefix(), suffixPath)).build();
    }
}

