/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.plugins.checks.client;

import com.google.gerrit.plugins.checks.client.UTCTimestampTypeAdapter;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.sql.Timestamp;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.eclipse.jgit.transport.URIish;

abstract class AbstractEndpoint {
    private static final String AUTH_PREFIX = "/a/";
    private final URIish gerritBaseUrl;
    private final boolean isAuthentcated;
    protected final CloseableHttpClient client;
    protected final URIBuilder uriBuilder;

    protected AbstractEndpoint(URIish gerritBaseUrl, CloseableHttpClient client, boolean isAuthenticated) throws URISyntaxException {
        this.isAuthentcated = isAuthenticated;
        this.gerritBaseUrl = gerritBaseUrl;
        this.client = client;
        this.uriBuilder = new URIBuilder(gerritBaseUrl.toASCIIString());
    }

    protected String getPrefix() {
        return this.isAuthentcated ? AUTH_PREFIX : "/";
    }

    protected URIish getGerritBaseUrl() {
        return this.gerritBaseUrl;
    }

    public static class JsonBodyParser {
        private static final String JSON_PREFIX = ")]}'";

        public static <T> T parseResponse(String json, Type type) {
            json = JsonBodyParser.removeJsonPrefix(json);
            return (T)JsonBodyParser.newGson().fromJson(json, type);
        }

        public static String createRequestBody(Object object, Type type) {
            return JsonBodyParser.newGson().toJson(object, type);
        }

        private static Gson newGson() {
            return new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setDateFormat("yyyy-MM-dd HH:mm:ss.SSS").registerTypeAdapter(Timestamp.class, (Object)new UTCTimestampTypeAdapter()).create();
        }

        private static String removeJsonPrefix(String json) {
            if (json.startsWith(JSON_PREFIX)) {
                return json.split("\n", 2)[1];
            }
            return json;
        }
    }
}

