/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit.workflow;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.api.changes.ReviewInput;
import hudson.model.Action;
import hudson.model.ModelObject;
import hudson.model.Result;
import hudson.model.Run;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Future;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.jvnet.hudson.test.JenkinsRule;
import org.mockserver.junit.MockServerRule;
import org.mockserver.model.Body;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.JsonBody;
import org.mockserver.verify.VerificationTimes;

@RunWith(value=Parameterized.class)
public class GerritReviewStepTest {
    @Rule
    public MockServerRule g = new MockServerRule((Object)this);
    @Rule
    public JenkinsRule j = new JenkinsRule();
    private static final String projectName = "test-project";
    private static final int changeNumber = 4321;
    private final String gerritVersion;
    private final String changeId;

    public GerritReviewStepTest(String gerritVersion, String changeId) {
        this.gerritVersion = gerritVersion;
        this.changeId = changeId;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> gerritVersionToChangeIdData() {
        return Arrays.asList({"2.14", String.valueOf(4321)}, {"2.16", String.format("%s~%s", projectName, String.valueOf(4321))});
    }

    @Before
    public void setup() {
        this.setupServerVersion();
    }

    @Test
    public void gerritCommentStepInvokeNoAPITest() throws Exception {
        WorkflowJob p = (WorkflowJob)this.j.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n  withEnv([\n  ]) {\n    gerritReview label: 'Verified', score: -1, message: 'Does not work'\n  }\n}", true));
        WorkflowRun run = (WorkflowRun)this.j.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        String log = JenkinsRule.getLog((Run)run);
        this.j.assertLogContains("Gerrit Review is disabled no API URL", (Run)run);
    }

    @Test
    public void gerritCommentStepInvokeNoCredTest() throws Exception {
        WorkflowJob p = (WorkflowJob)this.j.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n  withEnv([\n    'GERRIT_API_URL=http://host/a/project',\n  ]) {\n    gerritReview label: 'Verified', score: -1, message: 'Does not work'\n  }\n}", true));
        WorkflowRun run = (WorkflowRun)this.j.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        String log = JenkinsRule.getLog((Run)run);
        this.j.assertLogContains("Gerrit Review requires authentication", (Run)run);
    }

    @Test
    public void gerritCommentStepInvokeMissingCredTest() throws Exception {
        WorkflowJob p = (WorkflowJob)this.j.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n  withEnv([\n    'GERRIT_API_URL=http://host/a/project',\n    'GERRIT_CREDENTIALS_ID=cid',\n  ]) {\n    gerritReview label: 'Verified', score: -1, message: 'Does not work'\n  }\n}", true));
        WorkflowRun run = (WorkflowRun)this.j.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        String log = JenkinsRule.getLog((Run)run);
        this.j.assertLogContains("Gerrit Review requires authentication", (Run)run);
    }

    @Test
    public void gerritReviewStepInvokeFailSSLValidationTest() throws Exception {
        int revision = 1;
        String label = "Verfied";
        int score = -1;
        String message = "Does not work";
        String branch = String.format("%02d/%d/%d", 21, 4321, revision);
        UsernamePasswordCredentialsImpl c = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, "cid", "cid", "USERNAME", "PASSWORD");
        ((CredentialsStore)CredentialsProvider.lookupStores((ModelObject)this.j.jenkins).iterator().next()).addCredentials(Domain.global(), (Credentials)c);
        WorkflowJob p = (WorkflowJob)this.j.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition(String.format("node {\n  withEnv([\n    'GERRIT_API_URL=https://%s:%s/a/project',\n    'GERRIT_CREDENTIALS_ID=cid',\n    'BRANCH_NAME=%s',\n  ]) {\n    gerritReview label: '%s', score: %s, message: '%s'\n  }\n}", this.g.getClient().remoteAddress().getHostString(), this.g.getClient().remoteAddress().getPort(), branch, label, score, message), true));
        WorkflowRun run = (WorkflowRun)this.j.assertBuildStatus(Result.FAILURE, (Future)p.scheduleBuild2(0, new Action[0]));
        String log = JenkinsRule.getLog((Run)run);
        this.j.assertLogContains("javax.net.ssl.SSLHandshakeException", (Run)run);
    }

    @Test
    public void gerritReviewStepInvokeTest() throws Exception {
        int revision = 1;
        String label = "Verfied";
        int score = -1;
        String message = "Does not work";
        String branch = String.format("%02d/%d/%d", 21, 4321, revision);
        UsernamePasswordCredentialsImpl c = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, "cid", "cid", "USERNAME", "PASSWORD");
        ((CredentialsStore)CredentialsProvider.lookupStores((ModelObject)this.j.jenkins).iterator().next()).addCredentials(Domain.global(), (Credentials)c);
        WorkflowJob p = (WorkflowJob)this.j.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition(String.format("node {\n  withEnv([\n    'GERRIT_API_URL=https://%s:%s',\n    'GERRIT_API_INSECURE_HTTPS=true',\n    'GERRIT_CREDENTIALS_ID=cid',\n    'GERRIT_PROJECT=%s',\n    'BRANCH_NAME=%s',\n  ]) {\n    gerritReview labels: ['%s': %s], message: '%s'\n  }\n}", this.g.getClient().remoteAddress().getHostString(), this.g.getClient().remoteAddress().getPort(), projectName, branch, label, score, message), true));
        ReviewInput reviewInput = new ReviewInputForObjectMapper().label(label, score).message(message);
        reviewInput.drafts = ReviewInput.DraftHandling.PUBLISH;
        reviewInput.tag = "autogenerated:jenkins";
        reviewInput.notify = NotifyHandling.OWNER;
        this.g.getClient().when(HttpRequest.request((String)String.format("/a/changes/%s/revisions/%s/review", this.changeId, revision)).withMethod("POST").withBody((Body)JsonBody.json((Object)reviewInput))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withBody((BodyWithContentType)JsonBody.json(Collections.emptyMap())));
        WorkflowRun run = (WorkflowRun)this.j.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        String log = JenkinsRule.getLog((Run)run);
        this.g.getClient().verify(HttpRequest.request((String)String.format("/a/changes/%s/revisions/%s/review", this.changeId, revision)), VerificationTimes.once());
    }

    @Test
    public void gerritReviewStepInvokeLabelsTest() throws Exception {
        int revision = 1;
        String label1 = "Verfied";
        int score1 = -1;
        String label2 = "CI-Review";
        int score2 = -1;
        String message = "Does not work";
        String branch = String.format("%02d/%d/%d", 21, 4321, revision);
        UsernamePasswordCredentialsImpl c = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, "cid", "cid", "USERNAME", "PASSWORD");
        ((CredentialsStore)CredentialsProvider.lookupStores((ModelObject)this.j.jenkins).iterator().next()).addCredentials(Domain.global(), (Credentials)c);
        WorkflowJob p = (WorkflowJob)this.j.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition(String.format("node {\n  withEnv([\n    'GERRIT_API_URL=https://%s:%s',\n    'GERRIT_API_INSECURE_HTTPS=true',\n    'GERRIT_CREDENTIALS_ID=cid',\n    'GERRIT_PROJECT=%s',\n    'BRANCH_NAME=%s',\n  ]) {\n    gerritReview labels: ['%s': %s, '%s': %s], message: '%s', notify: 'NONE'\n  }\n}", this.g.getClient().remoteAddress().getHostString(), this.g.getClient().remoteAddress().getPort(), projectName, branch, label1, score1, label2, score2, message), true));
        ReviewInput reviewInput = new ReviewInputForObjectMapper().label(label1, score1).label(label2, score2).message(message);
        reviewInput.drafts = ReviewInput.DraftHandling.PUBLISH;
        reviewInput.tag = "autogenerated:jenkins";
        reviewInput.notify = NotifyHandling.NONE;
        this.g.getClient().when(HttpRequest.request((String)String.format("/a/changes/%s/revisions/%s/review", this.changeId, revision)).withMethod("POST").withBody((Body)JsonBody.json((Object)reviewInput))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withBody((BodyWithContentType)JsonBody.json(Collections.emptyMap())));
        WorkflowRun run = (WorkflowRun)this.j.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        String log = JenkinsRule.getLog((Run)run);
        this.g.getClient().verify(HttpRequest.request((String)String.format("/a/changes/%s/revisions/%s/review", this.changeId, revision)), VerificationTimes.once());
    }

    private void setupServerVersion() {
        this.g.getClient().when(HttpRequest.request((String)"/a/config/server/version").withMethod("GET")).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withBody(")]}'\n\"" + this.gerritVersion + "\""));
    }

    @JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
    private static class ReviewInputForObjectMapper
    extends ReviewInput {
        private ReviewInputForObjectMapper() {
        }
    }
}

