/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit.workflow;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.google.gerrit.extensions.api.changes.DraftInput;
import hudson.model.Action;
import hudson.model.ModelObject;
import hudson.model.Run;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.Future;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.mockserver.junit.MockServerRule;
import org.mockserver.model.Body;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.JsonBody;
import org.mockserver.verify.VerificationTimes;

public class GerritCommentStepTest {
    @Rule
    public MockServerRule g = new MockServerRule((Object)this);
    @Rule
    public JenkinsRule j = new JenkinsRule();
    String projectName = "test-project";
    int changeNumber = 4321;
    int revision = 1;
    String path = "/path/to/file";
    int line = 1;
    String message = "Invalid spacing";
    String branch = String.format("%02d/%d/%d", this.changeNumber % 100, this.changeNumber, this.revision);
    DraftInput draftInput;

    @Before
    public void setup() {
        this.draftInput = new DraftInput();
        this.draftInput.path = this.path;
        this.draftInput.line = this.line;
        this.draftInput.message = this.message;
    }

    @Test
    public void gerritCommentStepInvokeTestForGerrit2_14() throws Exception {
        WorkflowJob p = this.createWorkflowJob(this.path, this.line, this.message, this.branch);
        this.setupServerVersion("2.14");
        this.setupDrafts(String.valueOf(this.changeNumber));
        WorkflowRun run = (WorkflowRun)this.j.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        String log = JenkinsRule.getLog((Run)run);
        this.verifyDrafts(String.valueOf(this.changeNumber));
    }

    @Test
    public void gerritCommentStepInvokeTestForGerrit2_16() throws Exception {
        WorkflowJob p = this.createWorkflowJob(this.path, this.line, this.message, this.branch);
        this.setupServerVersion("2.16");
        String changeId = String.format("%s~%s", this.projectName, this.changeNumber);
        this.setupDrafts(changeId);
        WorkflowRun run = (WorkflowRun)this.j.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        String log = JenkinsRule.getLog((Run)run);
        this.verifyDrafts(changeId);
    }

    private void verifyDrafts(String changeId) {
        this.g.getClient().verify(HttpRequest.request((String)String.format("/a/changes/%s/revisions/%s/drafts", changeId, this.revision)), VerificationTimes.once());
    }

    private void setupServerVersion(String version) {
        this.g.getClient().when(HttpRequest.request((String)"/a/config/server/version").withMethod("GET")).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withBody(")]}'\n\"" + version + "\""));
    }

    private void setupDrafts(String changeId) {
        this.g.getClient().when(HttpRequest.request((String)String.format("/a/changes/%s/revisions/%s/drafts", changeId, this.revision)).withMethod("PUT").withBody((Body)JsonBody.json((Object)this.draftInput))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withBody((BodyWithContentType)JsonBody.json(Collections.emptyMap())));
    }

    private WorkflowJob createWorkflowJob(String path, int line, String message, String branch) throws IOException {
        UsernamePasswordCredentialsImpl c = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, "cid", "cid", "USERNAME", "PASSWORD");
        ((CredentialsStore)CredentialsProvider.lookupStores((ModelObject)this.j.jenkins).iterator().next()).addCredentials(Domain.global(), (Credentials)c);
        WorkflowJob p = (WorkflowJob)this.j.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition(String.format("node {\n  withEnv([\n    'GERRIT_API_URL=https://%s:%s/',\n    'GERRIT_PROJECT=%s',\n    'GERRIT_API_INSECURE_HTTPS=true',\n    'GERRIT_CREDENTIALS_ID=cid',\n    'BRANCH_NAME=%s',\n  ]) {\n    gerritComment path: '%s', line: %s, message: '%s'\n  }\n}", this.g.getClient().remoteAddress().getHostString(), this.g.getClient().remoteAddress().getPort(), this.projectName, branch, path, line, message), true));
        return p;
    }
}

