/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit.workflow;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.google.gerrit.plugins.checks.api.CheckInput;
import com.google.gerrit.plugins.checks.api.CheckState;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import hudson.model.Action;
import hudson.model.ModelObject;
import hudson.model.Result;
import hudson.model.Run;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Collections;
import java.util.concurrent.Future;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.mockserver.junit.MockServerRule;
import org.mockserver.model.Body;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.model.Format;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.JsonBody;
import org.mockserver.verify.VerificationTimes;

public class GerritCheckStepTest {
    @Rule
    public MockServerRule g = new MockServerRule((Object)this);
    @Rule
    public JenkinsRule j = new JenkinsRule();

    @Test
    public void gerritCheckStepInvokeFailSSLValidationTest() throws Exception {
        int changeId = 4321;
        int revision = 1;
        String checkerUuid = "checker";
        String checkStatus = "SUCCESSFUL";
        String message = "Does not work";
        String branch = String.format("%02d/%d/%d", changeId % 100, changeId, revision);
        UsernamePasswordCredentialsImpl c = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, "cid", "cid", "USERNAME", "PASSWORD");
        ((CredentialsStore)CredentialsProvider.lookupStores((ModelObject)this.j.jenkins).iterator().next()).addCredentials(Domain.global(), (Credentials)c);
        WorkflowJob p = (WorkflowJob)this.j.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition(String.format("node {\n  withEnv([\n    'GERRIT_API_URL=https://%s:%s/a/project',\n    'GERRIT_CREDENTIALS_ID=cid',\n    'BRANCH_NAME=%s',\n  ]) {\n    gerritCheck checks: [%s: '%s'], message: '%s'\n  }\n}", this.g.getClient().remoteAddress().getHostString(), this.g.getClient().remoteAddress().getPort(), branch, checkerUuid, checkStatus, message), true));
        WorkflowRun run = (WorkflowRun)this.j.assertBuildStatus(Result.FAILURE, (Future)p.scheduleBuild2(0, new Action[0]));
        String log = JenkinsRule.getLog((Run)run);
        this.j.assertLogContains("javax.net.ssl.SSLHandshakeException", (Run)run);
    }

    @Test
    public void gerritCheckStepInvokeTest() throws Exception {
        int changeId = 4321;
        int revision = 1;
        String checkerUuid = "checker";
        String checkStatus = "SUCCESSFUL";
        String message = "Does work";
        String branch = String.format("%02d/%d/%d", changeId % 100, changeId, revision);
        UsernamePasswordCredentialsImpl c = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, "cid", "cid", "USERNAME", "PASSWORD");
        ((CredentialsStore)CredentialsProvider.lookupStores((ModelObject)this.j.jenkins).iterator().next()).addCredentials(Domain.global(), (Credentials)c);
        WorkflowJob p = (WorkflowJob)this.j.jenkins.createProject(WorkflowJob.class, "q");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition(String.format("node {\n  withEnv([\n    'GERRIT_API_URL=https://%s:%s/a/project',\n    'GERRIT_API_INSECURE_HTTPS=true',\n    'GERRIT_CREDENTIALS_ID=cid',\n    'BRANCH_NAME=%s',\n  ]) {\n    gerritCheck checks: [%s: '%s'], message: '%s'\n  }\n}", this.g.getClient().remoteAddress().getHostString(), this.g.getClient().remoteAddress().getPort(), branch, checkerUuid, checkStatus, message), true));
        String expectedUrl = String.format("/a/changes/%s/revisions/%s/checks/", changeId, revision);
        CheckInputForObjectMapper checkInput = new CheckInputForObjectMapper();
        checkInput.checkerUuid = checkerUuid;
        checkInput.state = CheckState.valueOf((String)checkStatus);
        checkInput.message = message;
        checkInput.url = this.j.getURL().toString() + p.getUrl() + "1/console";
        this.g.getClient().when(HttpRequest.request((String)expectedUrl).withMethod("POST").withBody((Body)JsonBody.json((Object)((Object)checkInput)))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withBody((BodyWithContentType)JsonBody.json(Collections.emptyMap())));
        WorkflowRun run = (WorkflowRun)this.j.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        String log = JenkinsRule.getLog((Run)run);
        this.g.getClient().verify(HttpRequest.request((String)expectedUrl), VerificationTimes.once());
    }

    @Test
    public void gerritCheckStepTestWithUrlSet() throws Exception {
        int changeId = 4321;
        int revision = 1;
        String checkerUuid = "checker";
        String checkStatus = "SUCCESSFUL";
        String url = "https://example.com/test";
        String branch = String.format("%02d/%d/%d", changeId % 100, changeId, revision);
        UsernamePasswordCredentialsImpl c = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, "cid", "cid", "USERNAME", "PASSWORD");
        ((CredentialsStore)CredentialsProvider.lookupStores((ModelObject)this.j.jenkins).iterator().next()).addCredentials(Domain.global(), (Credentials)c);
        WorkflowJob p = (WorkflowJob)this.j.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition(String.format("node {\n  withEnv([\n    'GERRIT_API_URL=https://%s:%s/a/project',\n    'GERRIT_API_INSECURE_HTTPS=true',\n    'GERRIT_CREDENTIALS_ID=cid',\n    'BRANCH_NAME=%s',\n  ]) {\n    gerritCheck checks: [%s: '%s'], url: '%s'\n  }\n}", this.g.getClient().remoteAddress().getHostString(), this.g.getClient().remoteAddress().getPort(), branch, checkerUuid, checkStatus, url), true));
        String expectedUrl = String.format("/a/changes/%s/revisions/%s/checks/", changeId, revision);
        CheckInputForObjectMapper checkInput = new CheckInputForObjectMapper();
        checkInput.checkerUuid = checkerUuid;
        checkInput.state = CheckState.valueOf((String)checkStatus);
        checkInput.url = url;
        this.g.getClient().when(HttpRequest.request((String)expectedUrl).withMethod("POST").withBody((Body)JsonBody.json((Object)((Object)checkInput)))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withBody((BodyWithContentType)JsonBody.json(Collections.emptyMap())));
        WorkflowRun run = (WorkflowRun)this.j.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        String log = JenkinsRule.getLog((Run)run);
        this.g.getClient().verify(HttpRequest.request((String)expectedUrl), VerificationTimes.once());
    }

    @Test
    public void gerritCheckStepTestProducesUtcTimestamps() throws Exception {
        long beginTestEpoch = Instant.now().getEpochSecond();
        int changeId = 4321;
        int revision = 1;
        String checkerUuid = "checker";
        String checkStatus = "RUNNING";
        String branch = String.format("%02d/%d/%d", changeId % 100, changeId, revision);
        UsernamePasswordCredentialsImpl c = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, "cid", "cid", "USERNAME", "PASSWORD");
        ((CredentialsStore)CredentialsProvider.lookupStores((ModelObject)this.j.jenkins).iterator().next()).addCredentials(Domain.global(), (Credentials)c);
        WorkflowJob p = (WorkflowJob)this.j.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition(String.format("node {\n  withEnv([\n    'GERRIT_API_URL=https://%s:%s/a/project',\n    'GERRIT_API_INSECURE_HTTPS=true',\n    'GERRIT_CREDENTIALS_ID=cid',\n    'BRANCH_NAME=%s',\n  ]) {\n    gerritCheck checks: [%s: '%s']\n  }\n}", this.g.getClient().remoteAddress().getHostString(), this.g.getClient().remoteAddress().getPort(), branch, checkerUuid, checkStatus), true));
        String expectedUrl = String.format("/a/changes/%s/revisions/%s/checks/", changeId, revision);
        this.g.getClient().when(HttpRequest.request((String)expectedUrl).withMethod("POST")).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withBody((BodyWithContentType)JsonBody.json(Collections.emptyMap())));
        WorkflowRun run = (WorkflowRun)this.j.assertBuildStatusSuccess((Future)p.scheduleBuild2(0, new Action[0]));
        String log = JenkinsRule.getLog((Run)run);
        this.g.getClient().verify(HttpRequest.request((String)expectedUrl), VerificationTimes.once());
        String startedAt = this.requestBodyJson(expectedUrl).getAsJsonObject().get("started").getAsString();
        Assert.assertThat((String)"Timestamp should be in SQL format", (Object)startedAt, GerritCheckStepTest.matchesPattern("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}\\.\\d{3}"));
        long parsedEpoch = GerritCheckStepTest.instantFromUtc(startedAt).getEpochSecond();
        long endTestEpoch = Instant.now().getEpochSecond();
        Assert.assertThat((String)"Timestamp parsed as UTC should be between the time ranges of the test.", (Object)parsedEpoch, (Matcher)CoreMatchers.allOf((Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(endTestEpoch)), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(beginTestEpoch))));
    }

    private static Instant instantFromUtc(String s) {
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter().withZone(ZoneOffset.UTC);
        return ZonedDateTime.parse(s, formatter).toInstant();
    }

    private JsonElement requestBodyJson(String requestUrl) {
        Gson gson = new Gson();
        String request = this.g.getClient().retrieveRecordedRequests(HttpRequest.request((String)requestUrl), Format.JSON);
        JsonElement el = (JsonElement)gson.fromJson(request, JsonElement.class);
        String innerBody = el.getAsJsonArray().get(0).getAsJsonObject().getAsJsonObject("body").get("string").getAsString();
        return (JsonElement)gson.fromJson(innerBody, JsonElement.class);
    }

    private static Matcher<String> matchesPattern(final String pattern) {
        return new TypeSafeMatcher<String>(){

            protected boolean matchesSafely(String s) {
                return s.matches(pattern);
            }

            public void describeTo(Description description) {
                description.appendText("matchesPattern /" + pattern + "/");
            }
        };
    }

    @JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
    private static class CheckInputForObjectMapper
    extends CheckInput {
        private CheckInputForObjectMapper() {
        }
    }
}

