/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.google.gerrit.plugins.checks.api.CheckState;
import com.google.gerrit.plugins.checks.api.CheckablePatchSetInfo;
import com.google.gerrit.plugins.checks.api.PendingCheckInfo;
import com.google.gerrit.plugins.checks.api.PendingChecksInfo;
import hudson.model.ModelObject;
import hudson.model.TaskListener;
import hudson.util.StreamTaskListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import jenkins.plugins.gerrit.ChangeSCMHead;
import jenkins.plugins.gerrit.GerritSCMSource;
import jenkins.plugins.gerrit.GerritSCMSourceContext;
import jenkins.plugins.gerrit.GerritSCMSourceRequest;
import jenkins.plugins.gerrit.PendingChecksFilter;
import jenkins.plugins.gerrit.traits.FilterChecksTrait;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMSourceRequest;
import org.eclipse.jgit.lib.ObjectId;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.mockserver.junit.MockServerRule;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.JsonBody;

public class PendingChecksFilterTests {
    @Rule
    public MockServerRule g = new MockServerRule((Object)this);
    @Rule
    public JenkinsRule j = new JenkinsRule();
    private static final String checkerUuid = "test:checker";
    private static GerritSCMSourceContext context;
    private static PendingChecksFilter filter;
    private static ArrayList<PendingChecksInfo> pendingChecksInfos;
    private static HashMap<String, List<String>> query;
    private GerritSCMSourceRequest request;

    @BeforeClass
    public static void setupClass() throws Exception {
        context = new GerritSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none());
        context.wantFilterForPendingChecks(true);
        context.withChecksQueryOperator(FilterChecksTrait.ChecksQueryOperator.ID);
        context.withChecksQueryString(checkerUuid);
        pendingChecksInfos = new ArrayList();
        pendingChecksInfos.add(PendingChecksFilterTests.getPendingChecksInfo("test", 11111, 1, CheckState.NOT_STARTED));
        query = new HashMap();
        query.put("query", Arrays.asList("checker:test:checker"));
        filter = new PendingChecksFilter();
    }

    @Before
    public void setup() throws Exception {
        UsernamePasswordCredentialsImpl c = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, "cid", "cid", "USERNAME", "PASSWORD");
        ((CredentialsStore)CredentialsProvider.lookupStores((ModelObject)this.j.jenkins).iterator().next()).addCredentials(Domain.global(), (Credentials)c);
        this.g.getClient().when(HttpRequest.request((String)"/a/plugins/checks/checks.pending/").withQueryStringParameters(query).withMethod("GET")).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withBody((BodyWithContentType)JsonBody.json(pendingChecksInfos)));
        GerritSCMSource source = new GerritSCMSource(String.format("https://%s:%s/a/test", this.g.getClient().remoteAddress().getHostName(), this.g.getClient().remoteAddress().getPort()));
        source.setInsecureHttps(Boolean.valueOf(true));
        source.setCredentialsId("cid");
        this.request = context.newRequest((SCMSource)source, (TaskListener)new StreamTaskListener());
    }

    @Test
    public void testPendingChecksFilterExcludesNonPending() throws Exception {
        HashMap<String, ObjectId> refs = new HashMap<String, ObjectId>();
        refs.put("refs/changes/22/22222/2", ObjectId.zeroId());
        ChangeSCMHead head = new ChangeSCMHead(refs.entrySet().iterator().next(), "master", new HashSet());
        Assert.assertTrue((boolean)filter.isExcluded((SCMSourceRequest)this.request, (SCMHead)head));
    }

    @Test
    public void testPendingChecksFilterIncludesPending() throws Exception {
        HashMap<String, ObjectId> refs = new HashMap<String, ObjectId>();
        refs.put("refs/changes/11/11111/1", ObjectId.zeroId());
        ChangeSCMHead head = new ChangeSCMHead(refs.entrySet().iterator().next(), "master", new HashSet());
        Assert.assertFalse((boolean)filter.isExcluded((SCMSourceRequest)this.request, (SCMHead)head));
    }

    private static PendingChecksInfo getPendingChecksInfo(String project, int changeNumber, int patchSetNumber, CheckState state) {
        CheckablePatchSetInfoMapper checkablePatchSet = new CheckablePatchSetInfoMapper();
        checkablePatchSet.repository = project;
        checkablePatchSet.changeNumber = changeNumber;
        checkablePatchSet.patchSetId = patchSetNumber;
        PendingChecksInfoMapper pendingChecksInfo = new PendingChecksInfoMapper();
        pendingChecksInfo.patchSet = checkablePatchSet;
        pendingChecksInfo.pendingChecks = new HashMap();
        pendingChecksInfo.pendingChecks.put(checkerUuid, new PendingCheckInfo(state));
        return pendingChecksInfo;
    }

    @JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
    private static class CheckablePatchSetInfoMapper
    extends CheckablePatchSetInfo {
        private CheckablePatchSetInfoMapper() {
        }
    }

    @JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
    private static class PendingChecksInfoMapper
    extends PendingChecksInfo {
        private PendingChecksInfoMapper() {
        }
    }
}

