/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import com.google.gerrit.extensions.common.ProjectInfo;
import java.net.URISyntaxException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import jenkins.plugins.gerrit.GerritApiBuilder;
import jenkins.plugins.gerrit.GerritMockServerRule;
import jenkins.plugins.gerrit.PagedCodeProjectsRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class PagedCodeProjectsRequestTest {
    private static final int CHUNK_MAX_SIZE = 4;
    @Rule
    public GerritMockServerRule g = new GerritMockServerRule(this);
    private PagedCodeProjectsRequest request;

    @Before
    public void beforeEach() throws URISyntaxException {
        this.request = new PagedCodeProjectsRequest(new GerritApiBuilder().gerritApiUrl(this.g.getUrl()).build(), 4);
    }

    @Test
    public void testSinglePartialChunk() {
        this.test(3);
    }

    @Test
    public void testSingleFullChunk() {
        this.test(4);
    }

    @Test
    public void testAFullChunkAndAPartialOne() {
        this.test(5);
    }

    @Test
    public void test2FullChunksAndAPartialOne() {
        this.test(9);
    }

    private void test(int numberOfProjects) {
        for (int i = 1; i <= numberOfProjects; ++i) {
            this.g.addProject(this.createProject(String.valueOf(i)));
        }
        List collectedProjectIds = StreamSupport.stream(this.request.spliterator(), false).map(projectInfo -> projectInfo.id).collect(Collectors.toList());
        List projectRepositoryIds = this.g.getProjectRepository().stream().map(projectInfo -> projectInfo.id).collect(Collectors.toList());
        Assert.assertEquals(projectRepositoryIds, collectedProjectIds);
    }

    private ProjectInfo createProject(String name) {
        ProjectInfo projectInfo = new ProjectInfo();
        projectInfo.id = name;
        return projectInfo;
    }
}

