/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import com.cloudbees.hudson.plugins.folder.Folder;
import com.google.common.net.MediaType;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.HttpRequestWithBody;
import hudson.model.Result;
import hudson.util.Secret;
import hudson.util.TestSecret;
import java.io.IOException;
import jenkins.branch.BranchSource;
import jenkins.plugins.gerrit.GerritSCMSource;
import jenkins.plugins.git.GitSampleRepoRule;
import jenkins.scm.api.SCMSource;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.mockito.Mockito;

public class GerritWebHookTriggerTest {
    private Secret apiKeySecret = TestSecret.newTestSecret();
    @Rule
    public JenkinsRule j = new JenkinsRule();
    @Rule
    public GitSampleRepoRule g = new GitSampleRepoRule();
    String repoName = "somerepo";
    String gerritEventBody = String.format("{\"project\":{\"name\":\"%s\"}, \"type\":\"ref-updated\"}", this.repoName);
    private String projectName = "someproject";

    @Test
    public void shouldTriggerMultiBranchPipelineProjectWithoutFolderWithApiKeyParameter() throws Exception {
        WorkflowMultiBranchProject mp = this.createMultiBranchPipelineProject(new BranchSource((SCMSource)this.getGerritSCMSource(this.apiKeySecret)));
        Assert.assertEquals((long)200L, (long)this.httpStatusOfPostGerritEventBodyToWebhookURIWithApiKey());
        this.j.waitUntilNoActivity();
        Assert.assertEquals((Object)Result.SUCCESS, (Object)mp.getIndexing().getResult());
    }

    @Test
    public void shouldTriggerMultiBranchPipelineProjectWithoutApiKeySecret() throws Exception {
        WorkflowMultiBranchProject mp = this.createMultiBranchPipelineProject(new BranchSource((SCMSource)this.getGerritSCMSource()));
        Assert.assertEquals((long)200L, (long)this.httpStatusOfPostGerritEventBodyToWebhookURIWithApiKey());
        this.j.waitUntilNoActivity();
        Assert.assertEquals((Object)Result.SUCCESS, (Object)mp.getIndexing().getResult());
    }

    @Test
    public void shouldNotTriggerWithoutApiKeyParameter() throws Exception {
        WorkflowMultiBranchProject mp = this.createMultiBranchPipelineProject(new BranchSource((SCMSource)this.getGerritSCMSource(this.apiKeySecret)));
        Assert.assertEquals((long)200L, (long)this.httpStatusOfPostGerritEventBodyToWebhookURIWithoutApiKey());
        this.j.waitUntilNoActivity();
        Assert.assertNull((Object)mp.getIndexing().getResult());
    }

    @Test
    public void shouldNotTriggerWithEmptyApiKeyParameter() throws Exception {
        WorkflowMultiBranchProject mp = this.createMultiBranchPipelineProject(new BranchSource((SCMSource)this.getGerritSCMSource(this.apiKeySecret)));
        Assert.assertEquals((long)200L, (long)this.httpStatusOfPostGerritEventBodyToWebhookURIWithEmptyApiKey());
        this.j.waitUntilNoActivity();
        Assert.assertNull((Object)mp.getIndexing().getResult());
    }

    @Test
    public void shouldTriggerMultiBranchPipelineProjectWithoutFolderAndWithApiKeyParameterAndJobNameParameter() throws Exception {
        WorkflowMultiBranchProject mp = this.createMultiBranchPipelineProject(new BranchSource((SCMSource)this.getGerritSCMSource(this.apiKeySecret)));
        Assert.assertEquals((long)200L, (long)this.httpStatusOfPostGerritEventBodyToWebhookURIWithApiKey("secret-ef16dbe5fdb54", this.projectName));
        this.j.waitUntilNoActivity();
        Assert.assertEquals((Object)Result.SUCCESS, (Object)mp.getIndexing().getResult());
    }

    @Test
    public void shouldTriggerMultiBranchPipelineProjectWithFolderWithApiKeyParameter() throws Exception {
        WorkflowMultiBranchProject mp = this.createMultiBranchPipelineProject("folder", new BranchSource((SCMSource)this.getGerritSCMSource(this.apiKeySecret)));
        Assert.assertEquals((long)200L, (long)this.httpStatusOfPostGerritEventBodyToWebhookURIWithApiKey());
        this.j.waitUntilNoActivity();
        Assert.assertEquals((Object)Result.SUCCESS, (Object)mp.getIndexing().getResult());
    }

    @Test
    public void shouldTriggerMultiBranchPipelineProjectWithFolderAndWithJobNameParameter() throws Exception {
        WorkflowMultiBranchProject mp = this.createMultiBranchPipelineProject("folder", new BranchSource((SCMSource)this.getGerritSCMSource(this.apiKeySecret)));
        Assert.assertEquals((long)200L, (long)this.httpStatusOfPostGerritEventBodyToWebhookURIWithApiKey("secret-ef16dbe5fdb54", this.projectName));
        this.j.waitUntilNoActivity();
        Assert.assertEquals((Object)Result.SUCCESS, (Object)mp.getIndexing().getResult());
    }

    @Test
    public void shouldNotTriggerMultiBranchPipelineProjectWithInvalidJobNameParameter() throws Exception {
        WorkflowMultiBranchProject mp = this.createMultiBranchPipelineProject(new BranchSource((SCMSource)this.getGerritSCMSource(this.apiKeySecret)));
        Assert.assertEquals((long)200L, (long)this.httpStatusOfPostGerritEventBodyToWebhookURIWithApiKey(null, "bogus" + this.projectName));
        Assert.assertNull((Object)mp.getIndexing().getResult());
    }

    @Test
    public void shouldNotTriggerMultiBranchPipelineProjectWithoutApiKeyParameter() throws Exception {
        WorkflowMultiBranchProject mp = this.createMultiBranchPipelineProject(new BranchSource((SCMSource)this.getGerritSCMSource(this.apiKeySecret)));
        Assert.assertEquals((long)200L, (long)this.httpStatusOfPostGerritEventBodyToWebhookURIWithInvalidApiKey());
        Assert.assertNull((Object)mp.getIndexing().getResult());
    }

    @Test
    public void shouldNotTriggerMultiBranchPipelineProjectWithFolderAndWithInvalidApiKeyParameter() throws Exception {
        WorkflowMultiBranchProject mp = this.createMultiBranchPipelineProject(new BranchSource((SCMSource)this.getGerritSCMSource(this.apiKeySecret)));
        Assert.assertEquals((long)200L, (long)this.httpStatusOfPostGerritEventBodyToWebhookURIWithApiKey("bogus" + this.apiKeySecret, null));
        Assert.assertNull((Object)mp.getIndexing().getResult());
    }

    private WorkflowMultiBranchProject createMultiBranchPipelineProject(BranchSource branchSource) throws IOException {
        WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)this.j.jenkins.createProject(WorkflowMultiBranchProject.class, this.projectName);
        mp.getSourcesList().add((Object)branchSource);
        return mp;
    }

    private WorkflowMultiBranchProject createMultiBranchPipelineProject(String folderName, BranchSource branchSource) throws IOException {
        Folder f = (Folder)this.j.jenkins.createProject(Folder.class, folderName);
        WorkflowMultiBranchProject mp = (WorkflowMultiBranchProject)f.createProject(WorkflowMultiBranchProject.class, this.projectName);
        mp.getSourcesList().add((Object)branchSource);
        return mp;
    }

    private int httpStatusOfPostGerritEventBodyToWebhookURIWithApiKey() throws UnirestException {
        return this.httpStatusOfPostGerritEventBodyToWebhookURIWithApiKey("secret-ef16dbe5fdb54", null);
    }

    private int httpStatusOfPostGerritEventBodyToWebhookURIWithInvalidApiKey() throws UnirestException {
        return this.httpStatusOfPostGerritEventBodyToWebhookURIWithApiKey("invalid-api-key", null);
    }

    private int httpStatusOfPostGerritEventBodyToWebhookURIWithEmptyApiKey() throws UnirestException {
        return this.httpStatusOfPostGerritEventBodyToWebhookURIWithApiKey("", null);
    }

    private int httpStatusOfPostGerritEventBodyToWebhookURIWithoutApiKey() throws UnirestException {
        return this.httpStatusOfPostGerritEventBodyToWebhookURIWithApiKey(null, null);
    }

    private int httpStatusOfPostGerritEventBodyToWebhookURIWithApiKey(String apiKey, String jobName) throws UnirestException {
        HttpRequestWithBody request = Unirest.post((String)this.gerritPluginWebhookURI()).header("Content-Type", MediaType.JSON_UTF_8.toString());
        if (apiKey != null) {
            request = request.queryString("apiKey", (Object)apiKey);
        }
        if (jobName != null) {
            request = request.queryString("jobName", (Object)jobName);
        }
        return request.body(this.gerritEventBody).asString().getStatus();
    }

    private GerritSCMSource getGerritSCMSource() {
        return this.getGerritSCMSource(null);
    }

    private GerritSCMSource getGerritSCMSource(Secret apiKey) {
        GerritSCMSource mockSource = (GerritSCMSource)Mockito.mock(GerritSCMSource.class);
        Mockito.when((Object)mockSource.getRemote()).thenReturn((Object)"somerepo");
        Mockito.when((Object)mockSource.getApiKey()).thenReturn((Object)apiKey);
        return mockSource;
    }

    private String gerritPluginWebhookURI() {
        return this.j.jenkins.getRootUrl() + "gerrit-webhook/";
    }
}

