/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import com.google.gson.JsonParseException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import jenkins.plugins.gerrit.GerritProjectEvent;
import jenkins.plugins.gerrit.GerritWebHook;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class GerritWebHookTest {
    String testRepoName = "testrepo";
    GerritWebHook webHook = new GerritWebHook();

    @Test
    public void shouldExtractHttpPostBodyWhenLengthIsUnknown() throws Exception {
        byte[] gerritEventBody = "{\"project\":{\"name\":\"testrepo\"}, \"type\":\"ref-updated\"}".getBytes(StandardCharsets.UTF_8);
        Optional projectEvent = this.webHook.getBody(this.getInMemoryServletRequest(gerritEventBody));
        Assert.assertTrue((boolean)projectEvent.isPresent());
        Assert.assertEquals((Object)this.testRepoName, (Object)((GerritProjectEvent)projectEvent.get()).project.name);
    }

    @Test
    public void shouldIngoreNotInterestingEvents() throws Exception {
        Assert.assertFalse((boolean)this.webHook.getBody(this.getInMemoryServletRequest("{\"type\": \"dont-care\"}".getBytes())).isPresent());
    }

    @Test(expected=JsonParseException.class)
    public void shouldThrowExceptionForInvalidJsonEvents() throws Exception {
        this.webHook.getBody(this.getInMemoryServletRequest("this-is-invalid-JSON".getBytes()));
    }

    private HttpServletRequest getInMemoryServletRequest(byte[] body) throws IOException {
        final int gerritEventBodySize = body.length;
        final ByteArrayInputStream bodyInputStream = new ByteArrayInputStream(body);
        HttpServletRequest mockedServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockedServletRequest.getContentLength()).thenReturn((Object)-1);
        Mockito.when((Object)mockedServletRequest.getInputStream()).thenReturn((Object)new ServletInputStream(){
            private int readIdx = 0;

            public boolean isFinished() {
                return this.readIdx >= gerritEventBodySize;
            }

            public boolean isReady() {
                return true;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() throws IOException {
                return bodyInputStream.read();
            }
        });
        return mockedServletRequest;
    }
}

