/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import com.google.gerrit.extensions.api.GerritApi;
import jenkins.plugins.gerrit.GerritApiBuilder;
import jenkins.plugins.gerrit.GerritVersion;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockserver.junit.MockServerRule;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;

public class GerritVersionTest {
    @Rule
    public MockServerRule g = new MockServerRule((Object)this);

    @Test
    public void testisVersionBelow215() throws Exception {
        GerritApi gerritApi = new GerritApiBuilder().gerritApiUrl("http://localhost:" + this.g.getPort()).credentials(null, null).build();
        Assert.assertTrue((boolean)GerritVersion.isVersionBelow215((GerritApi)gerritApi));
        this.setGerritServerVersion("1.0");
        Assert.assertTrue((boolean)GerritVersion.isVersionBelow215((GerritApi)gerritApi));
        this.setGerritServerVersion("1.1.1");
        Assert.assertTrue((boolean)GerritVersion.isVersionBelow215((GerritApi)gerritApi));
        this.setGerritServerVersion("2");
        Assert.assertTrue((boolean)GerritVersion.isVersionBelow215((GerritApi)gerritApi));
        this.setGerritServerVersion("2.0");
        Assert.assertTrue((boolean)GerritVersion.isVersionBelow215((GerritApi)gerritApi));
        this.setGerritServerVersion("2.0.19");
        Assert.assertTrue((boolean)GerritVersion.isVersionBelow215((GerritApi)gerritApi));
        this.setGerritServerVersion("2.14");
        Assert.assertTrue((boolean)GerritVersion.isVersionBelow215((GerritApi)gerritApi));
        this.setGerritServerVersion("2.14.99");
        Assert.assertTrue((boolean)GerritVersion.isVersionBelow215((GerritApi)gerritApi));
        this.setGerritServerVersion("2.15");
        Assert.assertFalse((boolean)GerritVersion.isVersionBelow215((GerritApi)gerritApi));
        this.setGerritServerVersion("2.15.0");
        Assert.assertFalse((boolean)GerritVersion.isVersionBelow215((GerritApi)gerritApi));
        this.setGerritServerVersion("2.15.99");
        Assert.assertFalse((boolean)GerritVersion.isVersionBelow215((GerritApi)gerritApi));
        this.setGerritServerVersion("2.16");
        Assert.assertFalse((boolean)GerritVersion.isVersionBelow215((GerritApi)gerritApi));
        this.setGerritServerVersion("3");
        Assert.assertFalse((boolean)GerritVersion.isVersionBelow215((GerritApi)gerritApi));
        this.setGerritServerVersion("3.0");
        Assert.assertFalse((boolean)GerritVersion.isVersionBelow215((GerritApi)gerritApi));
        this.setGerritServerVersion("3.0.0");
        Assert.assertFalse((boolean)GerritVersion.isVersionBelow215((GerritApi)gerritApi));
        this.setGerritServerVersion("3.1");
        Assert.assertFalse((boolean)GerritVersion.isVersionBelow215((GerritApi)gerritApi));
        this.setGerritServerVersion("null");
        Assert.assertFalse((boolean)GerritVersion.isVersionBelow215((GerritApi)gerritApi));
        this.setGerritServerVersion("");
        Assert.assertFalse((boolean)GerritVersion.isVersionBelow215((GerritApi)gerritApi));
        this.setGerritServerVersion(" ");
        Assert.assertFalse((boolean)GerritVersion.isVersionBelow215((GerritApi)gerritApi));
        this.setGerritServerVersion(".");
        Assert.assertFalse((boolean)GerritVersion.isVersionBelow215((GerritApi)gerritApi));
        this.setGerritServerVersion("..");
        Assert.assertFalse((boolean)GerritVersion.isVersionBelow215((GerritApi)gerritApi));
        this.setGerritServerVersion("Error");
        Assert.assertFalse((boolean)GerritVersion.isVersionBelow215((GerritApi)gerritApi));
    }

    private void setGerritServerVersion(String version) {
        this.g.getClient().reset();
        this.g.getClient().when(HttpRequest.request((String)"/config/server/version").withMethod("GET")).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withBody(")]}'\n\"" + version + "\""));
    }
}

