/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import java.net.URISyntaxException;
import jenkins.plugins.gerrit.GerritURI;
import org.eclipse.jgit.transport.URIish;
import org.junit.Assert;
import org.junit.Test;

public class GerritURITest {
    @Test
    public void projectNameWithSlashesIsExtractedFromHTTPURI() throws URISyntaxException {
        GerritURI gerritURI = new GerritURI(new URIish("http://host/a/project/with/slashes"));
        Assert.assertEquals((Object)"project/with/slashes", (Object)gerritURI.getProject());
    }

    @Test
    public void anonymousAccessProjectNameIsExtractedFromHTTPURI() throws URISyntaxException {
        GerritURI gerritURI = new GerritURI(new URIish("http://host/organisation/project"));
        Assert.assertEquals((Object)"organisation/project", (Object)gerritURI.getProject());
    }

    @Test
    public void projectNameEndingWithDotGitIsExtractedFromHTTPURI() throws URISyntaxException {
        GerritURI gerritURI = new GerritURI(new URIish("http://host/project.git"));
        Assert.assertEquals((Object)"project", (Object)gerritURI.getProject());
    }

    @Test
    public void firstAInURIIsConsideredTheProjectMarker() throws URISyntaxException {
        GerritURI gerritURI = new GerritURI(new URIish("http://host/prefix/a/project/a/suffix"));
        Assert.assertEquals((Object)"/prefix", (Object)gerritURI.getPrefix());
        Assert.assertEquals((Object)"project/a/suffix", (Object)gerritURI.getProject());
    }

    @Test
    public void projectNameWithSlashesIsExtractedFromHTTPSURI() throws URISyntaxException {
        GerritURI gerritURI = new GerritURI(new URIish("https://host/a/project/with/slashes"));
        Assert.assertEquals((Object)"project/with/slashes", (Object)gerritURI.getProject());
    }

    @Test
    public void projectNameWithSlashesIsExtractedFromSSHURI() throws URISyntaxException {
        GerritURI gerritURI = new GerritURI(new URIish("ssh://username@host:29418/project/with/slashes"));
        Assert.assertEquals((Object)"project/with/slashes", (Object)gerritURI.getProject());
    }

    @Test
    public void prefixWithSlashesIsExtractedFromHTTPURI() throws URISyntaxException {
        GerritURI gerritURI = new GerritURI(new URIish("http://host/prefix/with/slashes/a/project"));
        Assert.assertEquals((Object)"/prefix/with/slashes", (Object)gerritURI.getPrefix());
    }

    @Test
    public void prefixIsExtractedFromHTTPURIWithChangeWithProjectWithDots() throws URISyntaxException {
        GerritURI gerritURI = new GerritURI(new URIish("http://host/c/project/with/d.o.t.s/+/9916469"));
        Assert.assertEquals((Object)"/", (Object)gerritURI.getPrefix());
    }

    @Test
    public void prefixIsExtractedFromHTTPURIWithChangeWithoutProject() throws URISyntaxException {
        GerritURI gerritURI = new GerritURI(new URIish("http://host/c/9916469"));
        Assert.assertEquals((Object)"/", (Object)gerritURI.getPrefix());
    }

    @Test
    public void prefixIsExtractedFromHTTPURIForChangeWithoutC() throws URISyntaxException {
        GerritURI gerritURI = new GerritURI(new URIish("http://host/9916469"));
        Assert.assertEquals((Object)"/", (Object)gerritURI.getPrefix());
    }

    @Test
    public void prefixWithSlashesIsExtractedFromHTTPSURI() throws URISyntaxException {
        GerritURI gerritURI = new GerritURI(new URIish("https://host/prefix/with/slashes/a/project"));
        Assert.assertEquals((Object)"/prefix/with/slashes", (Object)gerritURI.getPrefix());
    }

    @Test
    public void prefixOfSSHURIIsAlwaysEmpty() throws URISyntaxException {
        GerritURI gerritURI = new GerritURI(new URIish("ssh://username@host:29418/project/with/slashes"));
        Assert.assertEquals((Object)"", (Object)gerritURI.getPrefix());
    }

    @Test
    public void httpUriWithoutPrefixAreAccepted() throws URISyntaxException {
        GerritURI gerritURI = new GerritURI(new URIish("https://host"));
        Assert.assertEquals((Object)"/", (Object)gerritURI.getPrefix());
    }

    @Test
    public void settingProjectToBaseUriReturnsTheProjectUri() throws URISyntaxException {
        GerritURI gerritURI = new GerritURI(new URIish("https://host"));
        Assert.assertEquals((Object)"https://host/foo", (Object)gerritURI.setProject("foo").toString());
    }

    @Test
    public void settingProjectToProjectUriReturnsTheNewProjectUri() throws URISyntaxException {
        GerritURI gerritURI = new GerritURI(new URIish("https://host/foo"));
        Assert.assertEquals((Object)"https://host/bar", (Object)gerritURI.setProject("bar").toString());
    }
}

