/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import com.google.gerrit.extensions.common.ProjectInfo;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.TaskListener;
import hudson.util.LogTaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.gerrit.GerritMockServerRule;
import jenkins.plugins.gerrit.GerritSCMNavigator;
import jenkins.plugins.gerrit.GerritSCMSource;
import jenkins.plugins.git.traits.RefSpecsSCMSourceTrait;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceObserver;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.trait.SCMSourceTrait;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;

public class GerritSCMNavigatorTest {
    @Rule
    public GerritMockServerRule g = new GerritMockServerRule(this);

    @Test
    public void testId() {
        GerritSCMNavigator navigator = new GerritSCMNavigator(this.g.getUrl(), false, null, Collections.emptyList());
        Assert.assertEquals((Object)(GerritSCMNavigator.class.getName() + "::server-url=" + this.g.getUrl() + "::credentials-id=null"), (Object)navigator.getId());
    }

    @Test
    public void visitSources() throws IOException, InterruptedException {
        this.g.addProject(this.createProject("foo"));
        this.g.addProject(this.createProject("bar"));
        GerritSCMNavigator navigator = new GerritSCMNavigator(this.g.getUrl(), false, null, Collections.emptyList());
        RecordingSCMSourceObserver sourceObserver = new RecordingSCMSourceObserver();
        navigator.visitSources((SCMSourceObserver)sourceObserver);
        Assert.assertEquals((long)2L, (long)sourceObserver.observedProjectNames.size());
        Assert.assertTrue((boolean)sourceObserver.observedProjectNames.contains("foo"));
        Assert.assertTrue((boolean)sourceObserver.observedProjectNames.contains("bar"));
        Assert.assertEquals((long)2L, (long)sourceObserver.addedSourceByProjectName.size());
        this.assertSCMSourceValidity((SCMSource)sourceObserver.addedSourceByProjectName.get("foo"), "foo", navigator, Collections.emptyList());
        this.assertSCMSourceValidity((SCMSource)sourceObserver.addedSourceByProjectName.get("bar"), "bar", navigator, Collections.emptyList());
    }

    @Test
    public void sourcesShareCommonPropertiesWithTheNavigator() throws IOException, InterruptedException {
        ProjectInfo project = this.createProject("foo");
        this.g.addProject(project);
        RefSpecsSCMSourceTrait trait = new RefSpecsSCMSourceTrait(new String[0]);
        GerritSCMNavigator navigator = new GerritSCMNavigator(this.g.getUrl(), true, "my-credentials", Collections.singletonList(trait));
        RecordingSCMSourceObserver sourceObserver = new RecordingSCMSourceObserver();
        navigator.visitSources((SCMSourceObserver)sourceObserver);
        Assert.assertEquals((long)1L, (long)sourceObserver.observedProjectNames.size());
        Assert.assertEquals((Object)project.id, sourceObserver.observedProjectNames.get(0));
        Assert.assertEquals((long)1L, (long)sourceObserver.addedSourceByProjectName.size());
        this.assertSCMSourceValidity((SCMSource)sourceObserver.addedSourceByProjectName.get(project.id), project.id, navigator, Collections.singletonList(trait));
    }

    private void assertSCMSourceValidity(SCMSource scmSource, String projectName, GerritSCMNavigator navigator, List<SCMSourceTrait> traits) {
        GerritSCMSource source = (GerritSCMSource)scmSource;
        Assert.assertEquals((Object)(StringUtils.appendIfMissing((String)navigator.getServerUrl(), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + projectName), (Object)source.getRemote());
        Assert.assertEquals((Object)navigator.isInsecureHttps(), (Object)source.getInsecureHttps());
        Assert.assertEquals((Object)navigator.getCredentialsId(), (Object)source.getCredentialsId());
        Assert.assertEquals((long)traits.size(), (long)source.getTraits().size());
        traits.forEach(trait -> Assert.assertTrue((boolean)source.getTraits().contains(trait)));
    }

    private ProjectInfo createProject(String name) {
        ProjectInfo projectInfo = new ProjectInfo();
        projectInfo.id = name;
        return projectInfo;
    }

    private static class RecordingSCMSourceObserver
    extends SCMSourceObserver {
        private final List<String> observedProjectNames = new ArrayList<String>();
        private final Map<String, SCMSource> addedSourceByProjectName = new HashMap<String, SCMSource>();

        private RecordingSCMSourceObserver() {
        }

        @NonNull
        public SCMSourceOwner getContext() {
            return (SCMSourceOwner)Mockito.mock(SCMSourceOwner.class);
        }

        @NonNull
        public TaskListener getListener() {
            return new LogTaskListener(Logger.getAnonymousLogger(), Level.INFO);
        }

        @NonNull
        public SCMSourceObserver.ProjectObserver observe(final @NonNull String projectName) throws IllegalArgumentException {
            this.observedProjectNames.add(projectName);
            return new SCMSourceObserver.ProjectObserver(){

                public void addSource(@NonNull SCMSource source) {
                    if (addedSourceByProjectName.put(projectName, source) == null) {
                        return;
                    }
                    throw new IllegalArgumentException("Duplicate source for project " + projectName);
                }

                public void addAttribute(@NonNull String key, @Nullable Object value) throws IllegalArgumentException, ClassCastException {
                }

                public void complete() throws IllegalStateException {
                }
            };
        }

        public void addAttribute(@NonNull String key, @Nullable Object value) throws IllegalArgumentException, ClassCastException {
        }
    }
}

