/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import hudson.model.Item;
import java.util.Collections;
import jenkins.branch.OrganizationFolder;
import jenkins.plugins.gerrit.GerritSCMNavigator;
import jenkins.plugins.git.traits.RefSpecsSCMSourceTrait;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class GerritSCMNavigatorDescriptorTest {
    @Rule
    public JenkinsRule j = new JenkinsRule();

    @Test
    public void testConfigRoundtrip() throws Exception {
        OrganizationFolder organizationFolder = (OrganizationFolder)this.j.createProject(OrganizationFolder.class);
        organizationFolder.getSCMNavigators().add(new GerritSCMNavigator());
        organizationFolder = (OrganizationFolder)this.j.configRoundtrip((Item)organizationFolder);
        this.j.assertEqualDataBoundBeans((Object)new GerritSCMNavigator(), organizationFolder.getSCMNavigators().get(0));
    }

    @Test
    public void testConfigRoundTripWithCustomValues() throws Exception {
        OrganizationFolder organizationFolder = (OrganizationFolder)this.j.createProject(OrganizationFolder.class);
        GerritSCMNavigator genuineNavigator = new GerritSCMNavigator("https://gerrit.example.org", true, "my-credentials-id", Collections.singletonList(new RefSpecsSCMSourceTrait(new String[]{"+refs/heads/*:refs/remotes/@{remote}/*"})));
        organizationFolder.getSCMNavigators().add(genuineNavigator);
        organizationFolder = (OrganizationFolder)this.j.configRoundtrip((Item)organizationFolder);
        this.j.assertEqualDataBoundBeans((Object)genuineNavigator, organizationFolder.getSCMNavigators().get(0));
    }
}

