/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import jenkins.plugins.gerrit.GerritProjectEvent;
import jenkins.plugins.gerrit.GerritProjectName;
import jenkins.plugins.gerrit.RefUpdateProjectName;
import org.junit.Assert;
import org.junit.Test;

public class GerritProjectEventTest {
    private String eventType = "ref-updated";
    private String projectName = "dotgit";
    private String refUpdateProjectName = "dotgit";
    private String remoteUrlWithoutDotGit = String.format("http://host/a/project/without/%s", this.projectName);
    private String remoteUrlWithDotGit = String.format("http://host/a/project/with/%s.git", this.projectName);

    @Test
    public void projectEventRemoteUrlMatchesEndsWithoutDotGit() {
        GerritProjectEvent e = new GerritProjectEvent(new GerritProjectName(this.projectName), new RefUpdateProjectName(this.refUpdateProjectName), this.eventType);
        Assert.assertTrue((boolean)e.matches(this.remoteUrlWithoutDotGit));
    }

    @Test
    public void projectEventRemoteUrlMatchesEndsWithDotGit() {
        GerritProjectEvent e = new GerritProjectEvent(new GerritProjectName(this.projectName), new RefUpdateProjectName(this.refUpdateProjectName), this.eventType);
        Assert.assertTrue((boolean)e.matches(this.remoteUrlWithDotGit));
    }

    @Test
    public void projectEventRemoteUrlNoMatchNullProjectName() {
        GerritProjectEvent e = new GerritProjectEvent(null, null, null);
        Assert.assertFalse((boolean)e.matches(this.remoteUrlWithoutDotGit));
    }
}

