/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import com.google.gerrit.extensions.common.ProjectInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mockserver.junit.MockServerRule;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.JsonBody;

public class GerritMockServerRule
implements TestRule {
    private final MockServerRule serverRule;
    private final Map<String, ProjectInfo> projectRepository = new LinkedHashMap<String, ProjectInfo>();

    public GerritMockServerRule(Object target) {
        this.serverRule = new MockServerRule(target);
    }

    public String getUrl() {
        return "http://localhost:" + this.serverRule.getPort();
    }

    public void addProject(ProjectInfo projectInfo) {
        this.projectRepository.put(projectInfo.id, projectInfo);
    }

    public List<ProjectInfo> getProjectRepository() {
        return new ArrayList<ProjectInfo>(this.projectRepository.values());
    }

    public Statement apply(final Statement base, Description description) {
        return this.serverRule.apply(new Statement(){

            public void evaluate() throws Throwable {
                GerritMockServerRule.this.projectRepository.clear();
                GerritMockServerRule.this.setupExpectations();
                base.evaluate();
            }
        }, description);
    }

    private void setupExpectations() {
        this.serverRule.getClient().when(HttpRequest.request((String)"/projects/").withMethod("GET")).callback(httpRequest -> {
            int start = Optional.ofNullable(httpRequest.getFirstQueryStringParameter("S")).filter(StringUtils::isNotBlank).map(Integer::parseInt).orElse(0);
            int limit = Optional.ofNullable(httpRequest.getFirstQueryStringParameter("n")).filter(StringUtils::isNotBlank).map(Integer::parseInt).orElse(this.projectRepository.size());
            if (start >= this.projectRepository.size()) {
                return HttpResponse.response().withStatusCode(Integer.valueOf(200)).withBody((BodyWithContentType)JsonBody.json(Collections.emptyMap()));
            }
            Map projectSlice = new ArrayList<ProjectInfo>(this.projectRepository.values()).subList(start, Math.min(start + limit, this.projectRepository.size())).stream().collect(Collectors.toMap(projectInfo -> projectInfo.id, Function.identity(), (u, v) -> {
                throw new IllegalStateException(String.format("Duplicate key %s", u));
            }, LinkedHashMap::new));
            return HttpResponse.response().withStatusCode(Integer.valueOf(200)).withBody((BodyWithContentType)JsonBody.json((Object)projectSlice));
        });
    }
}

