/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import com.google.common.truth.Truth;
import com.google.gerrit.extensions.client.ChangeKind;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.RevisionInfo;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import jenkins.plugins.gerrit.GerritEnvironmentContributor;
import jenkins.plugins.gerrit.GerritURI;
import org.eclipse.jgit.transport.URIish;
import org.junit.Before;
import org.junit.Test;

public class GerritEnvironmentContributorTest {
    public static final String TEST_PROJECT_NAME = "myproject";
    public static final AccountInfo TEST_ACCOUNT_INFO_JOHN_DOE = new AccountInfo("John Doe", "john.doe@mycompany.com");
    public static final String TEST_BRANCH = "mybranch";
    public static final String TEST_CHANGE_SUBJECT = "This is a test change";
    public static final String TEST_CHANGE_TOPIC = "test-topic";
    public static final String TEST_CHANGE_ID = "I2ff60b01ab0e2305fdf8739cd884038091f2b888";
    public static final String TEST_CHANGE_ID_TRIPLET = "myproject~mybranch~I2ff60b01ab0e2305fdf8739cd884038091f2b888";
    public static final int TEST_PATCHSET_NUMBER = 2;
    public static final int TEST_CHANGE_NUMBER = 1;
    public static final String TEST_CHANGE_KIND = ChangeKind.TRIVIAL_REBASE.name();
    public static final int TEST_REVERTED_CHANGE_NUMBER = 3;
    public static final String TEST_CHANGE_REF_NAME = "refs/changes/" + String.format("%02d", 1) + "/" + 1 + "/" + 2;
    public static final AccountInfo TEST_ACCOUNT_INFO_MATT_SMITH = new AccountInfo("Matt Smith", "matt.smith@mycompany.com");
    public static final String TEST_GERRIT_URL = "http://gerrit.mycompany.com";
    private ChangeInfo changeInfo;
    private GerritURI gerritURI;

    @Before
    public void setup() throws URISyntaxException {
        this.changeInfo = new ChangeInfo(){
            {
                this._number = 1;
                this.project = GerritEnvironmentContributorTest.TEST_PROJECT_NAME;
                this.owner = TEST_ACCOUNT_INFO_JOHN_DOE;
                this.branch = GerritEnvironmentContributorTest.TEST_BRANCH;
                this.subject = GerritEnvironmentContributorTest.TEST_CHANGE_SUBJECT;
                this.topic = GerritEnvironmentContributorTest.TEST_CHANGE_TOPIC;
                this.changeId = GerritEnvironmentContributorTest.TEST_CHANGE_ID;
                this.id = GerritEnvironmentContributorTest.TEST_CHANGE_ID_TRIPLET;
                this.revisions = new HashMap<String, RevisionInfo>(){
                    {
                        this.put(Integer.toString(2), new RevisionInfo(){
                            {
                                this._number = 2;
                                this.uploader = TEST_ACCOUNT_INFO_MATT_SMITH;
                                this.ref = TEST_CHANGE_REF_NAME;
                                this.kind = ChangeKind.TRIVIAL_REBASE;
                            }
                        });
                    }
                };
                this.revertOf = 3;
            }
        };
        this.gerritURI = new GerritURI(new URIish(TEST_GERRIT_URL));
    }

    @Test
    public void testBuildEnvironmentForChangeInfo() throws Exception {
        Map changeEnvs = new GerritEnvironmentContributor.ChangeInfoInvisibleAction(Optional.of(this.changeInfo), 2, this.gerritURI).getChangeEnvs();
        HashMap<String, String> expectedMap = new HashMap<String, String>(){
            {
                this.put("GERRIT_BRANCH", GerritEnvironmentContributorTest.TEST_BRANCH);
                this.put("GERRIT_PATCHSET_UPLOADER_NAME", GerritEnvironmentContributorTest.TEST_ACCOUNT_INFO_MATT_SMITH.name);
                this.put("GERRIT_CHANGE_OWNER", GerritEnvironmentContributorTest.TEST_ACCOUNT_INFO_JOHN_DOE.name + " <" + GerritEnvironmentContributorTest.TEST_ACCOUNT_INFO_JOHN_DOE.email + ">");
                this.put("GERRIT_CHANGE_OWNER_NAME", GerritEnvironmentContributorTest.TEST_ACCOUNT_INFO_JOHN_DOE.name);
                this.put("GERRIT_CHANGE_OWNER_EMAIL", GerritEnvironmentContributorTest.TEST_ACCOUNT_INFO_JOHN_DOE.email);
                this.put("GERRIT_PATCHSET_UPLOADER", GerritEnvironmentContributorTest.TEST_ACCOUNT_INFO_MATT_SMITH.name + " <" + GerritEnvironmentContributorTest.TEST_ACCOUNT_INFO_MATT_SMITH.email + ">");
                this.put("GERRIT_PATCHSET_UPLOADER_NAME", GerritEnvironmentContributorTest.TEST_ACCOUNT_INFO_MATT_SMITH.name);
                this.put("GERRIT_PATCHSET_UPLOADER_EMAIL", GerritEnvironmentContributorTest.TEST_ACCOUNT_INFO_MATT_SMITH.email);
                this.put("GERRIT_CHANGE_SUBJECT", GerritEnvironmentContributorTest.TEST_CHANGE_SUBJECT);
                this.put("GERRIT_TOPIC", GerritEnvironmentContributorTest.TEST_CHANGE_TOPIC);
                this.put("GERRIT_REFNAME", TEST_CHANGE_REF_NAME);
                this.put("GERRIT_CHANGE_URL", "http://gerrit.mycompany.com/1");
                this.put("GERRIT_CHANGE_NUMBER", Integer.toString(1));
                this.put("GERRIT_PATCHSET_KIND", TEST_CHANGE_KIND);
                this.put("GERRIT_PATCHSET_REVISION", Integer.toString(2));
                this.put("GERRIT_PATCHSET_NUMBER", Integer.toString(2));
                this.put("GERRIT_CHANGE_WIP_STATE", "false");
                this.put("GERRIT_CHANGE_ID", GerritEnvironmentContributorTest.TEST_CHANGE_ID_TRIPLET);
                this.put("GERRIT_CHANGE_PRIVATE_STATE", "false");
                this.put("GERRIT_REFSPEC", TEST_CHANGE_REF_NAME);
                this.put("GERRIT_REVERTED_CHANGE_NUMBER", Integer.toString(3));
            }
        };
        Truth.assertThat((Map)changeEnvs).containsExactlyEntriesIn((Map)expectedMap);
    }

    @Test
    public void testBuildEnvironmentForPrivateChange() {
        this.changeInfo.isPrivate = true;
        Truth.assertThat((Map)new GerritEnvironmentContributor.ChangeInfoInvisibleAction(Optional.of(this.changeInfo), 2, this.gerritURI).getChangeEnvs()).containsEntry((Object)"GERRIT_CHANGE_PRIVATE_STATE", (Object)"true");
    }

    @Test
    public void testBuildEnvironmentForWipChange() {
        this.changeInfo.workInProgress = true;
        Truth.assertThat((Map)new GerritEnvironmentContributor.ChangeInfoInvisibleAction(Optional.of(this.changeInfo), 2, this.gerritURI).getChangeEnvs()).containsEntry((Object)"GERRIT_CHANGE_WIP_STATE", (Object)"true");
    }
}

