/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import java.util.Collections;
import java.util.HashMap;
import jenkins.plugins.gerrit.GerritChange;
import org.junit.Assert;
import org.junit.Test;

public class GerritChangeTest {
    @Test
    public void testNone() throws Exception {
        GerritChange change = new GerritChange(Collections.emptyMap(), System.out);
        Assert.assertFalse((boolean)change.valid());
    }

    @Test
    public void testGerritCodeReviewPlugin() throws Exception {
        Integer changeId = 1234;
        Integer revision = 1;
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("BRANCH_NAME", String.format("%02d/%d/%d", changeId % 100, changeId, revision));
        GerritChange change = new GerritChange(env, System.out);
        Assert.assertTrue((boolean)change.valid());
        Assert.assertEquals((Object)changeId, (Object)change.getChangeId());
        Assert.assertEquals((Object)revision, (Object)change.getRevision());
    }

    @Test
    public void testGerritTriggerPlugin() throws Exception {
        Integer changeId = 1234;
        Integer revision = 1;
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("GERRIT_CHANGE_NUMBER", changeId.toString());
        env.put("GERRIT_PATCHSET_NUMBER", revision.toString());
        GerritChange change = new GerritChange(env, System.out);
        Assert.assertTrue((boolean)change.valid());
        Assert.assertEquals((Object)changeId, (Object)change.getChangeId());
        Assert.assertEquals((Object)revision, (Object)change.getRevision());
    }
}

