/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import com.google.gerrit.extensions.api.GerritApi;
import com.google.gerrit.plugins.checks.client.GerritChecksApi;
import java.net.URISyntaxException;
import jenkins.plugins.gerrit.GerritApiBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockserver.junit.MockServerRule;

public class GerritApiBuilderTest {
    @Rule
    public MockServerRule g = new MockServerRule((Object)this);

    @Test
    public void testShouldReturnValidGerritApiWithoutCredentials() throws URISyntaxException {
        GerritApi restApi = this.getGerritApiBuilderWithUri().credentials(null, null).build();
        Assert.assertNotNull((Object)restApi);
    }

    @Test
    public void testShouldReturnValidGerritChecksApiWithoutCredentials() throws URISyntaxException {
        GerritChecksApi restApi = this.getGerritApiBuilderWithUri().credentials(null, null).buildChecksApi();
        Assert.assertNotNull((Object)restApi);
    }

    private GerritApiBuilder getGerritApiBuilderWithUri() throws URISyntaxException {
        return new GerritApiBuilder().gerritApiUrl("http://gerrit.mycompany.com/a/project");
    }

    @Test
    public void testShouldReturnNullGerritApiWithoutCredentials() throws URISyntaxException {
        Assert.assertNull((Object)this.getGerritApiBuilderWithUri().requireAuthentication().build());
    }

    @Test
    public void testShouldReturnNullGerritChecksApiWithoutCredentials() throws URISyntaxException {
        Assert.assertNull((Object)this.getGerritApiBuilderWithUri().requireAuthentication().buildChecksApi());
    }

    @Test
    public void testShouldReturnNullGerritApiWithNullCredentials() throws URISyntaxException {
        Assert.assertNull((Object)this.getGerritApiBuilderWithUri().credentials(null, null).requireAuthentication().build());
    }

    @Test
    public void testShouldReturnNullGerritChecksApiWithNullCredentials() throws URISyntaxException {
        Assert.assertNull((Object)this.getGerritApiBuilderWithUri().credentials(null, null).requireAuthentication().buildChecksApi());
    }

    @Test
    public void testShouldReturnNullGerritApiWithEmptyCredentials() throws URISyntaxException {
        Assert.assertNull((Object)this.getGerritApiBuilderWithUri().credentials("", "").requireAuthentication().build());
    }

    @Test
    public void testShouldReturnNullGerritChecksApiWithEmptyCredentials() throws URISyntaxException {
        Assert.assertNull((Object)this.getGerritApiBuilderWithUri().credentials("", "").requireAuthentication().buildChecksApi());
    }
}

