/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import com.google.gerrit.plugins.checks.api.CheckInfo;
import com.google.gerrit.plugins.checks.api.CheckState;
import com.google.gerrit.plugins.checks.client.AbstractEndpoint;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;

public class ChecksTest {
    @Test
    public void shouldDeserializeCheckInfo() throws ParseException {
        String testRepo = "test-repo";
        int changeNumber = 1;
        int patchSetId = 2;
        String checkerUuid = "test:my-checker";
        CheckState state = CheckState.NOT_STARTED;
        String url = "https://foo.corp.com/test-checker/results/123";
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date created = dateFormat.parse("2021-09-05 10:11:12.5678");
        Date updated = dateFormat.parse("2021-09-06 11:12:13.6789");
        String checksJsonResponse = String.format("{\n      \"repository\": \"%s\",\n      \"change_number\": %d,\n      \"patch_set_id\": %d,\n      \"checker_uuid\": \"%s\",\n      \"state\": \"%s\",\n      \"url\": \"%s\",\n      \"created\": \"%s\",\n      \"updated\": \"%s\"\n    }", testRepo, changeNumber, patchSetId, checkerUuid, state, url, dateFormat.format(created), dateFormat.format(updated));
        CheckInfo checkInfo = (CheckInfo)AbstractEndpoint.JsonBodyParser.parseResponse((String)checksJsonResponse, (Type)new TypeToken<CheckInfo>(){}.getType());
        Assert.assertNotNull((Object)checkInfo);
        Assert.assertEquals((Object)testRepo, (Object)checkInfo.repository);
        Assert.assertEquals((long)changeNumber, (long)checkInfo.changeNumber);
        Assert.assertEquals((long)patchSetId, (long)checkInfo.patchSetId);
        Assert.assertEquals((Object)checkerUuid, (Object)checkInfo.checkerUuid);
        Assert.assertEquals((Object)state, (Object)checkInfo.state);
        Assert.assertEquals((Object)url, (Object)checkInfo.url);
        Assert.assertEquals((Object)created, (Object)checkInfo.created);
        Assert.assertEquals((Object)updated, (Object)checkInfo.updated);
    }
}

