/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import java.util.HashMap;
import java.util.HashSet;
import jenkins.plugins.gerrit.ChangeSCMHead;
import jenkins.plugins.gerrit.ChangeSCMRevision;
import jenkins.scm.api.mixin.ChangeRequestSCMRevision;
import org.eclipse.jgit.lib.ObjectId;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChangeSCMRevisionTest {
    public HashMap<String, ObjectId> refs;

    @Before
    public void setup() {
        this.refs = new HashMap();
        this.refs.put("/refs/changes/11/11111/1", ObjectId.zeroId());
    }

    @Test
    public void testEquivalentReturnsFalseIfPendingChecks() {
        HashSet<String> checkerUuids = new HashSet<String>();
        checkerUuids.add("checker");
        ChangeSCMRevision revision = new ChangeSCMRevision(new ChangeSCMHead(this.refs.entrySet().iterator().next(), "master", checkerUuids), "1234");
        Assert.assertFalse((boolean)revision.equivalent((ChangeRequestSCMRevision)revision));
    }

    @Test
    public void testEquivalentReturnsFalseIfNoPendingChecks() {
        HashSet checkerUuids = new HashSet();
        ChangeSCMRevision revision = new ChangeSCMRevision(new ChangeSCMHead(this.refs.entrySet().iterator().next(), "master", checkerUuids), "1234");
        Assert.assertTrue((boolean)revision.equivalent((ChangeRequestSCMRevision)revision));
    }
}

