/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.gerrit;

import java.util.List;
import jenkins.plugins.gerrit.AbstractGerritSCMSource;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.impl.mock.MockSCMRevision;
import org.junit.Assert;
import org.junit.Test;

public class AbstractGerritSCMSourceTest {
    @Test
    public void providedRefSpecsAreNotRemoved() {
        SCMHead head = new SCMHead("52/47452/3");
        GitSCMBuilder gitSCMBuilder = new GitSCMBuilder(head, (SCMRevision)new MockSCMRevision(head, "foo"), "origin", "secret");
        gitSCMBuilder.withRefSpec("foo");
        MyGerritSCMSource gerritSCMSource = new MyGerritSCMSource();
        gerritSCMSource.decorate(gitSCMBuilder);
        List refSpecs = gitSCMBuilder.refSpecs();
        Assert.assertEquals((long)2L, (long)refSpecs.size());
        Assert.assertEquals((Object)"foo", refSpecs.get(0));
        Assert.assertEquals((Object)"refs/changes/52/47452/3:refs/remotes/origin/52/47452/3", refSpecs.get(1));
    }

    private static class MyGerritSCMSource
    extends AbstractGerritSCMSource {
        private MyGerritSCMSource() {
        }

        public String getCredentialsId() {
            throw new UnsupportedOperationException();
        }

        public String getRemote() {
            throw new UnsupportedOperationException();
        }
    }
}

