// CHECKSTYLE:OFF

package jenkins.plugins.gerrit.traits;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code FilterChecksTrait.schemeOperator}: {@code Query pending
     * checks of multiple checkers having the same scheme}.
     * 
     * @return
     *     {@code Query pending checks of multiple checkers having the same
     *     scheme}
     */
    public static String FilterChecksTrait_schemeOperator() {
        return holder.format("FilterChecksTrait.schemeOperator");
    }

    /**
     * Key {@code FilterChecksTrait.schemeOperator}: {@code Query pending
     * checks of multiple checkers having the same scheme}.
     * 
     * @return
     *     {@code Query pending checks of multiple checkers having the same
     *     scheme}
     */
    public static Localizable _FilterChecksTrait_schemeOperator() {
        return new Localizable(holder, "FilterChecksTrait.schemeOperator");
    }

    /**
     * Key {@code ChangeDiscoveryTrait.displayName}: {@code Discover open
     * changes}.
     * 
     * @return
     *     {@code Discover open changes}
     */
    public static String ChangeDiscoveryTrait_displayName() {
        return holder.format("ChangeDiscoveryTrait.displayName");
    }

    /**
     * Key {@code ChangeDiscoveryTrait.displayName}: {@code Discover open
     * changes}.
     * 
     * @return
     *     {@code Discover open changes}
     */
    public static Localizable _ChangeDiscoveryTrait_displayName() {
        return new Localizable(holder, "ChangeDiscoveryTrait.displayName");
    }

    /**
     * Key {@code FilterChecksTrait.displayName}: {@code Filter by Pending
     * Checks}.
     * 
     * @return
     *     {@code Filter by Pending Checks}
     */
    public static String FilterChecksTrait_displayName() {
        return holder.format("FilterChecksTrait.displayName");
    }

    /**
     * Key {@code FilterChecksTrait.displayName}: {@code Filter by Pending
     * Checks}.
     * 
     * @return
     *     {@code Filter by Pending Checks}
     */
    public static Localizable _FilterChecksTrait_displayName() {
        return new Localizable(holder, "FilterChecksTrait.displayName");
    }

    /**
     * Key {@code ChangeDiscoveryTrait.pendingChecks}: {@code Query for
     * pending checks}.
     * 
     * @return
     *     {@code Query for pending checks}
     */
    public static String ChangeDiscoveryTrait_pendingChecks() {
        return holder.format("ChangeDiscoveryTrait.pendingChecks");
    }

    /**
     * Key {@code ChangeDiscoveryTrait.pendingChecks}: {@code Query for
     * pending checks}.
     * 
     * @return
     *     {@code Query for pending checks}
     */
    public static Localizable _ChangeDiscoveryTrait_pendingChecks() {
        return new Localizable(holder, "ChangeDiscoveryTrait.pendingChecks");
    }

    /**
     * Key {@code FilterChecksTrait.checkerIdOperator}: {@code Query pending
     * checks of a single checker by its ID}.
     * 
     * @return
     *     {@code Query pending checks of a single checker by its ID}
     */
    public static String FilterChecksTrait_checkerIdOperator() {
        return holder.format("FilterChecksTrait.checkerIdOperator");
    }

    /**
     * Key {@code FilterChecksTrait.checkerIdOperator}: {@code Query pending
     * checks of a single checker by its ID}.
     * 
     * @return
     *     {@code Query pending checks of a single checker by its ID}
     */
    public static Localizable _FilterChecksTrait_checkerIdOperator() {
        return new Localizable(holder, "FilterChecksTrait.checkerIdOperator");
    }

    /**
     * Key {@code ChangeDiscoveryTrait.openChanges}: {@code Query for open
     * changes}.
     * 
     * @return
     *     {@code Query for open changes}
     */
    public static String ChangeDiscoveryTrait_openChanges() {
        return holder.format("ChangeDiscoveryTrait.openChanges");
    }

    /**
     * Key {@code ChangeDiscoveryTrait.openChanges}: {@code Query for open
     * changes}.
     * 
     * @return
     *     {@code Query for open changes}
     */
    public static Localizable _ChangeDiscoveryTrait_openChanges() {
        return new Localizable(holder, "ChangeDiscoveryTrait.openChanges");
    }

}
