// CHECKSTYLE:OFF

package org.jenkinsci.plugins.DependencyCheck;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Dependency-Check Warnings
     * 
     */
    public static String Detail_header() {
        return holder.format("Detail.header");
    }

    /**
     * Dependency-Check Warnings
     * 
     */
    public static Localizable _Detail_header() {
        return new Localizable(holder, "Detail.header");
    }

    /**
     * Dependency-Check warnings trend graph (new vs. fixed)
     * 
     */
    public static String Portlet_WarningsNewVsFixedGraph() {
        return holder.format("Portlet.WarningsNewVsFixedGraph");
    }

    /**
     * Dependency-Check warnings trend graph (new vs. fixed)
     * 
     */
    public static Localizable _Portlet_WarningsNewVsFixedGraph() {
        return new Localizable(holder, "Portlet.WarningsNewVsFixedGraph");
    }

    /**
     * ERROR: Unable to create output directory
     * 
     */
    public static String Error_Output_Directory_Create() {
        return holder.format("Error.Output.Directory.Create");
    }

    /**
     * ERROR: Unable to create output directory
     * 
     */
    public static Localizable _Error_Output_Directory_Create() {
        return new Localizable(holder, "Error.Output.Directory.Create");
    }

    /**
     * CVEs
     * 
     */
    public static String Tab_Types() {
        return holder.format("Tab.Types");
    }

    /**
     * CVEs
     * 
     */
    public static Localizable _Tab_Types() {
        return new Localizable(holder, "Tab.Types");
    }

    /**
     * New Dependency-Check Warnings
     * 
     */
    public static String NewWarnings_Detail_header() {
        return holder.format("NewWarnings.Detail.header");
    }

    /**
     * New Dependency-Check Warnings
     * 
     */
    public static Localizable _NewWarnings_Detail_header() {
        return new Localizable(holder, "NewWarnings.Detail.header");
    }

    /**
     * Dependency-Check warnings per project
     * 
     */
    public static String Portlet_WarningsTable() {
        return holder.format("Portlet.WarningsTable");
    }

    /**
     * Dependency-Check warnings per project
     * 
     */
    public static Localizable _Portlet_WarningsTable() {
        return new Localizable(holder, "Portlet.WarningsTable");
    }

    /**
     * ERROR: Unable to create data directory
     * 
     */
    public static String Error_Data_Directory_Create() {
        return holder.format("Error.Data.Directory.Create");
    }

    /**
     * ERROR: Unable to create data directory
     * 
     */
    public static Localizable _Error_Data_Directory_Create() {
        return new Localizable(holder, "Error.Data.Directory.Create");
    }

    /**
     * Scanning:
     * 
     */
    public static String Executor_Scanning() {
        return holder.format("Executor.Scanning");
    }

    /**
     * Scanning:
     * 
     */
    public static Localizable _Executor_Scanning() {
        return new Localizable(holder, "Executor.Scanning");
    }

    /**
     * Dependency-Check: {0} warnings found.
     * 
     */
    public static String ResultAction_HealthReportMultipleItem(Object arg1) {
        return holder.format("ResultAction.HealthReportMultipleItem", arg1);
    }

    /**
     * Dependency-Check: {0} warnings found.
     * 
     */
    public static Localizable _ResultAction_HealthReportMultipleItem(Object arg1) {
        return new Localizable(holder, "ResultAction.HealthReportMultipleItem", arg1);
    }

    /**
     * OWASP Dependency-Check requires Java 7 or higher. Unable to continue.
     * 
     */
    public static String Failure_Java_Version() {
        return holder.format("Failure.Java.Version");
    }

    /**
     * OWASP Dependency-Check requires Java 7 or higher. Unable to continue.
     * 
     */
    public static Localizable _Failure_Java_Version() {
        return new Localizable(holder, "Failure.Java.Version");
    }

    /**
     * CWEs
     * 
     */
    public static String Tab_Categories() {
        return holder.format("Tab.Categories");
    }

    /**
     * CWEs
     * 
     */
    public static Localizable _Tab_Categories() {
        return new Localizable(holder, "Tab.Categories");
    }

    /**
     * Fixed Dependency-Check Warnings
     * 
     */
    public static String FixedWarnings_Detail_header() {
        return holder.format("FixedWarnings.Detail.header");
    }

    /**
     * Fixed Dependency-Check Warnings
     * 
     */
    public static Localizable _FixedWarnings_Detail_header() {
        return new Localizable(holder, "FixedWarnings.Detail.header");
    }

    /**
     * Unable to retrieve database properties
     * 
     */
    public static String Failure_Database_Properties() {
        return holder.format("Failure.Database.Properties");
    }

    /**
     * Unable to retrieve database properties
     * 
     */
    public static Localizable _Failure_Database_Properties() {
        return new Localizable(holder, "Failure.Database.Properties");
    }

    /**
     * Performing NVD update only
     * 
     */
    public static String Executor_Update_Only() {
        return holder.format("Executor.Update.Only");
    }

    /**
     * Performing NVD update only
     * 
     */
    public static Localizable _Executor_Update_Only() {
        return new Localizable(holder, "Executor.Update.Only");
    }

    /**
     * Unable to connect to the dependency-check database; job has stopped
     * 
     */
    public static String Failure_Database_Connect() {
        return holder.format("Failure.Database.Connect");
    }

    /**
     * Unable to connect to the dependency-check database; job has stopped
     * 
     */
    public static Localizable _Failure_Database_Connect() {
        return new Localizable(holder, "Failure.Database.Connect");
    }

    /**
     * Executing Dependency-Check with the following options:
     * 
     */
    public static String Executor_Display_Options() {
        return holder.format("Executor.Display.Options");
    }

    /**
     * Executing Dependency-Check with the following options:
     * 
     */
    public static Localizable _Executor_Display_Options() {
        return new Localizable(holder, "Executor.Display.Options");
    }

    /**
     * Dependency-Check: one warning found.
     * 
     */
    public static String ResultAction_HealthReportSingleItem() {
        return holder.format("ResultAction.HealthReportSingleItem");
    }

    /**
     * Dependency-Check: one warning found.
     * 
     */
    public static Localizable _ResultAction_HealthReportSingleItem() {
        return new Localizable(holder, "ResultAction.HealthReportSingleItem");
    }

    /**
     * Dependency-Check Result
     * 
     */
    public static String ResultAction_Header() {
        return holder.format("ResultAction.Header");
    }

    /**
     * Dependency-Check Result
     * 
     */
    public static Localizable _ResultAction_Header() {
        return new Localizable(holder, "ResultAction.Header");
    }

    /**
     * Dependency-Check warnings trend graph (priority distribution)
     * 
     */
    public static String Portlet_WarningsPriorityGraph() {
        return holder.format("Portlet.WarningsPriorityGraph");
    }

    /**
     * Dependency-Check warnings trend graph (priority distribution)
     * 
     */
    public static Localizable _Portlet_WarningsPriorityGraph() {
        return new Localizable(holder, "Portlet.WarningsPriorityGraph");
    }

    /**
     * WARNING: Suppression file does not exist. Omitting.
     * 
     */
    public static String Warning_Suppression_NonExist() {
        return holder.format("Warning.Suppression.NonExist");
    }

    /**
     * WARNING: Suppression file does not exist. Omitting.
     * 
     */
    public static Localizable _Warning_Suppression_NonExist() {
        return new Localizable(holder, "Warning.Suppression.NonExist");
    }

    /**
     * Invoke OWASP Dependency-Check NVD update only
     * 
     */
    public static String Builder_UpdateOnly_Name() {
        return holder.format("Builder.UpdateOnly.Name");
    }

    /**
     * Invoke OWASP Dependency-Check NVD update only
     * 
     */
    public static Localizable _Builder_UpdateOnly_Name() {
        return new Localizable(holder, "Builder.UpdateOnly.Name");
    }

    /**
     * Analyzing Dependencies
     * 
     */
    public static String Executor_Analyzing_Dependencies() {
        return holder.format("Executor.Analyzing.Dependencies");
    }

    /**
     * Analyzing Dependencies
     * 
     */
    public static Localizable _Executor_Analyzing_Dependencies() {
        return new Localizable(holder, "Executor.Analyzing.Dependencies");
    }

    /**
     * High
     * 
     */
    public static String Severity_High() {
        return holder.format("Severity.High");
    }

    /**
     * High
     * 
     */
    public static Localizable _Severity_High() {
        return new Localizable(holder, "Severity.High");
    }

    /**
     * Dependency-Check: no warnings found.
     * 
     */
    public static String ResultAction_HealthReportNoItem() {
        return holder.format("ResultAction.HealthReportNoItem");
    }

    /**
     * Dependency-Check: no warnings found.
     * 
     */
    public static Localizable _ResultAction_HealthReportNoItem() {
        return new Localizable(holder, "ResultAction.HealthReportNoItem");
    }

    /**
     * The scan path(s) specified are not valid. Please specify a valid path to scan.
     * 
     */
    public static String Executor_ScanPath_Invalid() {
        return holder.format("Executor.ScanPath.Invalid");
    }

    /**
     * The scan path(s) specified are not valid. Please specify a valid path to scan.
     * 
     */
    public static Localizable _Executor_ScanPath_Invalid() {
        return new Localizable(holder, "Executor.ScanPath.Invalid");
    }

    /**
     * Dependency-Check Warnings
     * 
     */
    public static String ProjectAction_Name() {
        return holder.format("ProjectAction.Name");
    }

    /**
     * Dependency-Check Warnings
     * 
     */
    public static Localizable _ProjectAction_Name() {
        return new Localizable(holder, "ProjectAction.Name");
    }

    /**
     * Dependency-Check Trend
     * 
     */
    public static String Trend_Name() {
        return holder.format("Trend.Name");
    }

    /**
     * Dependency-Check Trend
     * 
     */
    public static Localizable _Trend_Name() {
        return new Localizable(holder, "Trend.Name");
    }

    /**
     * Please specify the path and filename to the Dependency-Check JAR
     * 
     */
    public static String Form_Error_setupJar() {
        return holder.format("Form.Error.setupJar");
    }

    /**
     * Please specify the path and filename to the Dependency-Check JAR
     * 
     */
    public static Localizable _Form_Error_setupJar() {
        return new Localizable(holder, "Form.Error.setupJar");
    }

    /**
     * Publish OWASP Dependency-Check analysis results
     * 
     */
    public static String Publisher_Name() {
        return holder.format("Publisher.Name");
    }

    /**
     * Publish OWASP Dependency-Check analysis results
     * 
     */
    public static Localizable _Publisher_Name() {
        return new Localizable(holder, "Publisher.Name");
    }

    /**
     * Invoke OWASP Dependency-Check analysis
     * 
     */
    public static String Builder_Name() {
        return holder.format("Builder.Name");
    }

    /**
     * Invoke OWASP Dependency-Check analysis
     * 
     */
    public static Localizable _Builder_Name() {
        return new Localizable(holder, "Builder.Name");
    }

    /**
     * Low
     * 
     */
    public static String Severity_Low() {
        return holder.format("Severity.Low");
    }

    /**
     * Low
     * 
     */
    public static Localizable _Severity_Low() {
        return new Localizable(holder, "Severity.Low");
    }

    /**
     * ERROR: An error occurred attempting to validate the existence of suppression file.
     * 
     */
    public static String Error_Suppression_NonExist() {
        return holder.format("Error.Suppression.NonExist");
    }

    /**
     * ERROR: An error occurred attempting to validate the existence of suppression file.
     * 
     */
    public static Localizable _Error_Suppression_NonExist() {
        return new Localizable(holder, "Error.Suppression.NonExist");
    }

    /**
     * The path and filename to the Dependency-Check JAR cannot be found
     * 
     */
    public static String Form_Error_jarNotFound() {
        return holder.format("Form.Error.jarNotFound");
    }

    /**
     * The path and filename to the Dependency-Check JAR cannot be found
     * 
     */
    public static Localizable _Form_Error_jarNotFound() {
        return new Localizable(holder, "Form.Error.jarNotFound");
    }

    /**
     * Medium
     * 
     */
    public static String Severity_Medium() {
        return holder.format("Severity.Medium");
    }

    /**
     * Medium
     * 
     */
    public static Localizable _Severity_Medium() {
        return new Localizable(holder, "Severity.Medium");
    }

    /**
     * Dependency-Check warnings trend graph (totals)
     * 
     */
    public static String Portlet_WarningsTotalsGraph() {
        return holder.format("Portlet.WarningsTotalsGraph");
    }

    /**
     * Dependency-Check warnings trend graph (totals)
     * 
     */
    public static Localizable _Portlet_WarningsTotalsGraph() {
        return new Localizable(holder, "Portlet.WarningsTotalsGraph");
    }

}
