/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.core;

import java.util.Iterator;
import javax.servlet.jsp.jstl.core.LoopTagStatus;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.impl.BreakException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ForEachTag
extends TagSupport {
    private static final Log log = LogFactory.getLog(ForEachTag.class);
    private Expression items;
    private String var;
    private String indexVar;
    private String statusVar;
    private int begin;
    private int end = Integer.MAX_VALUE;
    private int step = 1;
    private int index;

    @Override
    public void doTag(XMLOutput output) throws MissingAttributeException, JellyTagException {
        block23: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("running with items: " + this.items));
            }
            try {
                if (this.items != null) {
                    Iterator iter = this.items.evaluateAsIterator(this.context);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Iterating through: " + iter));
                    }
                    this.index = 0;
                    while (this.index < this.begin && iter.hasNext()) {
                        iter.next();
                        ++this.index;
                    }
                    LoopStatus status = null;
                    if (this.statusVar != null) {
                        Integer statusBegin = this.begin == 0 ? null : Integer.valueOf(this.begin);
                        Integer statusEnd = this.end == Integer.MAX_VALUE ? null : Integer.valueOf(this.end);
                        Integer statusStep = this.step == 1 ? null : Integer.valueOf(this.step);
                        status = new LoopStatus(statusBegin, statusEnd, statusStep);
                        this.context.setVariable(this.statusVar, status);
                    }
                    boolean firstTime = true;
                    int count = 0;
                    while (iter.hasNext() && this.index <= this.end) {
                        Object value = iter.next();
                        if (this.var != null) {
                            this.context.setVariable(this.var, value);
                        }
                        if (this.indexVar != null) {
                            this.context.setVariable(this.indexVar, this.index);
                        }
                        if (this.statusVar != null) {
                            status.setCount(++count);
                            status.setCurrent(value);
                            status.setFirst(firstTime);
                            status.setIndex(this.index);
                            if (firstTime) {
                                firstTime = !firstTime;
                            }
                        }
                        boolean finished = false;
                        ++this.index;
                        int i = 1;
                        while (i < this.step && !finished) {
                            if (!iter.hasNext()) {
                                finished = true;
                            } else {
                                iter.next();
                            }
                            ++i;
                            ++this.index;
                        }
                        if (this.statusVar != null) {
                            status.setLast(finished || !iter.hasNext() || this.index > this.end);
                        }
                        this.invokeBody(output);
                    }
                } else {
                    if (this.end == Integer.MAX_VALUE && this.begin == 0) {
                        throw new MissingAttributeException("items");
                    }
                    String varName = this.var;
                    if (varName == null) {
                        varName = this.indexVar;
                    }
                    LoopStatus status = null;
                    if (this.statusVar != null) {
                        Integer statusBegin = this.begin;
                        Integer statusEnd = this.end;
                        Integer statusStep = this.step;
                        status = new LoopStatus(statusBegin, statusEnd, statusStep);
                        this.context.setVariable(this.statusVar, status);
                    }
                    int count = 0;
                    this.index = this.begin;
                    while (this.index <= this.end) {
                        Integer value = this.index;
                        if (varName != null) {
                            this.context.setVariable(varName, value);
                        }
                        if (status != null) {
                            status.setIndex(this.index);
                            status.setCount(++count);
                            status.setCurrent(value);
                            status.setFirst(this.index == this.begin);
                            status.setLast(this.index > this.end - this.step);
                        }
                        this.invokeBody(output);
                        this.index += this.step;
                    }
                }
            }
            catch (BreakException e) {
                if (!log.isDebugEnabled()) break block23;
                log.debug((Object)("loop terminated by break: " + e), (Throwable)e);
            }
        }
    }

    public void setItems(Expression items) {
        this.items = items;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setIndexVar(String indexVar) {
        this.indexVar = indexVar;
    }

    public void setBegin(int begin) {
        this.begin = begin;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public void setVarStatus(String var) {
        this.statusVar = var;
    }

    public static final class LoopStatus
    implements LoopTagStatus {
        private Integer begin;
        private int count;
        private Object current;
        private Integer end;
        private int index;
        private Integer step;
        private boolean first;
        private boolean last;

        public LoopStatus(Integer begin, Integer end, Integer step) {
            this.begin = begin;
            this.end = end;
            this.step = step;
        }

        public Integer getBegin() {
            return this.begin;
        }

        public int getCount() {
            return this.count;
        }

        public Object getCurrent() {
            return this.current;
        }

        public Integer getEnd() {
            return this.end;
        }

        public boolean isFirst() {
            return this.first;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isLast() {
            return this.last;
        }

        public Integer getStep() {
            return this.step;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public void setCurrent(Object current) {
            this.current = current;
        }

        public void setFirst(boolean first) {
            this.first = first;
        }

        public void setLast(boolean last) {
            this.last = last;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }
}

