/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.run_condition_extras.adapters.mail_ext;

import com.synopsys.arc.jenkinsci.plugins.run_condition_extras.adapters.mail_ext.Messages;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;
import org.jenkins_ci.plugins.run_condition.RunCondition;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunConditionEmailTrigger
extends EmailTrigger {
    RunCondition condition;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public RunConditionEmailTrigger(boolean sendToList, boolean sendToDevs, boolean sendToRequestor, boolean sendToCulprits, String recipientList, String replyTo, String subject, String body, String attachmentsPattern, int attachBuildLog, String contentType, RunCondition condition) {
        super(sendToList, sendToDevs, sendToRequestor, sendToCulprits, recipientList, replyTo, subject, body, attachmentsPattern, attachBuildLog, contentType);
        this.condition = condition;
    }

    public boolean isPreBuild() {
        return false;
    }

    public boolean trigger(AbstractBuild<?, ?> ab, TaskListener tl) {
        if (!(tl instanceof BuildListener)) {
            tl.error("[mail-trigger] - Wrong class of task listener. Skipping the trigger");
            this.logError(tl, Messages.RunConditionEmailTrigger_listenerClassConvError());
            return false;
        }
        BuildListener listener = (BuildListener)tl;
        try {
            return this.condition.runPerform(ab, listener);
        }
        catch (Exception ex) {
            this.logError((TaskListener)listener, Messages.RunConditionEmailTrigger_exceptionMsg() + ex.getMessage());
            return false;
        }
    }

    public RunCondition getCondition() {
        return this.condition;
    }

    public EmailTriggerDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    private void logError(TaskListener listener, String message) {
        listener.error(Messages.logPrefix() + message);
    }

    public static final class DescriptorImpl
    extends EmailTriggerDescriptor {
        public String getDisplayName() {
            return Messages.RunConditionEmailTrigger_displayName();
        }
    }
}

