/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.cygwinprocesskiller.util;

import com.synopsys.arc.jenkinsci.plugins.cygwinprocesskiller.CygwinKillerInstallation;
import com.synopsys.arc.jenkinsci.plugins.cygwinprocesskiller.CygwinProcessKillerPlugin;
import com.synopsys.arc.jenkinsci.plugins.cygwinprocesskiller.Messages;
import com.synopsys.arc.jenkinsci.plugins.cygwinprocesskiller.util.CygwinKillerException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.Node;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.output.ByteArrayOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CygwinKillHelper {
    private final TaskListener log;
    private final Node node;
    private final CygwinKillerInstallation tool;
    private final int processPID;
    private FilePath tmpDir;
    private FilePath substitutedHome;
    private final CygwinProcessKillerPlugin plugin = CygwinProcessKillerPlugin.Instance();
    private static final String CYGWIN_START_PREFIX = "CYGWIN_";
    private static final String CYGWIN_BINARY_PATH = "\\bin\\";
    private static final int WAIT_TIMEOUT_SEC = 500;

    public CygwinKillHelper(TaskListener log, Node node, CygwinKillerInstallation tool, int processPID) {
        this.log = log;
        this.node = node;
        this.tool = tool;
        this.processPID = processPID;
        this.tmpDir = null;
        this.substitutedHome = null;
    }

    public boolean isCygwin() throws InterruptedException {
        ByteArrayOutputStream str = new ByteArrayOutputStream();
        try {
            this.execCommand("uname", (OutputStream)str, (OutputStream)str, "-a");
        }
        catch (IOException ex) {
            this.logError(Messages.Message_CygwinCheckFailed() + ex.getMessage());
            return false;
        }
        return str.toString().startsWith(CYGWIN_START_PREFIX);
    }

    private FilePath getTmpDir() throws IOException, InterruptedException {
        if (this.tmpDir == null) {
            this.tmpDir = CygwinKillHelper.findTmpDir(this.node);
        }
        return this.tmpDir;
    }

    public int execScript(String script, OutputStream out, String ... args) throws IOException, InterruptedException {
        FilePath tmpFile = this.getTmpDir().createTempFile("cygwin_process_killer_", ".sh");
        tmpFile.write(script, null);
        String[] cmd = new String[1 + args.length];
        cmd[0] = tmpFile.getRemote();
        System.arraycopy(args, 0, cmd, 1, args.length);
        return this.execCommand("bash", out, out, cmd);
    }

    public int execCommand(String command, OutputStream stdout, OutputStream stderr, String ... args) throws IOException, InterruptedException {
        String[] cmd = new String[1 + args.length];
        cmd[0] = this.getCygwinBinaryCommand(command);
        System.arraycopy(args, 0, cmd, 1, args.length);
        Launcher.ProcStarter starter = this.node.createLauncher(this.log).launch().cmds(cmd).envs(this.constructVariables()).stdout(stdout).stderr(stderr).pwd(this.getTmpDir());
        Proc proc = starter.start();
        int resultCode = proc.joinWithTimeout(500L, TimeUnit.SECONDS, this.log);
        starter.readStdout();
        return resultCode;
    }

    public boolean kill() throws IOException, InterruptedException {
        ByteArrayOutputStream str = new ByteArrayOutputStream();
        int res = this.execScript(this.plugin.getKillScript(), (OutputStream)str, Integer.toString(this.processPID));
        if (res != 0) {
            this.logError("CygwinKiller cannot kill the process tree (parent pid=" + this.processPID + ")");
        }
        return res != 0;
    }

    private String getCygwinBinaryCommand(String commandName) throws IOException, InterruptedException {
        return this.tool != null ? this.getSubstitutedHome().getRemote() + CYGWIN_BINARY_PATH + commandName + ".exe" : commandName + ".exe";
    }

    private static FilePath findTmpDir(Node node) throws IOException, InterruptedException {
        if (node == null) {
            throw new IllegalArgumentException("Must pass non-null node");
        }
        FilePath root = node.getRootPath();
        if (root == null) {
            throw new IllegalArgumentException("Node " + node.getDisplayName() + " seems to be offline");
        }
        FilePath tmpDir = root.child("cygwin_process_killer").child("tmp");
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        return tmpDir;
    }

    private Map<String, String> constructVariables() throws IOException, InterruptedException {
        TreeMap<String, String> envVars = new TreeMap<String, String>();
        if (this.tool != null) {
            FilePath homePath = this.getSubstitutedHome();
            String overridenPaths = homePath.child("bin").getRemote() + File.pathSeparator + homePath.child("lib").getRemote();
            envVars.put("PATH", overridenPaths);
            envVars.put("CYGWIN_HOME", homePath.getRemote());
        }
        return envVars;
    }

    private FilePath getSubstitutedHome() throws IOException, InterruptedException {
        if (this.substitutedHome == null && this.tool != null) {
            try {
                this.substitutedHome = this.getCygwinHome(null);
            }
            catch (CygwinKillerException ex) {
                String msg = Messages.Message_InstallationFailed() + ex.getMessage();
                this.logError(msg);
                throw new IOException(msg, ex);
            }
        }
        return this.substitutedHome;
    }

    private void logError(String message) {
        this.log.error("[cygwin-process] - " + message);
    }

    private FilePath getCygwinHome(EnvVars additionalVars) throws CygwinKillerException, IOException, InterruptedException {
        String home = this.tool.forNode(this.node, this.log).getHome();
        if (additionalVars != null && additionalVars.size() != 0) {
            home = additionalVars.expand(home);
        }
        File cygwinHome = new File(home);
        return new FilePath(cygwinHome);
    }
}

