/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.cygwinprocesskiller;

import com.synopsys.arc.jenkinsci.plugins.cygwinprocesskiller.CygwinKillerInstallation;
import com.synopsys.arc.jenkinsci.plugins.cygwinprocesskiller.CygwinProcessKillerPlugin;
import com.synopsys.arc.jenkinsci.plugins.cygwinprocesskiller.Messages;
import com.synopsys.arc.jenkinsci.plugins.cygwinprocesskiller.util.CygwinKillHelper;
import com.synopsys.arc.jenkinsci.plugins.cygwinprocesskiller.util.CygwinKillerException;
import hudson.Extension;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.slaves.SlaveComputer;
import hudson.util.LogTaskListener;
import hudson.util.ProcessKiller;
import hudson.util.ProcessTree;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.SystemUtils;

@Extension
public class CygwinProcessKiller
extends ProcessKiller {
    private static final Level KILLER_LOGGING_LEVEL = Level.WARNING;
    private static final String KILLER_LOGGER_NAME = "global";

    public boolean kill(ProcessTree.OSProcess process) throws IOException, InterruptedException {
        if (!SystemUtils.IS_OS_WINDOWS) {
            return false;
        }
        try {
            KillReport report = (KillReport)SlaveComputer.getChannelToMaster().call((Callable)new KillerRemoteCall(process.getPid()));
            return report.isKilledSuccessfully();
        }
        catch (CygwinKillerException ex) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KillerRemoteCall
    implements Callable<KillReport, CygwinKillerException> {
        private final int processPID;

        public KillerRemoteCall(int processPID) {
            this.processPID = processPID;
        }

        public KillReport call() throws CygwinKillerException {
            CygwinProcessKillerPlugin plugin = CygwinProcessKillerPlugin.Instance();
            if (!plugin.isEnableProcessKiller()) {
                return new KillReport(false, Messages.Message_KillerIsDisabled());
            }
            LogTaskListener listener = new LogTaskListener(Logger.getLogger(CygwinProcessKiller.KILLER_LOGGER_NAME), KILLER_LOGGING_LEVEL);
            String nodeName = Channel.current().getName();
            Node targetNode = Hudson.getInstance().getNode(nodeName);
            CygwinKillerInstallation tool = plugin.getToolInstallation();
            CygwinKillHelper helper = new CygwinKillHelper((TaskListener)listener, targetNode, tool, this.processPID);
            try {
                if (!helper.isCygwin()) {
                    return new KillReport(false, Messages.Message_CygwinCheckFailed());
                }
                return new KillReport(helper.kill(), null);
            }
            catch (Exception ex) {
                throw new CygwinKillerException(ex.getMessage());
            }
        }
    }

    public static class KillReport
    implements Serializable {
        private boolean killedSuccessfully;
        private String errorMessage;

        public KillReport(boolean killedSuccessfully, String errorMessage) {
            this.killedSuccessfully = killedSuccessfully;
            this.errorMessage = errorMessage;
        }

        public boolean isKilledSuccessfully() {
            return this.killedSuccessfully;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

