/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.cygwinprocesskiller;

import com.synopsys.arc.jenkinsci.plugins.cygwinprocesskiller.CygwinProcessKiller;
import com.synopsys.arc.jenkinsci.plugins.cygwinprocesskiller.util.CygwinKillerException;
import hudson.Extension;
import hudson.remoting.Callable;
import hudson.slaves.SlaveComputer;
import hudson.util.ProcessKiller;
import hudson.util.ProcessTree;
import java.io.IOException;
import java.util.logging.Level;
import org.apache.commons.lang.SystemUtils;

@Extension
public class CygwinProcessKiller
extends ProcessKiller {
    private static final Level KILLER_LOGGING_LEVEL = Level.WARNING;
    private static final String KILLER_LOGGER_NAME = "global";

    public boolean kill(ProcessTree.OSProcess process) throws IOException, InterruptedException {
        if (!SystemUtils.IS_OS_WINDOWS) {
            return false;
        }
        try {
            KillReport report = (KillReport)SlaveComputer.getChannelToMaster().call((Callable)new KillerRemoteCall(process.getPid()));
            return report.isKilledSuccessfully();
        }
        catch (CygwinKillerException ex) {
            return false;
        }
    }

    static /* synthetic */ Level access$000() {
        return KILLER_LOGGING_LEVEL;
    }
}

