/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.dynamic_search.views;

import com.synopsys.arc.jenkinsci.plugins.dynamic_search.views.JobsFilter;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ListView;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewDescriptor;
import hudson.search.Search;
import hudson.util.FormValidation;
import hudson.views.ViewJobFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSearchView
extends ListView {
    transient Map<String, JobsFilter> contextMap;

    @DataBoundConstructor
    public SimpleSearchView(String name) {
        super(name);
    }

    public static String getSessionId() {
        return Hudson.SESSION_HASH;
    }

    public Search getSearch() {
        return super.getSearch();
    }

    public boolean hasConfiguredFilters() {
        return this.contextMap != null && this.contextMap.containsKey(SimpleSearchView.getSessionId());
    }

    public JobsFilter getFilters() {
        return this.hasConfiguredFilters() ? this.contextMap.get(SimpleSearchView.getSessionId()) : new JobsFilter((View)this);
    }

    public String cleanCache() {
        String sessionId = SimpleSearchView.getSessionId();
        if (this.contextMap.containsKey(sessionId)) {
            this.contextMap.remove(sessionId);
        }
        return sessionId;
    }

    public List<TopLevelItem> getItems() {
        List<TopLevelItem> res = super.getItems();
        if (this.hasConfiguredFilters()) {
            JobsFilter filters = this.contextMap.get(SimpleSearchView.getSessionId());
            res = filters.doFilter(res, (View)this);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSearchSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, UnsupportedEncodingException, ServletException, Descriptor.FormException {
        Hudson.getInstance().checkPermission(View.READ);
        JobsFilter filter = new JobsFilter(req, (View)this);
        if (this.contextMap == null) {
            SimpleSearchView simpleSearchView = this;
            synchronized (simpleSearchView) {
                this.contextMap = new ConcurrentHashMap<String, JobsFilter>();
            }
        }
        this.contextMap.put(SimpleSearchView.getSessionId(), filter);
        rsp.sendRedirect(".");
    }

    public boolean hasUserJobFilterExtensions() {
        return !ViewJobFilter.all().isEmpty();
    }

    @Extension
    public static final class DescriptorImpl
    extends ViewDescriptor {
        public String getDisplayName() {
            return "Simple Search View";
        }

        public FormValidation doCheckIncludeRegex(@QueryParameter String value) throws IOException, ServletException, InterruptedException {
            String v = Util.fixEmpty((String)value);
            if (v != null) {
                try {
                    Pattern.compile(v);
                }
                catch (PatternSyntaxException pse) {
                    return FormValidation.error((String)pse.getMessage());
                }
            }
            return FormValidation.ok();
        }
    }
}

