/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.dynamic_search.views;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.util.DescribableList;
import hudson.views.ViewJobFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobsFilter {
    private DescribableList<ViewJobFilter, Descriptor<ViewJobFilter>> jobFilters;
    private String includeRegex;
    private transient Pattern includePattern;
    private Boolean statusFilter;

    public JobsFilter(View owner) {
        this.statusFilter = null;
        this.jobFilters = new DescribableList((Saveable)owner);
        this.includeRegex = null;
    }

    public JobsFilter(StaplerRequest req, View parentView) throws Descriptor.FormException, IOException, ServletException {
        if (req.getParameter("useincluderegex") != null) {
            this.includeRegex = Util.nullify((String)req.getParameter("_.includeRegex"));
            this.includePattern = this.includeRegex == null ? null : Pattern.compile(this.includeRegex);
        } else {
            this.includeRegex = null;
            this.includePattern = null;
        }
        if (this.jobFilters == null) {
            this.jobFilters = new DescribableList((Saveable)parentView);
        }
        this.jobFilters.rebuildHetero(req, req.getSubmittedForm(), (Collection)ViewJobFilter.all(), "jobFilters");
        String filter = Util.fixEmpty((String)req.getParameter("statusFilter"));
        this.statusFilter = filter != null ? Boolean.valueOf("1".equals(filter)) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TopLevelItem> doFilter(List<TopLevelItem> input, View view) {
        TreeSet<String> names;
        JobsFilter jobsFilter = this;
        synchronized (jobsFilter) {
            names = new TreeSet<String>();
        }
        for (Item item : view.getOwnerItemGroup().getItems()) {
            String itemName = item.getName();
            if (this.includePattern == null) {
                names.add(itemName);
                continue;
            }
            if (!this.includePattern.matcher(itemName).matches()) continue;
            names.add(itemName);
        }
        Boolean localStatusFilter = this.statusFilter;
        List<Object> items = new ArrayList<TopLevelItem>(names.size());
        for (String n : names) {
            TopLevelItem item = (TopLevelItem)view.getOwnerItemGroup().getItem(n);
            if (item == null || localStatusFilter != null && item instanceof AbstractProject && !(((AbstractProject)item).isDisabled() ^ localStatusFilter)) continue;
            items.add(item);
        }
        DescribableList localJobFilters = this.getJobFilters();
        ArrayList allItems = new ArrayList(view.getOwnerItemGroup().getItems());
        for (ViewJobFilter jobFilter : localJobFilters) {
            items = jobFilter.filter(items, allItems, view);
        }
        return items;
    }

    public DescribableList<ViewJobFilter, Descriptor<ViewJobFilter>> getJobFilters() {
        return this.jobFilters;
    }

    public Pattern getIncludePattern() {
        return this.includePattern;
    }

    public String getIncludeRegex() {
        return this.includeRegex;
    }

    public Boolean getStatusFilter() {
        return this.statusFilter;
    }
}

