/*
 * Decompiled with CFR 0.152.
 */
package com.datapipe.jenkins.vault;

import com.bettercloud.vault.Vault;
import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import com.datapipe.jenkins.vault.MaskingConsoleLogFilter;
import com.datapipe.jenkins.vault.VaultSecret;
import com.datapipe.jenkins.vault.VaultSecretValue;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.console.ConsoleLogFilter;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapper;
import hudson.util.Secret;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildWrapper;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class VaultBuildWrapper
extends SimpleBuildWrapper {
    private String vaultUrl;
    private Secret authToken;
    private List<VaultSecret> vaultSecrets;
    private List<String> valuesToMask = new ArrayList<String>();

    @DataBoundConstructor
    public VaultBuildWrapper(@CheckForNull List<VaultSecret> vaultSecrets) {
        this.vaultSecrets = vaultSecrets;
        this.vaultUrl = null;
        this.authToken = null;
    }

    @DataBoundSetter
    public void setVaultUrl(String vaultUrl) {
        this.vaultUrl = vaultUrl;
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    @DataBoundSetter
    public void setAuthToken(String authToken) {
        this.authToken = Secret.fromString((String)authToken);
    }

    public Secret getAuthToken() {
        return this.authToken;
    }

    public List<VaultSecret> getVaultSecrets() {
        return this.vaultSecrets;
    }

    private String getUrl() {
        if (this.vaultUrl == null || this.vaultUrl.isEmpty()) {
            return this.getDescriptor().getVaultUrl();
        }
        return this.vaultUrl;
    }

    private Secret getToken() {
        if (this.authToken == null || Secret.toString((Secret)this.authToken).isEmpty()) {
            return this.getDescriptor().getAuthToken();
        }
        return this.authToken;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        PrintStream logger = listener.getLogger();
        String url = this.getUrl();
        String token = Secret.toString((Secret)this.getToken());
        for (VaultSecret vaultSecret : this.vaultSecrets) {
            try {
                VaultConfig vaultConfig = new VaultConfig(url, token).build();
                Vault vault = new Vault(vaultConfig);
                Map values = vault.logical().read(vaultSecret.getPath()).getData();
                for (VaultSecretValue value : vaultSecret.getSecretValues()) {
                    this.valuesToMask.add((String)values.get(value.getVaultKey()));
                    context.env(value.getEnvVar(), (String)values.get(value.getVaultKey()));
                }
            }
            catch (VaultException e) {
                e.printStackTrace(logger);
                throw new AbortException(e.getMessage());
            }
        }
    }

    public ConsoleLogFilter createLoggerDecorator(@Nonnull Run<?, ?> build) {
        return new MaskingConsoleLogFilter(build.getCharset().name(), this.valuesToMask);
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<BuildWrapper> {
        private String vaultUrl;
        private Secret authToken;

        public DescriptorImpl() {
            super(VaultBuildWrapper.class);
            this.load();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return "Vault Plugin";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String vaultUrl = formData.getString("vaultUrl");
            String authToken = formData.getString("authToken");
            this.vaultUrl = !JSONNull.getInstance().equals((Object)vaultUrl) ? vaultUrl : null;
            this.authToken = !JSONNull.getInstance().equals((Object)authToken) ? Secret.fromString((String)authToken) : null;
            this.save();
            return super.configure(req, formData);
        }

        public String getVaultUrl() {
            return this.vaultUrl;
        }

        public Secret getAuthToken() {
            return this.authToken;
        }

        public void setVaultUrl(String vaultUrl) {
            this.vaultUrl = vaultUrl;
        }

        public void setAuthToken(String authToken) {
            this.authToken = Secret.fromString((String)authToken);
        }
    }
}

