/*
 * Decompiled with CFR 0.152.
 */
package com.overops.plugins.jenkins.query;

import com.overops.plugins.jenkins.query.DescriptorImpl;
import com.overops.plugins.jenkins.query.OverOpsBuildAction;
import com.overops.report.service.QualityReportParams;
import com.overops.report.service.ReportService;
import com.overops.report.service.model.HtmlParts;
import com.overops.report.service.model.QualityReport;
import com.overops.report.service.model.QualityReportExceptionDetails;
import com.takipi.api.client.observe.Observer;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import hudson.util.Secret;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class QueryOverOps
extends Recorder
implements SimpleBuildStep {
    private String applicationName;
    private String deploymentName;
    private String serviceId;
    private String regexFilter;
    private boolean markUnstable;
    private Integer printTopIssues;
    private boolean showPassedGateEvents;
    private JSONObject checkNewErrors;
    private boolean newEvents;
    private JSONObject checkResurfacedErrors;
    private boolean resurfacedErrors;
    private JSONObject checkVolumeErrors;
    private Integer maxErrorVolume;
    private JSONObject checkUniqueErrors;
    private Integer maxUniqueErrors;
    private JSONObject checkCriticalErrors;
    private String criticalExceptionTypes;
    private JSONObject checkRegressionErrors;
    private String activeTimespan;
    private String baselineTimespan;
    private Integer minVolumeThreshold;
    private Double minErrorRateThreshold;
    private Double regressionDelta;
    private Double criticalRegressionDelta;
    private boolean applySeasonality;
    private boolean debug;
    private boolean errorSuccess;
    private boolean linkReport;

    @DataBoundConstructor
    public QueryOverOps() {
        this.applicationName = null;
        this.deploymentName = null;
        this.serviceId = null;
        this.regexFilter = null;
        this.markUnstable = false;
        this.showPassedGateEvents = false;
        this.printTopIssues = 5;
        this.checkNewErrors = null;
        this.newEvents = false;
        this.checkResurfacedErrors = null;
        this.resurfacedErrors = false;
        this.checkVolumeErrors = null;
        this.maxErrorVolume = 0;
        this.checkUniqueErrors = null;
        this.maxUniqueErrors = 0;
        this.checkCriticalErrors = null;
        this.criticalExceptionTypes = null;
        this.checkRegressionErrors = null;
        this.activeTimespan = "0";
        this.baselineTimespan = "0";
        this.minErrorRateThreshold = 0.0;
        this.minVolumeThreshold = 0;
        this.applySeasonality = false;
        this.regressionDelta = 0.0;
        this.criticalRegressionDelta = 0.0;
        this.debug = false;
        this.errorSuccess = false;
        this.linkReport = false;
    }

    @Deprecated
    public QueryOverOps(String applicationName, String deploymentName, String serviceId, String regexFilter, boolean markUnstable, boolean showPassedGateEvents, Integer printTopIssues, JSONObject checkNewErrors, boolean newEvents, JSONObject checkResurfacedErrors, boolean resurfacedErrors, JSONObject checkVolumeErrors, Integer maxErrorVolume, JSONObject checkUniqueErrors, Integer maxUniqueErrors, JSONObject checkCriticalErrors, String criticalExceptionTypes, JSONObject checkRegressionErrors, String activeTimespan, String baselineTimespan, Double minErrorRateThreshold, Integer minVolumeThreshold, boolean applySeasonality, Double regressionDelta, Double criticalRegressionDelta, boolean debug, boolean errorSuccess, boolean linkReport) {
        this.setApplicationName(applicationName);
        this.setDeploymentName(deploymentName);
        this.setServiceId(serviceId);
        this.setRegexFilter(regexFilter);
        this.setMarkUnstable(markUnstable);
        this.setShowPassedGateEvents(showPassedGateEvents);
        this.setPrintTopIssues(printTopIssues);
        this.setCheckNewErrors(checkNewErrors);
        this.setCheckResurfacedErrors(checkResurfacedErrors);
        this.setCheckVolumeErrors(checkVolumeErrors);
        this.setCheckUniqueErrors(checkUniqueErrors);
        this.setCheckCriticalErrors(checkCriticalErrors);
        this.setDebug(debug);
        this.setLinkReport(linkReport);
        this.setErrorSuccess(errorSuccess);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    @DataBoundSetter
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    @DataBoundSetter
    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public String getRegexFilter() {
        return this.regexFilter;
    }

    @DataBoundSetter
    public void setRegexFilter(String regexFilter) {
        this.regexFilter = regexFilter;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    @DataBoundSetter
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public boolean getDebug() {
        return this.debug;
    }

    @DataBoundSetter
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean getLinkReport() {
        return this.linkReport;
    }

    @DataBoundSetter
    public void setLinkReport(boolean linkReport) {
        this.linkReport = linkReport;
    }

    public boolean getErrorSuccess() {
        return this.errorSuccess;
    }

    @DataBoundSetter
    public void setErrorSuccess(boolean errorSuccess) {
        this.errorSuccess = errorSuccess;
    }

    public JSONObject getCheckNewErrors() {
        return this.checkNewErrors;
    }

    @DataBoundSetter
    public void setCheckNewErrors(JSONObject checkNewErrors) {
        this.checkNewErrors = checkNewErrors;
        if (checkNewErrors != null && !checkNewErrors.isNullObject()) {
            this.setNewEvents(checkNewErrors.getBoolean("newEvents"));
        }
    }

    public JSONObject getCheckResurfacedErrors() {
        return this.checkResurfacedErrors;
    }

    @DataBoundSetter
    public void setCheckResurfacedErrors(JSONObject checkResurfacedErrors) {
        this.checkResurfacedErrors = checkResurfacedErrors;
        if (checkResurfacedErrors != null && !checkResurfacedErrors.isNullObject()) {
            this.setResurfacedErrors(checkResurfacedErrors.getBoolean("resurfacedErrors"));
        }
    }

    public boolean getResurfacedErrors() {
        return this.resurfacedErrors;
    }

    @DataBoundSetter
    public void setResurfacedErrors(boolean resurfacedErrors) {
        this.resurfacedErrors = resurfacedErrors;
    }

    public boolean getNewEvents() {
        return this.newEvents;
    }

    @DataBoundSetter
    public void setNewEvents(boolean newEvents) {
        this.newEvents = newEvents;
    }

    public JSONObject getCheckUniqueErrors() {
        return this.checkUniqueErrors;
    }

    @DataBoundSetter
    public void setCheckUniqueErrors(JSONObject checkUniqueErrors) {
        String value;
        this.checkUniqueErrors = checkUniqueErrors;
        if (checkUniqueErrors != null && !checkUniqueErrors.isNullObject() && (value = checkUniqueErrors.getString("maxUniqueErrors")) != null && !value.isEmpty()) {
            this.setMaxUniqueErrors(Integer.valueOf(value));
        }
    }

    public Integer getMaxUniqueErrors() {
        return this.maxUniqueErrors;
    }

    @DataBoundSetter
    public void setMaxUniqueErrors(Integer maxUniqueErrors) {
        this.maxUniqueErrors = maxUniqueErrors;
    }

    public JSONObject getCheckVolumeErrors() {
        return this.checkVolumeErrors;
    }

    @DataBoundSetter
    public void setCheckVolumeErrors(JSONObject checkVolumeErrors) {
        String value;
        this.checkVolumeErrors = checkVolumeErrors;
        if (checkVolumeErrors != null && !checkVolumeErrors.isNullObject() && (value = checkVolumeErrors.getString("maxErrorVolume")) != null && !value.isEmpty()) {
            this.setMaxErrorVolume(Integer.valueOf(value));
        }
    }

    public Integer getMaxErrorVolume() {
        return this.maxErrorVolume;
    }

    @DataBoundSetter
    public void setMaxErrorVolume(Integer maxErrorVolume) {
        this.maxErrorVolume = maxErrorVolume;
    }

    public JSONObject getCheckCriticalErrors() {
        return this.checkCriticalErrors;
    }

    @DataBoundSetter
    public void setCheckCriticalErrors(JSONObject checkCriticalErrors) {
        this.checkCriticalErrors = checkCriticalErrors;
        if (checkCriticalErrors != null && !checkCriticalErrors.isNullObject()) {
            String value = checkCriticalErrors.getString("criticalExceptionTypes");
            this.setCriticalExceptionTypes(value);
        }
    }

    public JSONObject getCheckRegressionErrors() {
        return this.checkRegressionErrors;
    }

    public String getCriticalExceptionTypes() {
        return this.criticalExceptionTypes;
    }

    @DataBoundSetter
    public void setCriticalExceptionTypes(String criticalExceptionTypes) {
        this.criticalExceptionTypes = criticalExceptionTypes;
    }

    public Integer getPrintTopIssues() {
        return this.printTopIssues;
    }

    @DataBoundSetter
    public void setPrintTopIssues(Integer printTopIssues) {
        this.printTopIssues = printTopIssues;
    }

    public boolean getMarkUnstable() {
        return this.markUnstable;
    }

    @DataBoundSetter
    public void setMarkUnstable(boolean markUnstable) {
        this.markUnstable = markUnstable;
    }

    public boolean getShowPassedGateEvents() {
        return this.showPassedGateEvents;
    }

    @DataBoundSetter
    public void setShowPassedGateEvents(boolean showPassedGateEvents) {
        this.showPassedGateEvents = showPassedGateEvents;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        String appUrl = this.getDescriptor().getOverOpsAppURL();
        String apiHost = this.getDescriptor().getOverOpsURL();
        String apiKey = Secret.toString((Secret)this.getDescriptor().getOverOpsAPIKey());
        PrintStream printStream = this.debug ? listener.getLogger() : null;
        Result result = run.getResult();
        if (result != null && result.isWorseThan(Result.UNSTABLE)) {
            printStream.println("Skipping OverOps Report due to prior build failure");
            return;
        }
        QualityReport reportModel = null;
        ReportService reportService = new ReportService();
        try {
            this.validateInputs(printStream);
            QualityReportParams query = this.getQualityReportParams();
            if (this.linkReport) {
                String reportLinkHtml = reportService.generateReportLinkHtml(appUrl, query, printStream, this.debug);
                OverOpsBuildAction buildAction = new OverOpsBuildAction(new HtmlParts(reportLinkHtml, ""), run);
                run.addAction((Action)buildAction);
                run.setResult(Result.SUCCESS);
            } else {
                ReportService.pauseForTheCause((PrintStream)listener.getLogger());
                reportModel = reportService.runQualityReport(apiHost, apiKey, query, ReportService.Requestor.JENKINS, printStream, this.debug);
                OverOpsBuildAction buildAction = new OverOpsBuildAction(reportModel.getHtmlParts(this.showPassedGateEvents), run);
                run.addAction((Action)buildAction);
                if (reportModel.getStatusCode() == QualityReport.ReportStatus.FAILED) {
                    if (reportModel.getExceptionDetails() != null && this.errorSuccess) {
                        run.setResult(Result.SUCCESS);
                    } else {
                        run.setResult(Result.UNSTABLE);
                    }
                } else {
                    run.setResult(Result.SUCCESS);
                }
            }
        }
        catch (Exception exception) {
            reportModel = new QualityReport();
            QualityReportExceptionDetails exceptionDetails = new QualityReportExceptionDetails();
            exceptionDetails.setExceptionMessage(exception.getMessage());
            List<StackTraceElement> stackElements = Arrays.asList(exception.getStackTrace());
            ArrayList<String> stackTrace = new ArrayList<String>();
            stackTrace.add(exception.getClass().getName());
            stackTrace.addAll(stackElements.stream().map(stack -> stack.toString()).collect(Collectors.toList()));
            exceptionDetails.setStackTrace(stackTrace.toArray(new String[stackTrace.size()]));
            reportModel.setExceptionDetails(exceptionDetails);
            OverOpsBuildAction buildAction = new OverOpsBuildAction(reportModel.getHtmlParts(), run);
            run.addAction((Action)buildAction);
            if (this.errorSuccess) {
                run.setResult(Result.SUCCESS);
            }
            run.setResult(Result.UNSTABLE);
        }
    }

    public String toString() {
        return "QueryOverOps[ applicationName=" + this.applicationName + ", deploymentName=" + this.deploymentName + ", serviceId=" + this.serviceId + ", regexFilter=" + this.regexFilter + ", markUnstable=" + this.markUnstable + ", printTopIssues=" + this.printTopIssues + ", checkNewErrors=" + this.checkNewErrors + ", newEvents=" + this.newEvents + ", checkResurfacedErrors=" + this.checkResurfacedErrors + ", resurfacedErrors=" + this.resurfacedErrors + ", checkVolumeErrors=" + this.checkVolumeErrors + ", maxErrorVolume=" + this.maxErrorVolume + ", checkUniqueErrors=" + this.checkUniqueErrors + ", maxUniqueErrors=" + this.maxUniqueErrors + ", checkCriticalErrors=" + this.checkCriticalErrors + ", criticalExceptionTypes=" + this.criticalExceptionTypes + ", checkRegressionErrors=" + this.checkRegressionErrors + ", activeTimespan=" + this.activeTimespan + ", baselineTimespan=" + this.baselineTimespan + ", minVolumeThreshold=" + this.minVolumeThreshold + ", minErrorRateThreshold=" + this.minErrorRateThreshold + ", regressionDelta=" + this.regressionDelta + ", criticalRegressionDelta=" + this.criticalRegressionDelta + ", applySeasonality=" + this.applySeasonality + ", debug=" + this.debug + ",linkReport=" + this.linkReport + " ]";
    }

    private QualityReportParams getQualityReportParams() {
        String value;
        QualityReportParams queryOverOps = new QualityReportParams();
        queryOverOps.setApplicationName(this.applicationName);
        queryOverOps.setDeploymentName(this.deploymentName);
        queryOverOps.setServiceId(this.serviceId);
        queryOverOps.setRegexFilter(this.regexFilter);
        queryOverOps.setMarkUnstable(this.markUnstable);
        queryOverOps.setPrintTopIssues(this.printTopIssues.intValue());
        queryOverOps.setNewEvents(this.newEvents);
        queryOverOps.setResurfacedErrors(this.resurfacedErrors);
        if (this.checkVolumeErrors != null && !this.checkVolumeErrors.isNullObject()) {
            value = this.checkVolumeErrors.getString("maxErrorVolume");
            if (value != null && !value.isEmpty()) {
                queryOverOps.setMaxErrorVolume(Math.max(1, Integer.parseInt(value)));
            } else {
                queryOverOps.setMaxErrorVolume(1);
            }
        } else {
            queryOverOps.setMaxErrorVolume(0);
        }
        if (this.checkUniqueErrors != null && !this.checkUniqueErrors.isNullObject()) {
            value = this.checkUniqueErrors.getString("maxUniqueErrors");
            if (value != null && !value.isEmpty()) {
                queryOverOps.setMaxUniqueErrors(Math.max(1, Integer.parseInt(value)));
            } else {
                queryOverOps.setMaxUniqueErrors(1);
            }
        } else {
            queryOverOps.setMaxUniqueErrors(0);
        }
        if (this.checkCriticalErrors != null && !this.checkCriticalErrors.isNullObject()) {
            value = this.checkCriticalErrors.getString("criticalExceptionTypes");
            if (value != null && !value.isEmpty()) {
                queryOverOps.setCriticalExceptionTypes(value);
            } else {
                queryOverOps.setCriticalExceptionTypes("");
            }
        }
        queryOverOps.setActiveTimespan("0");
        queryOverOps.setBaselineTimespan("0");
        queryOverOps.setMinVolumeThreshold(0);
        queryOverOps.setMinErrorRateThreshold(0.0);
        queryOverOps.setRegressionDelta(0.0);
        queryOverOps.setCriticalRegressionDelta(0.0);
        queryOverOps.setApplySeasonality(false);
        return queryOverOps;
    }

    private void validateInputs(PrintStream printStream) throws InterruptedException, IOException {
        String apiHost = this.getDescriptor().getOverOpsURL();
        String apiKey = Secret.toString((Secret)this.getDescriptor().getOverOpsAPIKey());
        if (apiHost == null) {
            throw new IllegalArgumentException("Missing host name");
        }
        if (apiKey == null) {
            throw new IllegalArgumentException("Missing api key");
        }
        if (this.serviceId == null || this.serviceId.isEmpty()) {
            this.serviceId = this.getDescriptor().getOverOpsSID();
        }
        if (this.serviceId == null) {
            throw new IllegalArgumentException("Missing environment Id");
        }
        this.serviceId = this.serviceId.toUpperCase();
    }

    protected static class ApiClientObserver
    implements Observer {
        private final PrintStream printStream;
        private final boolean verbose;

        public ApiClientObserver(PrintStream printStream, boolean verbose) {
            this.printStream = printStream;
            this.verbose = verbose;
        }

        public void observe(Observer.Operation operation, String url, String request, String response, int responseCode, long time) {
            StringBuilder output = new StringBuilder();
            output.append(String.valueOf(operation));
            output.append(" took ");
            output.append(time / 1000L);
            output.append("ms for ");
            output.append(url);
            if (this.verbose) {
                output.append(". Response: ");
                output.append(response);
            }
            this.printStream.println(output.toString());
        }
    }
}

