/*
 * Decompiled with CFR 0.152.
 */
package com.overops.plugins.jenkins.query;

import com.overops.plugins.jenkins.query.DescriptorImpl;
import com.overops.plugins.jenkins.query.OverOpsBuildAction;
import com.overops.plugins.jenkins.query.ReportBuilder;
import com.takipi.api.client.ApiClient;
import com.takipi.api.client.RemoteApiClient;
import com.takipi.api.client.data.view.SummarizedView;
import com.takipi.api.client.observe.Observer;
import com.takipi.api.client.util.regression.RegressionInput;
import com.takipi.api.client.util.view.ViewUtil;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import hudson.util.Secret;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class QueryOverOps
extends Recorder
implements SimpleBuildStep {
    private static final String SEPERATOR = ",";
    private boolean runRegressions = false;
    private String applicationName;
    private String deploymentName;
    private String serviceId;
    private String url;
    private String apiToken;
    private String regexFilter;
    private boolean markUnstable;
    private Integer printTopIssues;
    private JSONObject checkNewErrors;
    private boolean newEvents;
    private JSONObject checkResurfacedErrors;
    private boolean resurfacedErrors;
    private JSONObject checkVolumeErrors;
    private Integer maxErrorVolume;
    private JSONObject checkUniqueErrors;
    private Integer maxUniqueErrors;
    private JSONObject checkCriticalErrors;
    private String criticalExceptionTypes;
    private JSONObject checkRegressionErrors;
    private String activeTimespan;
    private String baselineTimespan;
    private Integer minVolumeThreshold;
    private Double minErrorRateThreshold;
    private Double regressionDelta;
    private Double criticalRegressionDelta;
    private boolean applySeasonality;
    private boolean debug;
    private boolean errorSuccess;

    @DataBoundConstructor
    public QueryOverOps() {
        this.applicationName = null;
        this.deploymentName = null;
        this.serviceId = null;
        this.regexFilter = null;
        this.markUnstable = false;
        this.printTopIssues = 5;
        this.checkNewErrors = null;
        this.newEvents = false;
        this.checkResurfacedErrors = null;
        this.resurfacedErrors = false;
        this.checkVolumeErrors = null;
        this.maxErrorVolume = 0;
        this.checkUniqueErrors = null;
        this.maxUniqueErrors = 0;
        this.checkCriticalErrors = null;
        this.criticalExceptionTypes = null;
        this.checkRegressionErrors = null;
        this.activeTimespan = "0";
        this.baselineTimespan = "0";
        this.minErrorRateThreshold = 0.0;
        this.minVolumeThreshold = 0;
        this.applySeasonality = false;
        this.regressionDelta = 0.0;
        this.criticalRegressionDelta = 0.0;
        this.debug = false;
        this.errorSuccess = false;
    }

    @Deprecated
    public QueryOverOps(String applicationName, String deploymentName, String serviceId, String regexFilter, boolean markUnstable, Integer printTopIssues, JSONObject checkNewErrors, boolean newEvents, JSONObject checkResurfacedErrors, boolean resurfacedErrors, JSONObject checkVolumeErrors, Integer maxErrorVolume, JSONObject checkUniqueErrors, Integer maxUniqueErrors, JSONObject checkCriticalErrors, String criticalExceptionTypes, JSONObject checkRegressionErrors, String activeTimespan, String baselineTimespan, Double minErrorRateThreshold, Integer minVolumeThreshold, boolean applySeasonality, Double regressionDelta, Double criticalRegressionDelta, boolean debug, boolean errorSuccess) {
        this.setApplicationName(applicationName);
        this.setDeploymentName(deploymentName);
        this.setServiceId(serviceId);
        this.setRegexFilter(regexFilter);
        this.setMarkUnstable(markUnstable);
        this.setPrintTopIssues(printTopIssues);
        this.setCheckNewErrors(checkNewErrors);
        this.setCheckResurfacedErrors(checkResurfacedErrors);
        this.setCheckVolumeErrors(checkVolumeErrors);
        this.setCheckUniqueErrors(checkUniqueErrors);
        this.setCheckCriticalErrors(checkCriticalErrors);
        this.setCheckRegressionErrors(checkRegressionErrors);
        this.setDebug(debug);
        this.setErrorSuccess(errorSuccess);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    @DataBoundSetter
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    @DataBoundSetter
    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public String getRegexFilter() {
        return this.regexFilter;
    }

    @DataBoundSetter
    public void setRegexFilter(String regexFilter) {
        this.regexFilter = regexFilter;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    @DataBoundSetter
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public boolean getDebug() {
        return this.debug;
    }

    @DataBoundSetter
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean getErrorSuccess() {
        return this.errorSuccess;
    }

    @DataBoundSetter
    public void setErrorSuccess(boolean errorSuccess) {
        this.errorSuccess = errorSuccess;
    }

    public JSONObject getCheckNewErrors() {
        return this.checkNewErrors;
    }

    @DataBoundSetter
    public void setCheckNewErrors(JSONObject checkNewErrors) {
        this.checkNewErrors = checkNewErrors;
        if (checkNewErrors != null && !checkNewErrors.isNullObject()) {
            this.setNewEvents(checkNewErrors.getBoolean("newEvents"));
        }
    }

    public JSONObject getCheckResurfacedErrors() {
        return this.checkResurfacedErrors;
    }

    @DataBoundSetter
    public void setCheckResurfacedErrors(JSONObject checkResurfacedErrors) {
        this.checkResurfacedErrors = checkResurfacedErrors;
        if (checkResurfacedErrors != null && !checkResurfacedErrors.isNullObject()) {
            this.setResurfacedErrors(checkResurfacedErrors.getBoolean("resurfacedErrors"));
        }
    }

    public boolean getResurfacedErrors() {
        return this.resurfacedErrors;
    }

    @DataBoundSetter
    public void setResurfacedErrors(boolean resurfacedErrors) {
        this.resurfacedErrors = resurfacedErrors;
    }

    public boolean getNewEvents() {
        return this.newEvents;
    }

    @DataBoundSetter
    public void setNewEvents(boolean newEvents) {
        this.newEvents = newEvents;
    }

    public JSONObject getCheckUniqueErrors() {
        return this.checkUniqueErrors;
    }

    @DataBoundSetter
    public void setCheckUniqueErrors(JSONObject checkUniqueErrors) {
        String value;
        this.checkUniqueErrors = checkUniqueErrors;
        if (checkUniqueErrors != null && !checkUniqueErrors.isNullObject() && (value = checkUniqueErrors.getString("maxUniqueErrors")) != null && !value.isEmpty()) {
            this.setMaxUniqueErrors(Integer.valueOf(value));
        }
    }

    public Integer getMaxUniqueErrors() {
        return this.maxUniqueErrors;
    }

    @DataBoundSetter
    public void setMaxUniqueErrors(Integer maxUniqueErrors) {
        this.maxUniqueErrors = maxUniqueErrors;
    }

    public JSONObject getCheckVolumeErrors() {
        return this.checkVolumeErrors;
    }

    @DataBoundSetter
    public void setCheckVolumeErrors(JSONObject checkVolumeErrors) {
        String value;
        this.checkVolumeErrors = checkVolumeErrors;
        if (checkVolumeErrors != null && !checkVolumeErrors.isNullObject() && (value = checkVolumeErrors.getString("maxErrorVolume")) != null && !value.isEmpty()) {
            this.setMaxErrorVolume(Integer.valueOf(value));
        }
    }

    public Integer getMaxErrorVolume() {
        return this.maxErrorVolume;
    }

    @DataBoundSetter
    public void setMaxErrorVolume(Integer maxErrorVolume) {
        this.maxErrorVolume = maxErrorVolume;
    }

    public JSONObject getCheckCriticalErrors() {
        return this.checkCriticalErrors;
    }

    @DataBoundSetter
    public void setCheckCriticalErrors(JSONObject checkCriticalErrors) {
        this.checkCriticalErrors = checkCriticalErrors;
        if (checkCriticalErrors != null && !checkCriticalErrors.isNullObject()) {
            String value = checkCriticalErrors.getString("criticalExceptionTypes");
            this.setCriticalExceptionTypes(value);
        }
    }

    public JSONObject getCheckRegressionErrors() {
        return this.checkRegressionErrors;
    }

    @DataBoundSetter
    public void setCheckRegressionErrors(JSONObject checkRegressionErrors) {
        this.checkRegressionErrors = checkRegressionErrors;
        if (checkRegressionErrors != null && !checkRegressionErrors.isNullObject()) {
            String value = checkRegressionErrors.getString("activeTimespan");
            if (value != null && !value.isEmpty()) {
                this.setActiveTimespan(value);
            }
            if ((value = checkRegressionErrors.getString("baselineTimespan")) != null && !value.isEmpty()) {
                this.setBaselineTimespan(value);
            }
            if ((value = checkRegressionErrors.getString("minErrorRateThreshold")) != null && !value.isEmpty()) {
                this.setMinErrorRateThreshold(Double.valueOf(value));
            }
            if ((value = checkRegressionErrors.getString("minVolumeThreshold")) != null && !value.isEmpty()) {
                this.setMinVolumeThreshold(Integer.valueOf(value));
            }
            this.setApplySeasonality(checkRegressionErrors.getBoolean("applySeasonality"));
            value = checkRegressionErrors.getString("regressionDelta");
            if (value != null && !value.isEmpty()) {
                this.setRegressionDelta(Double.valueOf(value));
            }
            if ((value = checkRegressionErrors.getString("criticalRegressionDelta")) != null && !value.isEmpty()) {
                this.setCriticalRegressionDelta(Double.valueOf(value));
            }
        }
    }

    public String getCriticalExceptionTypes() {
        return this.criticalExceptionTypes;
    }

    @DataBoundSetter
    public void setCriticalExceptionTypes(String criticalExceptionTypes) {
        this.criticalExceptionTypes = criticalExceptionTypes;
    }

    public String getActiveTimespan() {
        return this.activeTimespan;
    }

    @DataBoundSetter
    public void setActiveTimespan(String activeTimespan) {
        this.activeTimespan = activeTimespan;
    }

    public String getBaselineTimespan() {
        return this.baselineTimespan;
    }

    @DataBoundSetter
    public void setBaselineTimespan(String baselineTimespan) {
        this.baselineTimespan = baselineTimespan;
        if (this.convertToMinutes(baselineTimespan) > 0) {
            this.runRegressions = true;
        }
    }

    public Double getMinErrorRateThreshold() {
        return this.minErrorRateThreshold;
    }

    @DataBoundSetter
    public void setMinErrorRateThreshold(Double minErrorRateThreshold) {
        this.minErrorRateThreshold = minErrorRateThreshold;
    }

    public Double getCriticalRegressionDelta() {
        return this.criticalRegressionDelta;
    }

    @DataBoundSetter
    public void setCriticalRegressionDelta(Double criticalRegressionDelta) {
        this.criticalRegressionDelta = criticalRegressionDelta;
    }

    public Integer getMinVolumeThreshold() {
        return this.minVolumeThreshold;
    }

    @DataBoundSetter
    public void setMinVolumeThreshold(Integer minVolumeThreshold) {
        this.minVolumeThreshold = minVolumeThreshold;
    }

    public Double getRegressionDelta() {
        return this.regressionDelta;
    }

    @DataBoundSetter
    public void setRegressionDelta(Double regressionDelta) {
        this.regressionDelta = regressionDelta;
    }

    public boolean getApplySeasonality() {
        return this.applySeasonality;
    }

    @DataBoundSetter
    public void setApplySeasonality(boolean applySeasonality) {
        this.applySeasonality = applySeasonality;
    }

    public Integer getPrintTopIssues() {
        return this.printTopIssues;
    }

    @DataBoundSetter
    public void setPrintTopIssues(Integer printTopIssues) {
        this.printTopIssues = printTopIssues;
    }

    public boolean getMarkUnstable() {
        return this.markUnstable;
    }

    @DataBoundSetter
    public void setMarkUnstable(boolean markUnstable) {
        this.markUnstable = markUnstable;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private static boolean isResolved(String value) {
        boolean isVar = value.startsWith("${") && value.endsWith("}");
        return !isVar;
    }

    private static Collection<String> parseArrayString(String value, PrintStream printStream, String name) {
        if (value == null || value.isEmpty()) {
            return Collections.emptySet();
        }
        if (!QueryOverOps.isResolved(value)) {
            printStream.println("Value " + value + " is unresolved for " + name + ". Ignoring.");
            return Collections.emptySet();
        }
        List<String> result = Arrays.asList(value.trim().split(Pattern.quote(SEPERATOR)));
        return result;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        String apiHost = this.getDescriptor().getOverOpsURL();
        String apiKey = Secret.toString((Secret)this.getDescriptor().getOverOpsAPIKey());
        PrintStream printStream = this.debug ? listener.getLogger() : null;
        Result result = run.getResult();
        if (result != null && result.isWorseThan(Result.UNSTABLE)) {
            printStream.println("Skipping OverOps Report due to prior build failure");
            return;
        }
        QueryOverOps.pauseForTheCause(printStream);
        this.validateInputs(printStream);
        try {
            SummarizedView allEventsView;
            RemoteApiClient apiClient = (RemoteApiClient)RemoteApiClient.newBuilder().setHostname(apiHost).setApiKey(apiKey).build();
            if (printStream != null && this.debug) {
                apiClient.addObserver((Observer)new ApiClientObserver(printStream, this.debug));
            }
            if ((allEventsView = ViewUtil.getServiceViewByName((ApiClient)apiClient, (String)this.serviceId.toUpperCase(), (String)"All Events")) == null) {
                throw new IllegalStateException("Could not acquire ID for 'All Events'. Please check connection to " + apiHost);
            }
            RegressionInput input = this.setupRegressionData(run, allEventsView, listener, printStream);
            ReportBuilder.QualityReport report = ReportBuilder.execute((ApiClient)apiClient, input, this.maxErrorVolume, this.maxUniqueErrors, this.printTopIssues, this.regexFilter, this.newEvents, this.resurfacedErrors, this.runRegressions, this.markUnstable, printStream, this.debug);
            OverOpsBuildAction buildAction = new OverOpsBuildAction(report, run);
            run.addAction((Action)buildAction);
            if (this.markUnstable && report.getUnstable()) {
                run.setResult(Result.UNSTABLE);
            }
        }
        catch (Exception ex) {
            OverOpsBuildAction buildAction = new OverOpsBuildAction(ex, run);
            run.addAction((Action)buildAction);
            if (this.errorSuccess) {
                run.setResult(Result.SUCCESS);
            }
            run.setResult(Result.NOT_BUILT);
        }
    }

    public String toString() {
        return "QueryOverOps[ applicationName=" + this.applicationName + ", deploymentName=" + this.deploymentName + ", serviceId=" + this.serviceId + ", regexFilter=" + this.regexFilter + ", markUnstable=" + this.markUnstable + ", printTopIssues=" + this.printTopIssues + ", checkNewErrors=" + this.checkNewErrors + ", newEvents=" + this.newEvents + ", checkResurfacedErrors=" + this.checkResurfacedErrors + ", resurfacedErrors=" + this.resurfacedErrors + ", checkVolumeErrors=" + this.checkVolumeErrors + ", maxErrorVolume=" + this.maxErrorVolume + ", checkUniqueErrors=" + this.checkUniqueErrors + ", maxUniqueErrors=" + this.maxUniqueErrors + ", checkCriticalErrors=" + this.checkCriticalErrors + ", criticalExceptionTypes=" + this.criticalExceptionTypes + ", checkRegressionErrors=" + this.checkRegressionErrors + ", activeTimespan=" + this.activeTimespan + ", baselineTimespan=" + this.baselineTimespan + ", minVolumeThreshold=" + this.minVolumeThreshold + ", minErrorRateThreshold=" + this.minErrorRateThreshold + ", regressionDelta=" + this.regressionDelta + ", criticalRegressionDelta=" + this.criticalRegressionDelta + ", applySeasonality=" + this.applySeasonality + ", debug=" + this.debug + " ]";
    }

    private RegressionInput setupRegressionData(Run<?, ?> run, SummarizedView allEventsView, TaskListener listener, PrintStream printStream) throws InterruptedException, IOException {
        RegressionInput input = new RegressionInput();
        input.serviceId = this.serviceId;
        input.viewId = allEventsView.id;
        String expandedAppName = run.getEnvironment(listener).expand(this.applicationName);
        String expandedDepName = run.getEnvironment(listener).expand(this.deploymentName);
        input.applictations = QueryOverOps.parseArrayString(expandedAppName, printStream, "Application Name");
        input.deployments = QueryOverOps.parseArrayString(expandedDepName, printStream, "Deployment Name");
        input.criticalExceptionTypes = QueryOverOps.parseArrayString(this.criticalExceptionTypes, printStream, "Critical Exception Types");
        if (this.runRegressions) {
            input.activeTimespan = this.convertToMinutes(this.activeTimespan);
            input.baselineTime = this.baselineTimespan;
            input.baselineTimespan = this.convertToMinutes(this.baselineTimespan);
            input.minVolumeThreshold = this.minVolumeThreshold;
            input.minErrorRateThreshold = this.minErrorRateThreshold;
            input.regressionDelta = this.regressionDelta;
            input.criticalRegressionDelta = this.criticalRegressionDelta;
            input.applySeasonality = this.applySeasonality;
            input.validate();
        }
        this.printInputs(printStream, input);
        return input;
    }

    private void validateInputs(PrintStream printStream) throws InterruptedException, IOException {
        String apiHost = this.getDescriptor().getOverOpsURL();
        String apiKey = Secret.toString((Secret)this.getDescriptor().getOverOpsAPIKey());
        if (apiHost == null) {
            throw new IllegalArgumentException("Missing host name");
        }
        if (apiKey == null) {
            throw new IllegalArgumentException("Missing api key");
        }
        if (this.checkRegressionErrors != null) {
            if (!this.activeTimespan.equalsIgnoreCase("0") && this.convertToMinutes(this.activeTimespan) == 0) {
                throw new IllegalArgumentException("For Increasing Error Gate, the active timewindow currently set to: " + this.activeTimespan + " is not properly formated. See help for format instructions.");
            }
            if (!this.baselineTimespan.equalsIgnoreCase("0") && this.convertToMinutes(this.baselineTimespan) == 0) {
                throw new IllegalArgumentException("For Increasing Error Gate, the baseline timewindow currently set to: " + this.baselineTimespan + " cannot be zero or is improperly formated. See help for format instructions.");
            }
        }
        if (this.serviceId == null || this.serviceId.isEmpty()) {
            this.serviceId = this.getDescriptor().getOverOpsSID();
        }
        if (this.serviceId == null) {
            throw new IllegalArgumentException("Missing environment Id");
        }
        this.serviceId = this.serviceId.toUpperCase();
    }

    private int convertToMinutes(String timeWindow) {
        if (timeWindow.toLowerCase().contains("d")) {
            Integer days = Integer.parseInt(timeWindow.substring(0, timeWindow.indexOf("d")));
            return days * 24 * 60;
        }
        if (timeWindow.toLowerCase().contains("h")) {
            Integer hours = Integer.parseInt(timeWindow.substring(0, timeWindow.indexOf("h")));
            return hours * 60;
        }
        if (timeWindow.toLowerCase().contains("m")) {
            return Integer.parseInt(timeWindow.substring(0, timeWindow.indexOf("m")));
        }
        return 0;
    }

    private void printInputs(PrintStream printStream, RegressionInput input) {
        if (printStream != null) {
            printStream.println(input);
            printStream.println("Max unique errors  = " + this.maxUniqueErrors);
            printStream.println("Max error volume  = " + this.maxErrorVolume);
            printStream.println("Check new errors  = " + this.newEvents);
            printStream.println("Check resurfaced errors  = " + this.resurfacedErrors);
            String regexPrint = this.regexFilter != null ? this.regexFilter : "";
            printStream.println("Regex filter  = " + regexPrint);
        }
    }

    private static void pauseForTheCause(PrintStream printStream) {
        if (printStream != null) {
            printStream.println("Build Step: Starting OverOps Quality Gate....");
        }
        try {
            Thread.sleep(60000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static class ApiClientObserver
    implements Observer {
        private final PrintStream printStream;
        private final boolean verbose;

        public ApiClientObserver(PrintStream printStream, boolean verbose) {
            this.printStream = printStream;
            this.verbose = verbose;
        }

        public void observe(Observer.Operation operation, String url, String request, String response, int responseCode, long time) {
            StringBuilder output = new StringBuilder();
            output.append(String.valueOf(operation));
            output.append(" took ");
            output.append(time / 1000L);
            output.append("ms for ");
            output.append(url);
            if (this.verbose) {
                output.append(". Response: ");
                output.append(response);
            }
            this.printStream.println(output.toString());
        }
    }
}

