/*
 * Decompiled with CFR 0.152.
 */
package com.overops.plugins.jenkins.query;

import com.overops.plugins.jenkins.query.ReportBuilder;
import com.takipi.api.client.util.cicd.OOReportEvent;
import hudson.model.Action;
import hudson.model.Run;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class OverOpsBuildAction
implements Action {
    private static final String ISSUE = "Issue";
    private static final String STRING_FORMAT = "%,d";
    private final Run<?, ?> build;
    private final ReportBuilder.QualityReport qualityReport;
    private final Exception exception;

    OverOpsBuildAction(ReportBuilder.QualityReport qualityReport, Run<?, ?> build) {
        this.qualityReport = qualityReport;
        this.build = build;
        this.exception = null;
    }

    OverOpsBuildAction(Exception exception, Run<?, ?> build) {
        this.qualityReport = null;
        this.build = build;
        this.exception = exception;
    }

    public String getIconFileName() {
        return "/plugin/overops-query/images/OverOps.png";
    }

    public String getDisplayName() {
        return "OverOps Quality Report";
    }

    public String getUrlName() {
        return "OverOpsReport";
    }

    public boolean getUnstable() {
        return this.qualityReport.getUnstable();
    }

    public boolean getMarkedUnstable() {
        return this.qualityReport.isMarkedUnstable();
    }

    public String getSummary() {
        if (this.getUnstable() && this.getMarkedUnstable()) {
            return "OverOps has marked build " + this.getDeploymentName() + " as unstable.";
        }
        if (!this.getMarkedUnstable() && this.getUnstable()) {
            return "OverOps has detected issues with build " + this.getDeploymentName() + "  but did not mark the build as unstable.";
        }
        return "Congratulations, build " + this.getDeploymentName() + " has passed all quality gates!";
    }

    private String getDeploymentName() {
        String value = this.qualityReport.getInput().deployments.toString();
        value = value.replace("[", "");
        value = value.replace("]", "");
        return value;
    }

    public boolean getPassedNewErrorGate() {
        return this.getCheckNewEvents() && !this.getNewErrorsExist();
    }

    public boolean getCheckNewEvents() {
        return this.qualityReport.isCheckNewGate();
    }

    public String getNewErrorSummary() {
        if (this.getNewEvents() != null && this.getNewEvents().size() > 0) {
            int count = this.qualityReport.getNewIssues().size();
            StringBuilder sb = new StringBuilder("New Error Gate: Failed, OverOps detected ");
            sb.append(count);
            sb.append(" new error");
            if (count != 1) {
                sb.append("s");
            }
            sb.append(" in your build.");
            return sb.toString();
        }
        if (this.qualityReport.isCheckNewGate()) {
            return "New Error Gate: Passed, OverOps did not detect any new errors in your build.";
        }
        return null;
    }

    public boolean getNewErrorsExist() {
        return this.getNewEvents() != null && this.getNewEvents().size() > 0;
    }

    public List<OOReportEvent> getNewEvents() {
        return this.qualityReport.getNewIssues();
    }

    public boolean getPassedResurfacedErrorGate() {
        return this.getCheckResurfacedEvents() && !this.getResurfacedErrorsExist();
    }

    public boolean getResurfacedErrorsExist() {
        return this.getResurfacedEvents() != null && this.getResurfacedEvents().size() > 0;
    }

    public boolean getCheckResurfacedEvents() {
        return this.qualityReport.isCheckResurfacedGate();
    }

    public String getResurfacedErrorSummary() {
        if (this.getResurfacedEvents() != null && this.getResurfacedEvents().size() > 0) {
            return "Resurfaced Error Gate: Failed, OverOps detected " + this.qualityReport.getResurfacedErrors().size() + " resurfaced errors in your build.";
        }
        if (this.qualityReport.isCheckResurfacedGate()) {
            return "Resurfaced Error Gate: Passed, OverOps did not detect any resurfaced errors in your build.";
        }
        return null;
    }

    public List<OOReportEvent> getResurfacedEvents() {
        return this.qualityReport.getResurfacedErrors();
    }

    public boolean getCheckCriticalErrors() {
        return this.qualityReport.isCheckCriticalGate();
    }

    public boolean getPassedCriticalErrorGate() {
        return this.getCheckCriticalErrors() && !this.getCriticalErrorsExist();
    }

    public boolean getCriticalErrorsExist() {
        return this.getCriticalEvents() != null && this.getCriticalEvents().size() > 0;
    }

    public String getCriticalErrorSummary() {
        if (this.getCriticalEvents() != null && this.getCriticalEvents().size() > 0) {
            return "Critical Error Gate: Failed, OverOps detected " + this.qualityReport.getCriticalErrors().size() + " critical errors in your build.";
        }
        if (this.qualityReport.isCheckCriticalGate()) {
            return "Critical Error Gate: Passed, OverOps did not detect any critical errors in your build.";
        }
        return null;
    }

    public List<OOReportEvent> getCriticalEvents() {
        return this.qualityReport.getCriticalErrors();
    }

    public boolean getCountGates() {
        return this.getCheckUniqueErrors() || this.getCheckTotalErrors();
    }

    public boolean getCheckTotalErrors() {
        return this.qualityReport.isCheckVolumeGate();
    }

    public boolean getPassedTotalErrorGate() {
        return this.getCheckTotalErrors() && this.qualityReport.getEventVolume() > 0L && this.qualityReport.getEventVolume() < (long)this.qualityReport.getMaxEventVolume().intValue();
    }

    public String getTotalErrorSummary() {
        if (this.qualityReport.getEventVolume() > 0L && this.qualityReport.getEventVolume() >= (long)this.qualityReport.getMaxEventVolume().intValue()) {
            return "Total Error Volume Gate: Failed, OverOps detected " + this.qualityReport.getEventVolume() + " total errors which is >= the max allowable of " + this.qualityReport.getMaxEventVolume();
        }
        if (this.qualityReport.getEventVolume() > 0L && this.qualityReport.getEventVolume() < (long)this.qualityReport.getMaxEventVolume().intValue()) {
            return "Total Error Volume Gate: Passed, OverOps detected " + this.qualityReport.getEventVolume() + " total errors which is < than max allowable of " + this.qualityReport.getMaxEventVolume();
        }
        return null;
    }

    public boolean getCheckUniqueErrors() {
        return this.qualityReport.isCheckUniqueGate();
    }

    public boolean getHasTopErrors() {
        return !this.getPassedTotalErrorGate() || !this.getPassedUniqueErrorGate();
    }

    public boolean getPassedUniqueErrorGate() {
        return this.getCheckUniqueErrors() && this.qualityReport.getUniqueEventsCount() > 0L && this.qualityReport.getUniqueEventsCount() < (long)this.qualityReport.getMaxUniqueVolume().intValue();
    }

    public String getUniqueErrorSummary() {
        if (this.qualityReport.getUniqueEventsCount() > 0L && this.qualityReport.getUniqueEventsCount() >= (long)this.qualityReport.getMaxUniqueVolume().intValue()) {
            return "Unique Error Volume Gate: Failed, OverOps detected " + this.qualityReport.getUniqueEventsCount() + " unique errors which is >= the max allowable of " + this.qualityReport.getMaxUniqueVolume();
        }
        if (this.qualityReport.getUniqueEventsCount() > 0L && this.qualityReport.getUniqueEventsCount() < (long)this.qualityReport.getMaxUniqueVolume().intValue()) {
            return "Unique Error Volume Gate: Passed, OverOps detected " + this.qualityReport.getUniqueEventsCount() + " unique errors which is < than max allowable of " + this.qualityReport.getMaxUniqueVolume();
        }
        return null;
    }

    public List<OOReportEvent> getTopEvents() {
        return this.qualityReport.getTopErrors();
    }

    public String getRegressionSumarry() {
        if (!this.getPassedRegressedEvents()) {
            return "Increasing Quality Gate: Failed, OverOps detected increasing errors in the current build against the baseline of " + this.qualityReport.getInput().baselineTime;
        }
        if (this.getPassedRegressedEvents()) {
            return "Increasing Quality Gate: Passed, OverOps did not detect any increasing errors in the current build against the baseline of " + this.qualityReport.getInput().baselineTime;
        }
        return null;
    }

    public boolean getCheckRegressedErrors() {
        return this.qualityReport.isCheckRegressionGate();
    }

    public boolean getPassedRegressedEvents() {
        return !this.getCheckRegressedErrors() || this.qualityReport.getRegressions() == null || this.qualityReport.getRegressions().size() <= 0;
    }

    public List<OOReportEvent> getRegressedEvents() {
        return this.qualityReport.getAllIssues();
    }

    public Run<?, ?> getBuild() {
        return this.build;
    }

    public String getNewGateTotal() {
        return String.format(STRING_FORMAT, this.qualityReport.getNewIssues().size());
    }

    public String getResurfacedGateTotal() {
        return String.format(STRING_FORMAT, this.qualityReport.getResurfacedErrors().size());
    }

    public String getCriticalGateTotal() {
        return String.format(STRING_FORMAT, this.qualityReport.getCriticalErrors().size());
    }

    public String getTotalGateTotal() {
        return String.format(STRING_FORMAT, this.qualityReport.getEventVolume());
    }

    public String getUniqueGateTotal() {
        return String.format(STRING_FORMAT, this.qualityReport.getUniqueEventsCount());
    }

    public String getRegressionGateTotal() {
        return String.format(STRING_FORMAT, this.qualityReport.getRegressions() != null ? this.qualityReport.getRegressions().size() : 0);
    }

    public boolean getHasException() {
        return this.exception != null;
    }

    public String getExceptionMessage() {
        return this.exception != null ? this.exception.getMessage() : "";
    }

    public String getStackTrace() {
        if (this.exception == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.exception.printStackTrace(pw);
        return sw.toString();
    }

    public String getExceptionEmailMessage() {
        if (this.exception == null) {
            return "";
        }
        StringBuilder emailMessage = new StringBuilder("subject=CI%2FCD%20plugin%20error");
        try {
            emailMessage.append("&body=");
            emailMessage.append(URLEncoder.encode(this.getExceptionMessage() + "\n\n" + this.getStackTrace(), StandardCharsets.UTF_8.toString()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return emailMessage.toString();
    }
}

