/*
 * Decompiled with CFR 0.152.
 */
package com.overops.plugins.jenkins.query;

import com.google.common.base.Objects;
import com.google.gson.Gson;
import com.overops.plugins.jenkins.query.OOReportRegressedEvent;
import com.takipi.api.client.ApiClient;
import com.takipi.api.client.result.event.EventResult;
import com.takipi.api.client.util.cicd.OOReportEvent;
import com.takipi.api.client.util.cicd.ProcessQualityGates;
import com.takipi.api.client.util.cicd.QualityGateReport;
import com.takipi.api.client.util.regression.RateRegression;
import com.takipi.api.client.util.regression.RegressionInput;
import com.takipi.api.client.util.regression.RegressionResult;
import com.takipi.api.client.util.regression.RegressionUtil;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.joda.time.DateTime;

public class ReportBuilder {
    private static boolean allowEvent(EventResult event, Pattern pattern) {
        if (pattern == null) {
            return true;
        }
        String json = new Gson().toJson((Object)event);
        boolean result = !pattern.matcher(json).find();
        return result;
    }

    private static List<EventResult> getSortedEventsByVolume(Collection<EventResult> events) {
        ArrayList<EventResult> result = new ArrayList<EventResult>(events);
        result.sort(new Comparator<EventResult>(){

            @Override
            public int compare(EventResult o1, EventResult o2) {
                long v1 = o1.stats != null ? o1.stats.hits : 0L;
                long v2 = o2.stats != null ? o2.stats.hits : 0L;
                return (int)(v2 - v1);
            }
        });
        return result;
    }

    private static void addEvent(Set<EventResult> events, EventResult event, Pattern pattern, PrintStream output, boolean verbose) {
        if (ReportBuilder.allowEvent(event, pattern)) {
            events.add(event);
        } else if (output != null && verbose) {
            output.println(event + " did not match regexFilter and was skipped");
        }
    }

    private static Collection<EventResult> filterEvents(RateRegression rateRegression, Pattern pattern, PrintStream output, boolean verbose) {
        HashSet<EventResult> result = new HashSet<EventResult>();
        if (pattern != null) {
            for (EventResult event : rateRegression.getNonRegressions()) {
                ReportBuilder.addEvent(result, event, pattern, output, verbose);
            }
            for (EventResult event : rateRegression.getAllNewEvents().values()) {
                ReportBuilder.addEvent(result, event, pattern, output, verbose);
            }
            for (RegressionResult regressionResult : rateRegression.getAllRegressions().values()) {
                ReportBuilder.addEvent(result, regressionResult.getEvent(), pattern, output, verbose);
            }
        } else {
            result.addAll(rateRegression.getNonRegressions());
            result.addAll(rateRegression.getAllNewEvents().values());
            for (RegressionResult regressionResult : rateRegression.getAllRegressions().values()) {
                result.add(regressionResult.getEvent());
            }
        }
        return result;
    }

    private static ReportVolume getReportVolume(ApiClient apiClient, RegressionInput input, RateRegression rateRegression, int limit, String regexFilter, PrintStream output, boolean verbose) {
        ReportVolume result = new ReportVolume();
        Pattern pattern = regexFilter != null && regexFilter.length() > 0 ? Pattern.compile(regexFilter) : null;
        Collection<EventResult> eventsSet = ReportBuilder.filterEvents(rateRegression, pattern, output, verbose);
        List<EventResult> events = ReportBuilder.getSortedEventsByVolume(eventsSet);
        if (pattern != null) {
            result.filter = eventsSet;
        }
        result.topEvents = new ArrayList<OOReportEvent>();
        for (EventResult event : events) {
            if (event.stats == null || result.topEvents.size() >= limit) continue;
            String arcLink = ProcessQualityGates.getArcLink((ApiClient)apiClient, (String)event.id, (RegressionInput)input, (DateTime)rateRegression.getActiveWndowStart());
            result.topEvents.add(new OOReportEvent(event, arcLink));
        }
        return result;
    }

    public static QualityReport execute(ApiClient apiClient, RegressionInput input, Integer maxEventVolume, Integer maxUniqueErrors, int topEventLimit, String regexFilter, boolean newEvents, boolean resurfacedEvents, boolean runRegressions, boolean markedUnstable, PrintStream output, boolean verbose) {
        boolean maxUniqueErrorsExceeded;
        boolean maxVolumeExceeded;
        boolean countGate = false;
        if (maxEventVolume != 0 || maxUniqueErrors != 0) {
            countGate = true;
        }
        boolean checkMaxEventGate = maxEventVolume != 0;
        boolean checkUniqueEventGate = maxUniqueErrors != 0;
        QualityGateReport qualityGateReport = new QualityGateReport();
        if (countGate || newEvents || resurfacedEvents || regexFilter != null) {
            qualityGateReport = ProcessQualityGates.processCICDInputs((ApiClient)apiClient, (RegressionInput)input, (boolean)newEvents, (boolean)resurfacedEvents, (String)regexFilter, (int)topEventLimit, (boolean)countGate, (PrintStream)output, (boolean)verbose);
        }
        RateRegression rateRegression = null;
        List<OOReportRegressedEvent> regressions = null;
        boolean hasRegressions = false;
        if (runRegressions) {
            rateRegression = RegressionUtil.calculateRateRegressions((ApiClient)apiClient, (RegressionInput)input, (PrintStream)output, (boolean)verbose);
            ReportVolume reportVolume = ReportBuilder.getReportVolume(apiClient, input, rateRegression, topEventLimit, regexFilter, output, verbose);
            regressions = ReportBuilder.getAllRegressions(apiClient, input, rateRegression, reportVolume.filter);
            if (regressions != null && regressions.size() > 0) {
                hasRegressions = true;
                ReportBuilder.replaceSourceId2(regressions);
            }
        }
        boolean bl = maxVolumeExceeded = maxEventVolume != 0 && qualityGateReport.getTotalErrorCount() > (long)maxEventVolume.intValue();
        if (maxUniqueErrors != 0) {
            long uniqueEventCount = qualityGateReport.getUniqueErrorCount();
            maxUniqueErrorsExceeded = uniqueEventCount > (long)maxUniqueErrors.intValue();
        } else {
            long uniqueEventCount = 0L;
            maxUniqueErrorsExceeded = false;
        }
        boolean newErrors = false;
        if (qualityGateReport.getNewErrors() != null && qualityGateReport.getNewErrors().size() > 0) {
            newErrors = true;
            ReportBuilder.replaceSourceId(qualityGateReport.getNewErrors());
        }
        boolean resurfaced = false;
        if (qualityGateReport.getResurfacedErrors() != null && qualityGateReport.getResurfacedErrors().size() > 0) {
            resurfaced = true;
            ReportBuilder.replaceSourceId(qualityGateReport.getResurfacedErrors());
        }
        boolean critical = false;
        if (qualityGateReport.getCriticalErrors() != null && qualityGateReport.getCriticalErrors().size() > 0) {
            critical = true;
            ReportBuilder.replaceSourceId(qualityGateReport.getCriticalErrors());
        }
        if (qualityGateReport.getTopErrors() != null && qualityGateReport.getTopErrors().size() > 0) {
            ReportBuilder.replaceSourceId(qualityGateReport.getTopErrors());
        }
        boolean checkCritical = false;
        if (input.criticalExceptionTypes != null && input.criticalExceptionTypes.size() > 0) {
            checkCritical = true;
        }
        boolean unstable = hasRegressions || maxVolumeExceeded || maxUniqueErrorsExceeded || newErrors || resurfaced || critical;
        return new QualityReport(input, rateRegression, regressions, qualityGateReport.getCriticalErrors(), qualityGateReport.getTopErrors(), qualityGateReport.getNewErrors(), qualityGateReport.getResurfacedErrors(), qualityGateReport.getTotalErrorCount(), qualityGateReport.getUniqueErrorCount(), unstable, newEvents, resurfacedEvents, checkCritical, checkMaxEventGate, checkUniqueEventGate, runRegressions, maxEventVolume, maxUniqueErrors, markedUnstable);
    }

    private static void replaceSourceId(List<OOReportEvent> events) {
        for (OOReportEvent ooReportEvent : events) {
            String arcLink = ReportBuilder.replaceSourceIdInArcLink(ooReportEvent.getARCLink());
            ooReportEvent.setArcLink(arcLink);
        }
    }

    private static void replaceSourceId2(List<OOReportRegressedEvent> events) {
        for (OOReportEvent oOReportEvent : events) {
            String arcLink = ReportBuilder.replaceSourceIdInArcLink(oOReportEvent.getARCLink());
            oOReportEvent.setArcLink(arcLink);
        }
    }

    private static String replaceSourceIdInArcLink(String arcLink) {
        if (arcLink == null) {
            return arcLink;
        }
        String target = "source=43";
        String replacement = "source=4";
        String returnString = arcLink.replace(target, replacement);
        return returnString;
    }

    private static List<OOReportRegressedEvent> getAllRegressions(ApiClient apiClient, RegressionInput input, RateRegression rateRegression, Collection<EventResult> filter) {
        OOReportRegressedEvent regressedEvent;
        String arcLink;
        ArrayList<OOReportRegressedEvent> result = new ArrayList<OOReportRegressedEvent>();
        for (RegressionResult regressionResult : rateRegression.getCriticalRegressions().values()) {
            if (filter != null && !filter.contains(regressionResult.getEvent())) continue;
            arcLink = ProcessQualityGates.getArcLink((ApiClient)apiClient, (String)regressionResult.getEvent().id, (RegressionInput)input, (DateTime)rateRegression.getActiveWndowStart());
            regressedEvent = new OOReportRegressedEvent(regressionResult.getEvent(), regressionResult.getBaselineHits(), regressionResult.getBaselineInvocations(), "Severe Regression", arcLink);
            result.add(regressedEvent);
        }
        for (RegressionResult regressionResult : rateRegression.getAllRegressions().values()) {
            if (rateRegression.getCriticalRegressions().containsKey(regressionResult.getEvent().id)) continue;
            arcLink = ProcessQualityGates.getArcLink((ApiClient)apiClient, (String)regressionResult.getEvent().id, (RegressionInput)input, (DateTime)rateRegression.getActiveWndowStart());
            regressedEvent = new OOReportRegressedEvent(regressionResult.getEvent(), regressionResult.getBaselineHits(), regressionResult.getBaselineInvocations(), "Regression", arcLink);
            result.add(regressedEvent);
        }
        return result;
    }

    private static class ReportVolume {
        protected List<OOReportEvent> topEvents;
        protected Collection<EventResult> filter;

        private ReportVolume() {
        }
    }

    public static class QualityReport {
        private final List<OOReportEvent> newIssues;
        private final List<OOReportRegressedEvent> regressions;
        private final List<OOReportEvent> criticalErrors;
        private final List<OOReportEvent> topErrors;
        private final List<OOReportEvent> resurfacedErrors;
        private final List<OOReportEvent> allIssues;
        private final boolean unstable;
        private final RegressionInput input;
        private final RateRegression regression;
        private final long eventVolume;
        private final int uniqueEventsCount;
        private final boolean checkNewGate;
        private final boolean checkResurfacedGate;
        private final boolean checkCriticalGate;
        private final boolean checkVolumeGate;
        private final boolean checkUniqueGate;
        private final boolean checkRegressionGate;
        private final Integer maxEventVolume;
        private final Integer maxUniqueVolume;
        private final boolean markedUnstable;

        protected QualityReport(RegressionInput input, RateRegression regression, List<OOReportRegressedEvent> regressions, List<OOReportEvent> criticalErrors, List<OOReportEvent> topErrors, List<OOReportEvent> newIssues, List<OOReportEvent> resurfacedErrors, long eventVolume, int uniqueEventCounts, boolean unstable, boolean checkNewGate, boolean checkResurfacedGate, boolean checkCriticalGate, boolean checkVolumeGate, boolean checkUniqueGate, boolean checkRegressionGate, Integer maxEventVolume, Integer maxUniqueVolume, boolean markedUnstable) {
            this.input = input;
            this.regression = regression;
            this.regressions = regressions;
            this.allIssues = new ArrayList<OOReportEvent>();
            this.newIssues = newIssues;
            this.criticalErrors = criticalErrors;
            this.topErrors = topErrors;
            this.resurfacedErrors = resurfacedErrors;
            if (regressions != null) {
                this.allIssues.addAll(regressions);
            }
            this.eventVolume = eventVolume;
            this.uniqueEventsCount = uniqueEventCounts;
            this.unstable = unstable;
            this.checkNewGate = checkNewGate;
            this.checkResurfacedGate = checkResurfacedGate;
            this.checkCriticalGate = checkCriticalGate;
            this.checkVolumeGate = checkVolumeGate;
            this.checkUniqueGate = checkUniqueGate;
            this.checkRegressionGate = checkRegressionGate;
            this.maxEventVolume = maxEventVolume;
            this.maxUniqueVolume = maxUniqueVolume;
            this.markedUnstable = markedUnstable;
        }

        public RegressionInput getInput() {
            return this.input;
        }

        public RateRegression getRegression() {
            return this.regression;
        }

        public List<OOReportEvent> getResurfacedErrors() {
            return this.resurfacedErrors;
        }

        public List<OOReportEvent> getAllIssues() {
            return this.allIssues;
        }

        public List<OOReportEvent> getCriticalErrors() {
            return this.criticalErrors;
        }

        public List<OOReportEvent> getTopErrors() {
            return this.topErrors;
        }

        public List<OOReportEvent> getNewIssues() {
            return this.newIssues;
        }

        public List<OOReportRegressedEvent> getRegressions() {
            return this.regressions;
        }

        public long getUniqueEventsCount() {
            return this.uniqueEventsCount;
        }

        public boolean getUnstable() {
            return this.unstable;
        }

        public long getEventVolume() {
            return this.eventVolume;
        }

        public boolean isCheckNewGate() {
            return this.checkNewGate;
        }

        public boolean isCheckResurfacedGate() {
            return this.checkResurfacedGate;
        }

        public boolean isCheckCriticalGate() {
            return this.checkCriticalGate;
        }

        public boolean isCheckVolumeGate() {
            return this.checkVolumeGate;
        }

        public boolean isCheckUniqueGate() {
            return this.checkUniqueGate;
        }

        public boolean isCheckRegressionGate() {
            return this.checkRegressionGate;
        }

        public Integer getMaxEventVolume() {
            return this.maxEventVolume;
        }

        public Integer getMaxUniqueVolume() {
            return this.maxUniqueVolume;
        }

        public boolean isMarkedUnstable() {
            return this.markedUnstable;
        }
    }

    private static class UniqueEventKey {
        private EventResult event;

        protected UniqueEventKey(EventResult event) {
            this.event = event;
        }

        public int hashCode() {
            if (this.event.error_location == null) {
                return super.hashCode();
            }
            return this.event.error_location.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UniqueEventKey)) {
                return false;
            }
            UniqueEventKey other = (UniqueEventKey)obj;
            if (!Objects.equal((Object)this.event.type, (Object)other.event.type)) {
                return false;
            }
            if (!Objects.equal((Object)this.event.error_origin, (Object)other.event.error_origin)) {
                return false;
            }
            if (!Objects.equal((Object)this.event.error_location, (Object)other.event.error_location)) {
                return false;
            }
            if (!Objects.equal((Object)this.event.name, (Object)other.event.name)) {
                return false;
            }
            return Objects.equal((Object)this.event.call_stack_group, (Object)other.event.call_stack_group);
        }
    }
}

