/*
 * Decompiled with CFR 0.152.
 */
package com.overops.plugins.jenkins.query;

import com.overops.plugins.jenkins.query.QueryOverOps;
import com.takipi.api.client.ApiClient;
import com.takipi.api.client.data.service.SummarizedService;
import com.takipi.api.client.util.client.ClientUtil;
import com.takipi.api.core.url.UrlClient;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.util.List;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;

@Extension
@Symbol(value={"OverOpsQuery"})
public final class DescriptorImpl
extends BuildStepDescriptor<Publisher> {
    private String overOpsURL;
    private String overOpsSID;
    private Secret overOpsAPIKey;

    public DescriptorImpl() {
        super(QueryOverOps.class);
        this.load();
    }

    public boolean isApplicable(Class<? extends AbstractProject> aClass) {
        return true;
    }

    public String getDisplayName() {
        return "OverOps Quality Report";
    }

    public boolean configure(StaplerRequest req, JSONObject formData) {
        JSONObject QueryOverOpsJson = formData.getJSONObject("QueryOverOps");
        this.overOpsURL = QueryOverOpsJson.getString("overOpsURL");
        this.overOpsSID = QueryOverOpsJson.getString("overOpsSID");
        this.overOpsAPIKey = Secret.fromString((String)QueryOverOpsJson.getString("overOpsAPIKey"));
        this.save();
        return false;
    }

    public String getOverOpsURL() {
        return this.overOpsURL;
    }

    public String getOverOpsSID() {
        return this.overOpsSID;
    }

    public Secret getOverOpsAPIKey() {
        return this.overOpsAPIKey;
    }

    private boolean hasAccessToService(ApiClient apiClient, String serviceId) {
        List services;
        try {
            services = ClientUtil.getEnvironments((ApiClient)apiClient);
        }
        catch (Exception e) {
            System.err.println(e);
            return false;
        }
        for (SummarizedService service : services) {
            if (!service.id.equals(serviceId)) continue;
            return true;
        }
        return false;
    }

    @POST
    public FormValidation doTestConnection(@QueryParameter(value="overOpsURL") String overOpsURL, @QueryParameter(value="overOpsSID") String overOpsSID, @QueryParameter(value="overOpsAPIKey") Secret overOpsAPIKey) {
        if (overOpsURL == null || overOpsURL.isEmpty()) {
            return FormValidation.error((String)"OverOps URL is empty");
        }
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        try {
            boolean testService;
            String apiKey = Secret.toString((Secret)overOpsAPIKey);
            ApiClient apiClient = ApiClient.newBuilder().setHostname(overOpsURL).setApiKey(apiKey).build();
            UrlClient.Response response = apiClient.testConnection();
            boolean testConnection = response == null || response.isBadResponse();
            boolean bl = testService = overOpsSID == null || this.hasAccessToService(apiClient, overOpsSID);
            if (testConnection) {
                int code = response != null ? response.responseCode : -1;
                return FormValidation.error((String)("Unable to connect to API server. Code: " + code));
            }
            if (!testService) {
                return FormValidation.error((String)("API key has no access to environment " + overOpsSID));
            }
            return FormValidation.ok((String)"Connection Successful.");
        }
        catch (Exception e) {
            return FormValidation.error((Throwable)e, (String)("REST API error : " + e.getMessage()));
        }
    }
}

