/*
 * Decompiled with CFR 0.152.
 */
package com.overops.plugins.jenkins.query;

import com.google.common.base.Objects;
import com.google.gson.Gson;
import com.overops.plugins.jenkins.query.OOReportEvent;
import com.overops.plugins.jenkins.query.OOReportRegressedEvent;
import com.takipi.api.client.ApiClient;
import com.takipi.api.client.result.event.EventResult;
import com.takipi.api.client.util.event.EventUtil;
import com.takipi.api.client.util.regression.RateRegression;
import com.takipi.api.client.util.regression.RegressionInput;
import com.takipi.api.client.util.regression.RegressionResult;
import com.takipi.api.client.util.regression.RegressionUtil;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.joda.time.DateTime;

public class RegressionReportBuilder {
    public static String getArcLink(ApiClient apiClient, String eventId, RegressionInput input, RateRegression regression) {
        DateTime activeWndowStart = regression.getActiveWndowStart();
        DateTime from = activeWndowStart.minusMinutes(input.baselineTimespan);
        String result = EventUtil.getEventRecentLinkDefault((ApiClient)apiClient, (String)input.serviceId, (String)eventId, (DateTime)from, (DateTime)DateTime.now(), (Collection)input.applictations, (Collection)input.servers, (Collection)input.deployments, (int)EventUtil.DEFAULT_PERIOD);
        return result;
    }

    private static boolean allowEvent(EventResult event, Pattern pattern) {
        if (pattern == null) {
            return true;
        }
        String json = new Gson().toJson((Object)event);
        boolean result = !pattern.matcher(json).find();
        return result;
    }

    private static List<EventResult> getSortedEventsByVolume(Collection<EventResult> events) {
        ArrayList<EventResult> result = new ArrayList<EventResult>(events);
        result.sort(new Comparator<EventResult>(){

            @Override
            public int compare(EventResult o1, EventResult o2) {
                long v1 = o1.stats != null ? o1.stats.hits : 0L;
                long v2 = o2.stats != null ? o2.stats.hits : 0L;
                return (int)(v2 - v1);
            }
        });
        return result;
    }

    private static void addEvent(Set<EventResult> events, EventResult event, Pattern pattern, PrintStream output, boolean verbose) {
        if (RegressionReportBuilder.allowEvent(event, pattern)) {
            events.add(event);
        } else if (output != null && verbose) {
            output.println(event + " did not match regexFilter and was skipped");
        }
    }

    private static Collection<EventResult> filterEvents(RateRegression rateRegression, Pattern pattern, PrintStream output, boolean verbose) {
        HashSet<EventResult> result = new HashSet<EventResult>();
        if (pattern != null) {
            for (EventResult event : rateRegression.getNonRegressions()) {
                RegressionReportBuilder.addEvent(result, event, pattern, output, verbose);
            }
            for (EventResult event : rateRegression.getAllNewEvents().values()) {
                RegressionReportBuilder.addEvent(result, event, pattern, output, verbose);
            }
            for (RegressionResult regressionResult : rateRegression.getAllRegressions().values()) {
                RegressionReportBuilder.addEvent(result, regressionResult.getEvent(), pattern, output, verbose);
            }
        } else {
            result.addAll(rateRegression.getNonRegressions());
            result.addAll(rateRegression.getAllNewEvents().values());
            for (RegressionResult regressionResult : rateRegression.getAllRegressions().values()) {
                result.add(regressionResult.getEvent());
            }
        }
        return result;
    }

    private static ReportVolume getReportVolume(ApiClient apiClient, RegressionInput input, RateRegression rateRegression, int limit, String regexFilter, PrintStream output, boolean verbose) {
        ReportVolume result = new ReportVolume();
        Pattern pattern = regexFilter != null && regexFilter.length() > 0 ? Pattern.compile(regexFilter) : null;
        Collection<EventResult> eventsSet = RegressionReportBuilder.filterEvents(rateRegression, pattern, output, verbose);
        List<EventResult> events = RegressionReportBuilder.getSortedEventsByVolume(eventsSet);
        if (pattern != null) {
            result.filter = eventsSet;
        }
        result.topEvents = new ArrayList<OOReportEvent>();
        for (EventResult event : events) {
            if (event.stats != null) {
                result.volume += event.stats.hits;
                if (event.stats.hits > 0L && result.topEvents.size() < limit) {
                    String arcLink = RegressionReportBuilder.getArcLink(apiClient, event.id, input, rateRegression);
                    result.topEvents.add(new OOReportEvent(event, arcLink));
                }
            }
            if (rateRegression.getCriticalRegressions().containsKey(event.id)) {
                result.hasCriticalRegression = true;
            }
            if (rateRegression.getCriticalNewEvents().containsKey(event.id)) {
                result.hasNewCritical = true;
            }
            if (!rateRegression.getSortedExceededNewEvents().contains(event)) continue;
            result.hasNewExceeded = true;
        }
        result.eventCount = RegressionReportBuilder.getUniqueErrorCount(events);
        return result;
    }

    private static int getUniqueErrorCount(Collection<EventResult> events) {
        HashSet<UniqueEventKey> grouped = new HashSet<UniqueEventKey>(events.size());
        for (EventResult event : events) {
            UniqueEventKey uniqueEventKey = new UniqueEventKey(event);
            grouped.add(uniqueEventKey);
        }
        int result = grouped.size();
        return result;
    }

    public static RegressionReport execute(ApiClient apiClient, RegressionInput input, int maxEventVolume, int maxUniqueErrors, int topEventLimit, String regexFilter, PrintStream output, boolean verbose) {
        boolean maxUniqueErrorsExceeded;
        int uniqueEventCount;
        boolean maxVolumeExceeded;
        RateRegression rateRegression = RegressionUtil.calculateRateRegressions((ApiClient)apiClient, (RegressionInput)input, (PrintStream)output, (boolean)verbose);
        ReportVolume reportVolume = RegressionReportBuilder.getReportVolume(apiClient, input, rateRegression, topEventLimit, regexFilter, output, verbose);
        List<OOReportEvent> newIssues = RegressionReportBuilder.getAllNewEvents(apiClient, input, rateRegression, reportVolume.filter);
        List<OOReportRegressedEvent> regressions = RegressionReportBuilder.getAllRegressions(apiClient, input, rateRegression, reportVolume.filter);
        boolean bl = maxVolumeExceeded = maxEventVolume > 0 && reportVolume.volume > (long)maxEventVolume;
        if (maxUniqueErrors > 0) {
            uniqueEventCount = reportVolume.eventCount;
            maxUniqueErrorsExceeded = reportVolume.eventCount > maxUniqueErrors;
        } else {
            uniqueEventCount = 0;
            maxUniqueErrorsExceeded = false;
        }
        boolean unstable = reportVolume.hasNewCritical || reportVolume.hasNewExceeded || reportVolume.hasCriticalRegression || maxVolumeExceeded || maxUniqueErrorsExceeded;
        return new RegressionReport(input, rateRegression, newIssues, regressions, reportVolume.topEvents, reportVolume.volume, maxEventVolume, uniqueEventCount, maxUniqueErrors, unstable);
    }

    private static List<OOReportEvent> getReportSevereEvents(ApiClient apiClient, RegressionInput input, RateRegression regression, Collection<EventResult> events, Collection<EventResult> filter, String type) {
        ArrayList<OOReportEvent> result = new ArrayList<OOReportEvent>();
        for (EventResult event : events) {
            if (filter != null && !filter.contains(event)) continue;
            String arcLink = RegressionReportBuilder.getArcLink(apiClient, event.id, input, regression);
            OOReportEvent reportEvent = new OOReportEvent(event, type, arcLink);
            result.add(reportEvent);
        }
        return result;
    }

    private static List<OOReportEvent> getReportNewEvents(ApiClient apiClient, RegressionInput input, RateRegression rateRegression, Collection<EventResult> filter) {
        ArrayList<OOReportEvent> result = new ArrayList<OOReportEvent>();
        for (EventResult event : rateRegression.getAllNewEvents().values()) {
            if (filter != null && !filter.contains(event) || rateRegression.getCriticalNewEvents().containsKey(event.id) || rateRegression.getExceededNewEvents().containsKey(event.id)) continue;
            String arcLink = RegressionReportBuilder.getArcLink(apiClient, event.id, input, rateRegression);
            OOReportEvent newEvent = new OOReportEvent(event, "New", arcLink);
            result.add(newEvent);
        }
        return result;
    }

    private static List<OOReportEvent> getAllNewEvents(ApiClient apiClient, RegressionInput input, RateRegression rateRegression, Collection<EventResult> filter) {
        ArrayList<OOReportEvent> result = new ArrayList<OOReportEvent>();
        result.addAll(RegressionReportBuilder.getReportSevereEvents(apiClient, input, rateRegression, rateRegression.getCriticalNewEvents().values(), filter, "Severe New"));
        result.addAll(RegressionReportBuilder.getReportSevereEvents(apiClient, input, rateRegression, rateRegression.getExceededNewEvents().values(), filter, "Severe New"));
        result.addAll(RegressionReportBuilder.getReportNewEvents(apiClient, input, rateRegression, filter));
        return result;
    }

    private static List<OOReportRegressedEvent> getAllRegressions(ApiClient apiClient, RegressionInput input, RateRegression rateRegression, Collection<EventResult> filter) {
        OOReportRegressedEvent regressedEvent;
        String arcLink;
        ArrayList<OOReportRegressedEvent> result = new ArrayList<OOReportRegressedEvent>();
        for (RegressionResult regressionResult : rateRegression.getCriticalRegressions().values()) {
            if (filter != null && !filter.contains(regressionResult.getEvent())) continue;
            arcLink = RegressionReportBuilder.getArcLink(apiClient, regressionResult.getEvent().id, input, rateRegression);
            regressedEvent = new OOReportRegressedEvent(regressionResult.getEvent(), regressionResult.getBaselineHits(), regressionResult.getBaselineInvocations(), "Severe Regression", arcLink);
            result.add(regressedEvent);
        }
        for (RegressionResult regressionResult : rateRegression.getAllRegressions().values()) {
            if (rateRegression.getCriticalRegressions().containsKey(regressionResult.getEvent().id)) continue;
            arcLink = RegressionReportBuilder.getArcLink(apiClient, regressionResult.getEvent().id, input, rateRegression);
            regressedEvent = new OOReportRegressedEvent(regressionResult.getEvent(), regressionResult.getBaselineHits(), regressionResult.getBaselineInvocations(), "Regression", arcLink);
            result.add(regressedEvent);
        }
        return result;
    }

    private static class ReportVolume {
        protected long volume;
        protected int eventCount;
        protected List<OOReportEvent> topEvents;
        protected boolean hasNewExceeded;
        protected boolean hasNewCritical;
        protected boolean hasCriticalRegression;
        protected Collection<EventResult> filter;

        private ReportVolume() {
        }
    }

    public static class RegressionReport {
        private final List<OOReportEvent> newIssues;
        private final List<OOReportRegressedEvent> regressions;
        private final List<OOReportEvent> allIssues;
        private final List<OOReportEvent> topIssues;
        private final boolean unstable;
        private final RegressionInput input;
        private final RateRegression regression;
        private final long eventVolume;
        private final int maxEventVolume;
        private final int uniqueEventsCount;
        private final int maxUniqueEvents;

        protected RegressionReport(RegressionInput input, RateRegression regression, List<OOReportEvent> newIssues, List<OOReportRegressedEvent> regressions, List<OOReportEvent> topIssues, long eventVolume, int maxEventVolume, int uniqueEventCounts, int maxUniqueEvents, boolean unstable) {
            this.input = input;
            this.regression = regression;
            this.newIssues = newIssues;
            this.regressions = regressions;
            this.topIssues = topIssues;
            this.allIssues = new ArrayList<OOReportEvent>();
            this.allIssues.addAll(newIssues);
            this.allIssues.addAll(regressions);
            this.eventVolume = eventVolume;
            this.maxEventVolume = maxEventVolume;
            this.uniqueEventsCount = uniqueEventCounts;
            this.maxUniqueEvents = maxUniqueEvents;
            this.unstable = unstable;
        }

        public RegressionInput getInput() {
            return this.input;
        }

        public RateRegression getRegression() {
            return this.regression;
        }

        public List<OOReportEvent> getAllIssues() {
            return this.allIssues;
        }

        public List<OOReportEvent> getNewIssues() {
            return this.newIssues;
        }

        public List<OOReportRegressedEvent> getRegressions() {
            return this.regressions;
        }

        public List<OOReportEvent> getTopIssues() {
            return this.topIssues;
        }

        public int getMaxUniqueEvents() {
            return this.maxUniqueEvents;
        }

        public long getUniqueEventsCount() {
            return this.uniqueEventsCount;
        }

        public int getMaxEventVolume() {
            return this.maxEventVolume;
        }

        public long getEventVolume() {
            return this.eventVolume;
        }

        public boolean getUnstable() {
            return this.unstable;
        }
    }

    private static class UniqueEventKey {
        private EventResult event;

        protected UniqueEventKey(EventResult event) {
            this.event = event;
        }

        public int hashCode() {
            if (this.event.error_location == null) {
                return super.hashCode();
            }
            return this.event.error_location.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UniqueEventKey)) {
                return false;
            }
            UniqueEventKey other = (UniqueEventKey)obj;
            if (!Objects.equal((Object)this.event.type, (Object)other.event.type)) {
                return false;
            }
            if (!Objects.equal((Object)this.event.error_origin, (Object)other.event.error_origin)) {
                return false;
            }
            if (!Objects.equal((Object)this.event.error_location, (Object)other.event.error_location)) {
                return false;
            }
            if (!Objects.equal((Object)this.event.name, (Object)other.event.name)) {
                return false;
            }
            return Objects.equal((Object)this.event.call_stack_group, (Object)other.event.call_stack_group);
        }
    }
}

