/*
 * Decompiled with CFR 0.152.
 */
package com.overops.plugins.jenkins.query;

import com.overops.plugins.jenkins.query.DescriptorImpl;
import com.overops.plugins.jenkins.query.OverOpsBuildAction;
import com.overops.plugins.jenkins.query.RegressionReportBuilder;
import com.takipi.api.client.ApiClient;
import com.takipi.api.client.data.view.SummarizedView;
import com.takipi.api.client.util.regression.RegressionInput;
import com.takipi.api.client.util.view.ViewUtil;
import com.takipi.api.core.url.UrlClient;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import hudson.util.Secret;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.DataBoundConstructor;

public class QueryOverOps
extends Recorder
implements SimpleBuildStep {
    private static final String SEPERATOR = ",";
    private final int activeTimespan;
    private final int baselineTimespan;
    private final String criticalExceptionTypes;
    private final int minVolumeThreshold;
    private final double minErrorRateThreshold;
    private final double regressionDelta;
    private final double criticalRegressionDelta;
    private final boolean applySeasonality;
    private final int serverWait;
    private final boolean showResults;
    private final boolean verbose;
    private final int printTopIssues;
    private final int maxErrorVolume;
    private final int maxUniqueErrors;
    private final String serviceId;
    private final String regexFilter;
    private String applicationName;
    private String deploymentName;
    private final boolean markUnstable;

    @DataBoundConstructor
    public QueryOverOps(String applicationName, String deploymentName, int activeTimespan, int baselineTimespan, String criticalExceptionTypes, int minVolumeThreshold, double minErrorRateThreshold, double regressionDelta, double criticalRegressionDelta, boolean applySeasonality, boolean markUnstable, boolean showResults, int printTopIssues, int maxErrorVolume, int maxUniqueErrors, String regexFilter, boolean verbose, String serviceId, int serverWait) {
        this.serviceId = serviceId;
        this.applicationName = applicationName;
        this.deploymentName = deploymentName;
        this.criticalExceptionTypes = criticalExceptionTypes;
        this.activeTimespan = activeTimespan;
        this.baselineTimespan = baselineTimespan;
        this.minErrorRateThreshold = minErrorRateThreshold;
        this.minVolumeThreshold = minVolumeThreshold;
        this.applySeasonality = applySeasonality;
        this.regressionDelta = regressionDelta;
        this.criticalRegressionDelta = criticalRegressionDelta;
        this.maxErrorVolume = maxErrorVolume;
        this.maxUniqueErrors = maxUniqueErrors;
        this.regexFilter = regexFilter;
        this.printTopIssues = printTopIssues;
        this.serverWait = serverWait;
        this.verbose = verbose;
        this.showResults = showResults;
        this.markUnstable = markUnstable;
    }

    public String getapplicationName() {
        return this.applicationName;
    }

    public String getdeploymentName() {
        return this.deploymentName;
    }

    public int getactiveTimespan() {
        return this.activeTimespan;
    }

    public int getbaselineTimespan() {
        return this.baselineTimespan;
    }

    public double getminErrorRateThreshold() {
        return this.minErrorRateThreshold;
    }

    public double getminVolumeThreshold() {
        return this.minVolumeThreshold;
    }

    public double getregressionDelta() {
        return this.regressionDelta;
    }

    public String getcriticalExceptionTypes() {
        return this.criticalExceptionTypes;
    }

    public double getcriticalRegressionDelta() {
        return this.criticalRegressionDelta;
    }

    public String getregexFilter() {
        return this.regexFilter;
    }

    public String getserviceId() {
        return this.serviceId;
    }

    public int getserverWait() {
        return this.serverWait;
    }

    public boolean getverbose() {
        return this.verbose;
    }

    public boolean getshowResults() {
        return this.showResults;
    }

    public int getmaxErrorVolume() {
        return this.maxErrorVolume;
    }

    public int getmaxUniqueErrors() {
        return this.maxUniqueErrors;
    }

    public int getprintTopIssues() {
        return this.printTopIssues;
    }

    public boolean getmarkUnstable() {
        return this.markUnstable;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private static boolean isResolved(String value) {
        boolean isVar = value.startsWith("${") && value.endsWith("}");
        return !isVar;
    }

    private static Collection<String> parseArrayString(String value, PrintStream printStream, String name) {
        if (value == null || value.isEmpty()) {
            return Collections.emptySet();
        }
        if (!QueryOverOps.isResolved(value)) {
            printStream.println("Value " + value + " is unresolved for " + name + ". Ignoring.");
            return Collections.emptySet();
        }
        List<String> result = Arrays.asList(value.trim().split(Pattern.quote(SEPERATOR)));
        return result;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        SummarizedView allEventsView;
        String apiHost = this.getDescriptor().getOverOpsURL();
        String apiKey = Secret.toString((Secret)this.getDescriptor().getOverOpsAPIKey());
        if (apiHost == null) {
            throw new IllegalArgumentException("Missing host name");
        }
        if (apiKey == null) {
            throw new IllegalArgumentException("Missing api key");
        }
        String serviceId = this.serviceId != null && !this.serviceId.isEmpty() ? this.serviceId : this.getDescriptor().getOverOpsSID();
        if (serviceId == null) {
            throw new IllegalArgumentException("Missing environment Id");
        }
        PrintStream printStream = this.showResults ? listener.getLogger() : null;
        ApiClient apiClient = ApiClient.newBuilder().setHostname(apiHost).setApiKey(apiKey).build();
        if (printStream != null && this.showResults) {
            apiClient.addObserver((UrlClient.UrlClientObserver)new ApiClientObserver(printStream, this.verbose));
        }
        if ((allEventsView = ViewUtil.getServiceViewByName((ApiClient)apiClient, (String)serviceId, (String)"All Events")) == null) {
            throw new IllegalStateException("Could not acquire ID for 'All Events'. Please check connection to " + apiHost);
        }
        if (this.serverWait > 0) {
            if (this.showResults && printStream != null) {
                printStream.println("Waiting " + this.serverWait + " seconds for code analysis to complete");
            }
            TimeUnit.SECONDS.sleep(this.serverWait);
        }
        RegressionInput input = new RegressionInput();
        input.serviceId = serviceId;
        input.viewId = allEventsView.id;
        input.activeTimespan = this.activeTimespan;
        input.baselineTimespan = this.baselineTimespan;
        input.minVolumeThreshold = this.minVolumeThreshold;
        input.minErrorRateThreshold = this.minErrorRateThreshold;
        input.regressionDelta = this.regressionDelta;
        input.criticalRegressionDelta = this.criticalRegressionDelta;
        input.applySeasonality = this.applySeasonality;
        String expandedAppName = run.getEnvironment(listener).expand(this.applicationName);
        String expandedDepName = run.getEnvironment(listener).expand(this.deploymentName);
        input.criticalExceptionTypes = QueryOverOps.parseArrayString(this.criticalExceptionTypes, printStream, "Critical Exception Types");
        input.applictations = QueryOverOps.parseArrayString(expandedAppName, printStream, "Application Name");
        input.deployments = QueryOverOps.parseArrayString(expandedDepName, printStream, "Deployment Name");
        input.validate();
        this.printInputs(printStream, input);
        RegressionReportBuilder.RegressionReport report = RegressionReportBuilder.execute(apiClient, input, this.maxErrorVolume, this.maxUniqueErrors, this.printTopIssues, this.regexFilter, printStream, this.verbose);
        OverOpsBuildAction buildAction = new OverOpsBuildAction(report, run);
        run.addAction((Action)buildAction);
        if (this.markUnstable && report.getUnstable()) {
            run.setResult(Result.UNSTABLE);
        }
    }

    private void printInputs(PrintStream printStream, RegressionInput input) {
        if (printStream != null) {
            printStream.println(input);
            printStream.println("Max unique errors  = " + this.maxUniqueErrors);
            printStream.println("Max error volume  = " + this.maxErrorVolume);
            String regexPrint = this.regexFilter != null ? this.regexFilter : "";
            printStream.println("Regex filter  = " + regexPrint);
        }
    }

    protected static class ApiClientObserver
    implements UrlClient.UrlClientObserver {
        private final PrintStream printStream;
        private final boolean verbose;

        public ApiClientObserver(PrintStream printStream, boolean verbose) {
            this.printStream = printStream;
            this.verbose = verbose;
        }

        public void observe(UrlClient.Operation operation, String url, String response, long time) {
            StringBuilder output = new StringBuilder();
            output.append(String.valueOf(operation));
            output.append(" took ");
            output.append(time / 1000L);
            output.append("ms for ");
            output.append(url);
            if (this.verbose) {
                output.append(". Response: ");
                output.append(response);
            }
            this.printStream.println(output.toString());
        }
    }
}

