/*
 * Decompiled with CFR 0.152.
 */
package com.overops.plugins.jenkins.query;

import com.overops.plugins.jenkins.query.OOReportEvent;
import com.overops.plugins.jenkins.query.OOReportRegressedEvent;
import com.overops.plugins.jenkins.query.RegressionReportBuilder;
import com.takipi.api.client.util.regression.RegressionInput;
import com.takipi.api.client.util.regression.RegressionStringUtil;
import hudson.model.Action;
import hudson.model.Run;
import java.util.List;
import org.joda.time.DateTime;

public class OverOpsBuildAction
implements Action {
    private static final String ISSUE = "Issue";
    private final Run<?, ?> build;
    private final RegressionReportBuilder.RegressionReport regressionReport;

    OverOpsBuildAction(RegressionReportBuilder.RegressionReport regressionReport, Run<?, ?> build) {
        this.regressionReport = regressionReport;
        this.build = build;
    }

    public String getIconFileName() {
        return "/plugin/overops-query/images/OverOps.png";
    }

    public String getDisplayName() {
        return "OverOps Reliability Report";
    }

    public String getUrlName() {
        return "OverOpsReport";
    }

    public boolean getHasTopIssues() {
        return this.regressionReport.getTopIssues().size() > 0;
    }

    public boolean getHasReportEvents() {
        return this.regressionReport.getAllIssues().size() > 0;
    }

    public String getTopIssuesTitle() {
        return String.format("Top %d Issues", this.regressionReport.getTopIssues().size());
    }

    public String getSummary() {
        boolean uniqueErrorCountExceeded;
        boolean eventVolumeExeeded;
        String regName;
        StringBuilder result = new StringBuilder();
        int newIssues = 0;
        int severeNewIssues = 0;
        int regressions = 0;
        int severeRegressions = 0;
        for (OOReportEvent event : this.regressionReport.getAllIssues()) {
            String type = event.getType();
            if (type.equals("Severe New")) {
                ++severeNewIssues;
                continue;
            }
            if (type.equals("New")) {
                ++newIssues;
                continue;
            }
            if (type.equals("Severe Regression")) {
                ++severeRegressions;
                continue;
            }
            if (!type.equals("Regression")) continue;
            ++regressions;
        }
        OverOpsBuildAction.appendSummaryValue(result, "Severe New", severeNewIssues, true);
        OverOpsBuildAction.appendSummaryValue(result, "New", newIssues, true);
        OverOpsBuildAction.appendSummaryValue(result, "Severe Regression", severeRegressions, false);
        OverOpsBuildAction.appendSummaryValue(result, "Regression", regressions, false);
        if (result.length() == 0) {
            result.append("No new errors or regressions found");
        }
        if ((regName = RegressionStringUtil.getRegressionName((RegressionInput)this.regressionReport.getInput(), (DateTime)this.regressionReport.getRegression().getActiveWndowStart())) != null) {
            result.append(" in ");
            result.append(regName);
        }
        boolean bl = eventVolumeExeeded = this.regressionReport.getMaxEventVolume() > 0 && this.regressionReport.getEventVolume() > (long)this.regressionReport.getMaxEventVolume();
        if (eventVolumeExeeded) {
            result.append(". Error volume ");
            result.append(this.regressionReport.getEventVolume());
            result.append(" exceeded max ");
            result.append(this.regressionReport.getMaxEventVolume());
        }
        boolean bl2 = uniqueErrorCountExceeded = this.regressionReport.getMaxUniqueEvents() > 0 && this.regressionReport.getUniqueEventsCount() > (long)this.regressionReport.getMaxUniqueEvents();
        if (uniqueErrorCountExceeded) {
            result.append(". Unique error count ");
            result.append(this.regressionReport.getUniqueEventsCount());
            result.append(" exceeded max ");
            result.append(this.regressionReport.getMaxUniqueEvents());
        }
        return result.toString();
    }

    private static void appendSummaryValue(StringBuilder builder, String name, int value, boolean appendPostfix) {
        if (value > 0) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(value);
            builder.append(" ");
            builder.append(name);
            if (appendPostfix) {
                builder.append(" ");
                builder.append(ISSUE);
            }
            if (value > 1) {
                builder.append("s");
            }
        }
    }

    public List<OOReportRegressedEvent> getRegressedEvents() {
        return this.regressionReport.getRegressions();
    }

    public List<OOReportEvent> getNewEvents() {
        return this.regressionReport.getNewIssues();
    }

    public List<OOReportEvent> getAllIssues() {
        return this.regressionReport.getAllIssues();
    }

    public List<OOReportEvent> getTopIssues() {
        return this.regressionReport.getTopIssues();
    }

    public int getBuildNumber() {
        return this.build.number;
    }

    public Run<?, ?> getBuild() {
        return this.build;
    }
}

