/*
 * Decompiled with CFR 0.152.
 */
package com.overops.plugins.jenkins.query;

import com.overops.common.api.util.ApiEventUtil;
import com.overops.common.util.RegressionUtil;
import com.overops.plugins.jenkins.query.OOReportEvent;
import com.overops.plugins.jenkins.query.OOReportRegressedEvent;
import com.takipi.common.api.ApiClient;
import com.takipi.common.api.result.event.EventResult;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class RegressionReportBuilder {
    public static String getArcLink(ApiClient apiClient, String serviceId, String eventId, int timespan) {
        String result = ApiEventUtil.getEventRecentLink(apiClient, serviceId, eventId, timespan);
        return result;
    }

    public static RegressionReport execute(ApiClient apiClient, String serviceId, String viewId, int activeTimespan, int baselineTimespan, String criticalExceptionTypes, int minVolumeThreshold, double minErrorRateThreshold, double reggressionDelta, double criticalReggressionDelta, PrintStream output) {
        List<String> criticalExceptionTypeList = criticalExceptionTypes != null ? Arrays.asList(criticalExceptionTypes.split(",")) : Collections.emptyList();
        RegressionUtil.RateRegression rateRegression = RegressionUtil.calculateRateRegressions(apiClient, serviceId, viewId, activeTimespan, baselineTimespan, minVolumeThreshold, minErrorRateThreshold, reggressionDelta, criticalReggressionDelta, criticalExceptionTypeList, output);
        List<OOReportEvent> newIssues = RegressionReportBuilder.getAllNewEvents(apiClient, serviceId, baselineTimespan, rateRegression);
        List<OOReportRegressedEvent> regressions = RegressionReportBuilder.getAllRegressions(apiClient, serviceId, baselineTimespan, rateRegression);
        boolean unstable = rateRegression.getCriticalNewEvents().size() > 0 || rateRegression.getExceededNewEvents().size() > 0 || rateRegression.getCriticalRegressions().size() > 0;
        return new RegressionReport(newIssues, regressions, unstable);
    }

    private static List<OOReportEvent> getReportSevereEvents(ApiClient apiClient, String serviceId, int timespan, Collection<EventResult> events, String type) {
        ArrayList<OOReportEvent> result = new ArrayList<OOReportEvent>();
        for (EventResult event : events) {
            String arcLink = RegressionReportBuilder.getArcLink(apiClient, serviceId, event.id, timespan);
            OOReportEvent reportEvent = new OOReportEvent(event, type, arcLink);
            result.add(reportEvent);
        }
        return result;
    }

    private static List<OOReportEvent> getReportNewEvents(ApiClient apiClient, String serviceId, int timespan, RegressionUtil.RateRegression rateRegression) {
        ArrayList<OOReportEvent> result = new ArrayList<OOReportEvent>();
        for (EventResult event : rateRegression.getAllNewEvents().values()) {
            if (rateRegression.getCriticalNewEvents().containsKey(event.id) || rateRegression.getExceededNewEvents().containsKey(event.id)) continue;
            String arcLink = RegressionReportBuilder.getArcLink(apiClient, serviceId, event.id, timespan);
            OOReportEvent newEvent = new OOReportEvent(event, "New", arcLink);
            result.add(newEvent);
        }
        return result;
    }

    private static List<OOReportEvent> getAllNewEvents(ApiClient apiClient, String serviceId, int baselineTimespan, RegressionUtil.RateRegression rateRegression) {
        ArrayList<OOReportEvent> result = new ArrayList<OOReportEvent>();
        result.addAll(RegressionReportBuilder.getReportSevereEvents(apiClient, serviceId, baselineTimespan, rateRegression.getCriticalNewEvents().values(), "Severe New"));
        result.addAll(RegressionReportBuilder.getReportSevereEvents(apiClient, serviceId, baselineTimespan, rateRegression.getExceededNewEvents().values(), "Severe New"));
        result.addAll(RegressionReportBuilder.getReportNewEvents(apiClient, serviceId, baselineTimespan, rateRegression));
        return result;
    }

    private static List<OOReportRegressedEvent> getAllRegressions(ApiClient apiClient, String serviceId, int timespan, RegressionUtil.RateRegression rateRegression) {
        OOReportRegressedEvent regressedEvent;
        String arcLink;
        ArrayList<OOReportRegressedEvent> result = new ArrayList<OOReportRegressedEvent>();
        for (RegressionUtil.RegressionPair pair : rateRegression.getCriticalRegressions().values()) {
            arcLink = RegressionReportBuilder.getArcLink(apiClient, serviceId, pair.getActiveEvent().id, timespan);
            regressedEvent = new OOReportRegressedEvent(pair.getActiveEvent(), pair.getBaseEvent(), "Severe Regression", arcLink);
            result.add(regressedEvent);
        }
        for (RegressionUtil.RegressionPair pair : rateRegression.getAllRegressions().values()) {
            if (rateRegression.getCriticalRegressions().containsKey(pair.getActiveEvent().id)) continue;
            arcLink = RegressionReportBuilder.getArcLink(apiClient, serviceId, pair.getActiveEvent().id, timespan);
            regressedEvent = new OOReportRegressedEvent(pair.getActiveEvent(), pair.getBaseEvent(), "Regression", arcLink);
            result.add(regressedEvent);
        }
        return result;
    }

    public static class RegressionReport {
        private final List<OOReportEvent> newIssues;
        private final List<OOReportRegressedEvent> regressions;
        private final List<OOReportEvent> allIssues;
        private final boolean unstable;

        RegressionReport(List<OOReportEvent> newIssues, List<OOReportRegressedEvent> regressions, boolean unstable) {
            this.newIssues = newIssues;
            this.regressions = regressions;
            this.allIssues = new ArrayList<OOReportEvent>();
            this.allIssues.addAll(newIssues);
            this.allIssues.addAll(regressions);
            this.unstable = unstable;
        }

        public List<OOReportEvent> getAllIssues() {
            return this.allIssues;
        }

        public List<OOReportEvent> getNewIssues() {
            return this.newIssues;
        }

        public List<OOReportRegressedEvent> getRegressions() {
            return this.regressions;
        }

        public boolean getUnstable() {
            return this.unstable;
        }
    }
}

