/*
 * Decompiled with CFR 0.152.
 */
package com.overops.common.util;

import com.overops.common.api.util.ApiViewUtil;
import com.takipi.common.api.ApiClient;
import com.takipi.common.api.result.event.EventResult;
import com.takipi.common.api.result.volume.EventsVolumeResult;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public class RegressionUtil {
    public static RateRegression calculateRateRegressions(ApiClient apiClient, String serviceId, String viewId, int activeTimespan, int baselineTimespan, int minVolumeThreshold, double minErrorRateThreshold, double reggressionDelta, double criticalRegressionDelta, Collection<String> criticalExceptionTypes, PrintStream printStream) {
        RateRegression result = new RateRegression();
        DateTime now = DateTime.now();
        DateTime baselineFrom = now.minusMinutes(baselineTimespan);
        EventsVolumeResult baselineEventVolume = ApiViewUtil.getEventsVolume(apiClient, serviceId, viewId, baselineFrom, now);
        if (baselineEventVolume.events != null) {
            for (EventResult eventResult : baselineEventVolume.events) {
                if (eventResult.stats == null) continue;
                result.getBaselineEvents().put(eventResult.id, eventResult);
            }
        }
        DateTime activeFrom = now.minusMinutes(activeTimespan);
        EventsVolumeResult activeEventVolume = ApiViewUtil.getEventsVolume(apiClient, serviceId, viewId, activeFrom, now);
        if (activeEventVolume.events != null) {
            for (EventResult activeEvent : activeEventVolume.events) {
                boolean criticalRegression;
                boolean regression;
                EventResult baseLineEvent;
                double activeEventRatio;
                DateTime firstSeen = ISODateTimeFormat.dateTimeParser().parseDateTime(activeEvent.first_seen);
                boolean isNew = firstSeen.isAfter((ReadableInstant)activeFrom);
                if (isNew) {
                    result.getAllNewEvents().put(activeEvent.id, activeEvent);
                    boolean isUncaught = activeEvent.type.equals("Uncaught Exception");
                    boolean isCriticalEventType = criticalExceptionTypes.contains(activeEvent.name);
                    if (isUncaught || isCriticalEventType) {
                        result.getCriticalNewEvents().put(activeEvent.id, activeEvent);
                        if (printStream == null) continue;
                        printStream.println("Event " + activeEvent.id + " " + activeEvent.type + " - " + activeEvent.name + " is critical with " + activeEvent.stats.hits);
                        continue;
                    }
                }
                if (activeEvent.stats == null || activeEvent.stats.invocations == 0L || activeEvent.stats.hits == 0L || (activeEventRatio = (double)activeEvent.stats.hits / (double)activeEvent.stats.invocations) < minErrorRateThreshold || activeEvent.stats.hits < (long)minVolumeThreshold) continue;
                if (isNew) {
                    result.getExceededNewEvents().put(activeEvent.id, activeEvent);
                    if (printStream == null) continue;
                    printStream.println("Event " + activeEvent.id + " " + activeEvent.type + " is new with ER: " + activeEventRatio + " hits: " + activeEvent.stats.hits);
                    continue;
                }
                if (reggressionDelta == 0.0 || (baseLineEvent = result.getBaselineEvents().get(activeEvent.id)) == null) continue;
                double baselineEventRatio = baseLineEvent.stats.invocations > 0L ? (double)baseLineEvent.stats.hits / (double)baseLineEvent.stats.invocations : 0.0;
                if (baselineEventRatio == 0.0) {
                    regression = true;
                } else {
                    boolean bl = regression = activeEventRatio - baselineEventRatio >= reggressionDelta;
                }
                if (!regression) continue;
                result.getAllRegressions().put(activeEvent.id, new RegressionPair(baseLineEvent, activeEvent));
                if (printStream != null) {
                    printStream.println("Event " + activeEvent.id + " " + activeEvent.type + " regressed from ER: " + baselineEventRatio + " to: " + activeEventRatio + " hits: " + activeEvent.stats.hits);
                }
                if (criticalRegressionDelta == 0.0) continue;
                boolean bl = criticalRegression = activeEventRatio - baselineEventRatio >= criticalRegressionDelta;
                if (!criticalRegression) continue;
                result.getCriticalRegressions().put(activeEvent.id, new RegressionPair(baseLineEvent, activeEvent));
                if (printStream == null) continue;
                printStream.println("Event " + activeEvent.id + " " + activeEvent.type + " critically regressed from ER: " + baselineEventRatio + " to: " + activeEventRatio + ", hits: " + activeEvent.stats.hits);
            }
        }
        return result;
    }

    public static class RateRegression {
        private final Map<String, EventResult> allNewEvents;
        private final Map<String, RegressionPair> allRegressions = new HashMap<String, RegressionPair>();
        private final Map<String, RegressionPair> criticalRegressions;
        private final Map<String, EventResult> exceededNewEvents;
        private final Map<String, EventResult> criticalNewEvents = new HashMap<String, EventResult>();
        private final Map<String, EventResult> baselineEvents;

        RateRegression() {
            this.exceededNewEvents = new HashMap<String, EventResult>();
            this.allNewEvents = new HashMap<String, EventResult>();
            this.criticalRegressions = new HashMap<String, RegressionPair>();
            this.baselineEvents = new HashMap<String, EventResult>();
        }

        public Map<String, EventResult> getAllNewEvents() {
            return this.allNewEvents;
        }

        public Map<String, RegressionPair> getAllRegressions() {
            return this.allRegressions;
        }

        public Map<String, RegressionPair> getCriticalRegressions() {
            return this.criticalRegressions;
        }

        public Map<String, EventResult> getExceededNewEvents() {
            return this.exceededNewEvents;
        }

        public Map<String, EventResult> getCriticalNewEvents() {
            return this.criticalNewEvents;
        }

        public Map<String, EventResult> getBaselineEvents() {
            return this.baselineEvents;
        }
    }

    public static class RegressionPair {
        private final EventResult baseEvent;
        private final EventResult activeEvent;

        RegressionPair(EventResult baseEvent, EventResult activeEvent) {
            this.baseEvent = baseEvent;
            this.activeEvent = activeEvent;
        }

        public EventResult getBaseEvent() {
            return this.baseEvent;
        }

        public EventResult getActiveEvent() {
            return this.activeEvent;
        }
    }
}

