/*
 * Decompiled with CFR 0.152.
 */
package com.overops.plugins.jenkins.query;

import com.overops.plugins.jenkins.query.OOReportEvent;
import com.overops.plugins.jenkins.query.OOReportRegressedEvent;
import com.takipi.api.client.ApiClient;
import com.takipi.api.client.result.event.EventResult;
import com.takipi.api.client.util.event.EventUtil;
import com.takipi.api.client.util.regression.RateRegression;
import com.takipi.api.client.util.regression.RegressionInput;
import com.takipi.api.client.util.regression.RegressionResult;
import com.takipi.api.client.util.regression.RegressionUtil;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.joda.time.DateTime;

public class RegressionReportBuilder {
    public static String getArcLink(ApiClient apiClient, String eventId, RegressionInput input, RateRegression regression) {
        DateTime activeWndowStart = regression.getActiveWndowStart();
        DateTime from = activeWndowStart.minusMinutes(input.baselineTimespan);
        String result = EventUtil.getEventRecentLinkDefault((ApiClient)apiClient, (String)input.serviceId, (String)eventId, (DateTime)from, (DateTime)DateTime.now(), (Collection)input.applictations, (Collection)input.servers, (Collection)input.deployments, (int)EventUtil.DEFAULT_PERIOD);
        return result;
    }

    public static RegressionReport execute(ApiClient apiClient, RegressionInput input, PrintStream output, boolean verbose) {
        RateRegression rateRegression = RegressionUtil.calculateRateRegressions((ApiClient)apiClient, (RegressionInput)input, (PrintStream)output, (boolean)verbose);
        List<OOReportEvent> newIssues = RegressionReportBuilder.getAllNewEvents(apiClient, input, rateRegression);
        List<OOReportRegressedEvent> regressions = RegressionReportBuilder.getAllRegressions(apiClient, input, rateRegression);
        boolean unstable = rateRegression.getCriticalNewEvents().size() > 0 || rateRegression.getExceededNewEvents().size() > 0 || rateRegression.getCriticalRegressions().size() > 0;
        return new RegressionReport(input, rateRegression, newIssues, regressions, unstable);
    }

    private static List<OOReportEvent> getReportSevereEvents(ApiClient apiClient, RegressionInput input, RateRegression regression, Collection<EventResult> events, String type) {
        ArrayList<OOReportEvent> result = new ArrayList<OOReportEvent>();
        for (EventResult event : events) {
            String arcLink = RegressionReportBuilder.getArcLink(apiClient, event.id, input, regression);
            OOReportEvent reportEvent = new OOReportEvent(event, type, arcLink);
            result.add(reportEvent);
        }
        return result;
    }

    private static List<OOReportEvent> getReportNewEvents(ApiClient apiClient, RegressionInput input, RateRegression rateRegression) {
        ArrayList<OOReportEvent> result = new ArrayList<OOReportEvent>();
        for (EventResult event : rateRegression.getAllNewEvents().values()) {
            if (rateRegression.getCriticalNewEvents().containsKey(event.id) || rateRegression.getExceededNewEvents().containsKey(event.id)) continue;
            String arcLink = RegressionReportBuilder.getArcLink(apiClient, event.id, input, rateRegression);
            OOReportEvent newEvent = new OOReportEvent(event, "New", arcLink);
            result.add(newEvent);
        }
        return result;
    }

    private static List<OOReportEvent> getAllNewEvents(ApiClient apiClient, RegressionInput input, RateRegression rateRegression) {
        ArrayList<OOReportEvent> result = new ArrayList<OOReportEvent>();
        result.addAll(RegressionReportBuilder.getReportSevereEvents(apiClient, input, rateRegression, rateRegression.getCriticalNewEvents().values(), "Severe New"));
        result.addAll(RegressionReportBuilder.getReportSevereEvents(apiClient, input, rateRegression, rateRegression.getExceededNewEvents().values(), "Severe New"));
        result.addAll(RegressionReportBuilder.getReportNewEvents(apiClient, input, rateRegression));
        return result;
    }

    private static List<OOReportRegressedEvent> getAllRegressions(ApiClient apiClient, RegressionInput input, RateRegression rateRegression) {
        OOReportRegressedEvent regressedEvent;
        String arcLink;
        ArrayList<OOReportRegressedEvent> result = new ArrayList<OOReportRegressedEvent>();
        for (RegressionResult regressionResult : rateRegression.getCriticalRegressions().values()) {
            arcLink = RegressionReportBuilder.getArcLink(apiClient, regressionResult.getEvent().id, input, rateRegression);
            regressedEvent = new OOReportRegressedEvent(regressionResult.getEvent(), regressionResult.getBaselineHits(), regressionResult.getBaselineInvocations(), "Severe Regression", arcLink);
            result.add(regressedEvent);
        }
        for (RegressionResult regressionResult : rateRegression.getAllRegressions().values()) {
            if (rateRegression.getCriticalRegressions().containsKey(regressionResult.getEvent().id)) continue;
            arcLink = RegressionReportBuilder.getArcLink(apiClient, regressionResult.getEvent().id, input, rateRegression);
            regressedEvent = new OOReportRegressedEvent(regressionResult.getEvent(), regressionResult.getBaselineHits(), regressionResult.getBaselineInvocations(), "Regression", arcLink);
            result.add(regressedEvent);
        }
        return result;
    }

    public static class RegressionReport {
        private final List<OOReportEvent> newIssues;
        private final List<OOReportRegressedEvent> regressions;
        private final List<OOReportEvent> allIssues;
        private final boolean unstable;
        private final RegressionInput input;
        private final RateRegression regression;

        protected RegressionReport(RegressionInput input, RateRegression regression, List<OOReportEvent> newIssues, List<OOReportRegressedEvent> regressions, boolean unstable) {
            this.input = input;
            this.regression = regression;
            this.newIssues = newIssues;
            this.regressions = regressions;
            this.allIssues = new ArrayList<OOReportEvent>();
            this.allIssues.addAll(newIssues);
            this.allIssues.addAll(regressions);
            this.unstable = unstable;
        }

        public RegressionInput getInput() {
            return this.input;
        }

        public RateRegression getRegression() {
            return this.regression;
        }

        public List<OOReportEvent> getAllIssues() {
            return this.allIssues;
        }

        public List<OOReportEvent> getNewIssues() {
            return this.newIssues;
        }

        public List<OOReportRegressedEvent> getRegressions() {
            return this.regressions;
        }

        public boolean getUnstable() {
            return this.unstable;
        }
    }
}

