/*
 * Decompiled with CFR 0.152.
 */
package com.overops.plugins.jenkins.query;

import com.overops.common.api.util.ApiViewUtil;
import com.overops.plugins.jenkins.query.DescriptorImpl;
import com.overops.plugins.jenkins.query.OverOpsBuildAction;
import com.overops.plugins.jenkins.query.RegressionReportBuilder;
import com.takipi.common.api.ApiClient;
import com.takipi.common.api.data.view.SummarizedView;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import hudson.util.Secret;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.DataBoundConstructor;

public class QueryOverOps
extends Recorder
implements SimpleBuildStep {
    private final int activeTimespan;
    private final int baselineTimespan;
    private final String criticalExceptionTypes;
    private final int minVolumeThreshold;
    private final double minErrorRateThreshold;
    private final double reggressionDelta;
    private final double criticalRegressionDelta;
    private final boolean applySeasonality;
    private final int serverWait;
    private final boolean showResults;
    private final boolean verbose;
    private final String serviceId;
    private final boolean markUnstable;
    private String applicationName;
    private String deploymentName;

    @DataBoundConstructor
    public QueryOverOps(String applicationName, String deploymentName, int activeTimespan, int baselineTimespan, String criticalExceptionTypes, int minVolumeThreshold, double minErrorRateThreshold, double reggressionDelta, double criticalRegressionDelta, boolean applySeasonality, boolean markUnstable, boolean showResults, boolean verbose, String serviceId, int serverWait) {
        this.applicationName = applicationName;
        this.deploymentName = deploymentName;
        this.criticalExceptionTypes = criticalExceptionTypes;
        this.activeTimespan = activeTimespan;
        this.baselineTimespan = baselineTimespan;
        this.minErrorRateThreshold = minErrorRateThreshold;
        this.minVolumeThreshold = minVolumeThreshold;
        this.applySeasonality = applySeasonality;
        this.reggressionDelta = reggressionDelta;
        this.criticalRegressionDelta = criticalRegressionDelta;
        this.serviceId = serviceId;
        this.serverWait = serverWait;
        this.verbose = verbose;
        this.showResults = showResults;
        this.markUnstable = markUnstable;
    }

    public String getapplicationName() {
        return this.applicationName;
    }

    public String getdeploymentName() {
        return this.deploymentName;
    }

    public int getactiveTimespan() {
        return this.activeTimespan;
    }

    public int getbaselineTimespan() {
        return this.baselineTimespan;
    }

    public double getminErrorRateThreshold() {
        return this.minErrorRateThreshold;
    }

    public double getminVolumeThreshold() {
        return this.minVolumeThreshold;
    }

    public double getreggressionDelta() {
        return this.reggressionDelta;
    }

    public double getcriticalRegressionDelta() {
        return this.criticalRegressionDelta;
    }

    public String getserviceId() {
        return this.serviceId;
    }

    public int getserverWait() {
        return this.serverWait;
    }

    public boolean getverbose() {
        return this.verbose;
    }

    public boolean getshowResults() {
        return this.showResults;
    }

    public boolean getmarkUnstable() {
        return this.markUnstable;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        String apiHost = this.getDescriptor().getOverOpsURL();
        String apiKey = Secret.toString((Secret)this.getDescriptor().getOverOpsAPIKey());
        if (apiHost == null) {
            throw new IllegalArgumentException("Missing host name");
        }
        if (apiKey == null) {
            throw new IllegalArgumentException("Missing api key");
        }
        String serviceId = this.serviceId != null && !this.serviceId.isEmpty() ? this.serviceId : this.getDescriptor().getOverOpsSID();
        if (serviceId == null) {
            throw new IllegalArgumentException("Missing environment Id");
        }
        PrintStream printStream = this.showResults ? listener.getLogger() : null;
        ApiClient apiClient = ApiClient.newBuilder().setHostname(apiHost).setApiKey(apiKey).build();
        SummarizedView allEventsView = ApiViewUtil.getServiceViewByName(apiClient, serviceId, "All Events");
        if (allEventsView == null) {
            throw new IllegalStateException("Could not acquire ID for All events view");
        }
        if (this.serverWait > 0) {
            if (this.showResults) {
                printStream.println("Waiting " + this.serverWait + " seconds for code analysis to complete");
            }
            TimeUnit.SECONDS.sleep(this.serverWait);
        }
        RegressionReportBuilder.RegressionReport report = RegressionReportBuilder.execute(apiClient, serviceId, allEventsView.id, this.activeTimespan, this.baselineTimespan, this.criticalExceptionTypes, this.minVolumeThreshold, this.minErrorRateThreshold, this.reggressionDelta, this.criticalRegressionDelta, this.applySeasonality, printStream, this.verbose);
        OverOpsBuildAction buildAction = new OverOpsBuildAction(report, run);
        run.addAction((Action)buildAction);
        if (this.markUnstable && report.getUnstable()) {
            run.setResult(Result.UNSTABLE);
        }
    }
}

