/*
 * Decompiled with CFR 0.152.
 */
package com.overops.plugins.jenkins.query;

import com.takipi.common.api.result.event.EventResult;
import java.text.DecimalFormat;
import java.util.regex.Pattern;

public class OOReportEvent {
    protected static final DecimalFormat decimalFormat = new DecimalFormat("#.00");
    public static final String NEW_ISSUE = "New";
    public static final String SEVERE_NEW = "Severe New";
    public static final String REGRESSION = "Regression";
    public static final String SEVERE_REGRESSION = "Severe Regression";
    protected final EventResult event;
    protected final String arcLink;
    protected final String type;

    public OOReportEvent(EventResult event, String type, String arcLink) {
        this.event = event;
        this.arcLink = arcLink;
        this.type = type;
    }

    public String getEventSummary() {
        String[] parts = this.event.error_location.class_name.split(Pattern.quote("."));
        String simpleClassName = parts.length > 0 ? parts[parts.length - 1] : this.event.error_location.class_name;
        return this.event.type + " in " + simpleClassName + "." + this.event.error_location.method_name;
    }

    public String getEventRate() {
        StringBuilder result = new StringBuilder();
        if (this.event.stats.invocations == 0L || this.event.stats.hits == 0L) {
            return "1";
        }
        double rate = (double)this.event.stats.hits / (double)this.event.stats.invocations * 100.0;
        result.append(this.event.stats.hits);
        result.append("/");
        result.append(this.event.stats.invocations);
        result.append(" (");
        String fmt = decimalFormat.format(rate);
        if (fmt.startsWith(".")) {
            result.append("0");
        }
        result.append(fmt);
        result.append("%)");
        return result.toString();
    }

    public String getIntroducedBy() {
        return this.event.introduced_by;
    }

    public String getType() {
        return this.type;
    }

    public String getARCLink() {
        return this.arcLink;
    }

    public long getHits() {
        return this.event.stats.hits;
    }

    public long getCalls() {
        return this.event.stats.invocations;
    }
}

