/*
 * Decompiled with CFR 0.152.
 */
package com.overops.common.util;

import com.google.common.collect.Maps;
import com.overops.common.api.util.ApiViewUtil;
import com.overops.common.util.MathUtil;
import com.takipi.common.api.ApiClient;
import com.takipi.common.api.data.event.Stats;
import com.takipi.common.api.data.metrics.Graph;
import com.takipi.common.api.result.event.EventResult;
import com.takipi.common.api.result.volume.EventsVolumeResult;
import com.takipi.common.api.util.CollectionUtil;
import com.takipi.common.api.util.Pair;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.Minutes;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public class RegressionUtil {
    private static final DecimalFormat df = new DecimalFormat("#.000");

    private static boolean hasOlderRelatedEvents(EventResult event, PrintStream printStream, boolean verbose) {
        int eventId;
        if (event.similar_event_ids == null) {
            return false;
        }
        if (event.similar_event_ids.size() == 0) {
            return false;
        }
        try {
            eventId = Integer.parseInt(event.id);
        }
        catch (Exception e) {
            return false;
        }
        for (String similarId : event.similar_event_ids) {
            int similarEventId;
            try {
                similarEventId = Integer.parseInt(similarId);
            }
            catch (Exception e) {
                continue;
            }
            if (eventId <= similarEventId) continue;
            if (verbose && printStream != null) {
                printStream.println("New event " + event.toString() + " has older similar event with ID " + similarId);
            }
            return true;
        }
        return false;
    }

    private static String printEvent(EventResult event) {
        StringBuilder result = new StringBuilder();
        result.append("Event ");
        result.append(event.id);
        result.append(" ");
        result.append(event.summary);
        if (!event.summary.contains("in")) {
            result.append(" in ");
            String[] parts = event.error_location.class_name.split(Pattern.quote("."));
            if (parts.length <= 1) {
                result.append(event.error_location.class_name);
            } else {
                result.append(parts[parts.length - 1]);
            }
            result.append(".");
            result.append(event.error_location.method_name);
        }
        if (event.similar_event_ids != null && event.similar_event_ids.size() > 0) {
            result.append("(");
            result.append(String.join((CharSequence)",", event.similar_event_ids));
            result.append(")");
        }
        return result.toString();
    }

    private static String f(double d) {
        if (d % 1.0 == 0.0) {
            return String.valueOf((int)d);
        }
        String result = df.format(d);
        if (result.startsWith(".")) {
            return "0" + result;
        }
        return result;
    }

    private static Map<String, long[]> getPeriodVolumes(DateTime startTime, Graph baselineGraph, int activeTimespan, int baselineTimespan) {
        HashMap result = Maps.newHashMap();
        DateTime baselineStart = startTime.minusMinutes(baselineTimespan + activeTimespan);
        int timeWindows = baselineTimespan / activeTimespan;
        for (Graph.GraphPoint gp : baselineGraph.points) {
            DateTime firstSeen = ISODateTimeFormat.dateTimeParser().parseDateTime(gp.time);
            Minutes timeDelta = Minutes.minutesBetween((ReadableInstant)baselineStart, (ReadableInstant)firstSeen);
            for (Graph.GraphPointContributor gpc : gp.contributors) {
                int index;
                long[] timeWindowVolumes = (long[])result.get(gpc.id);
                if (timeWindowVolumes == null) {
                    timeWindowVolumes = new long[timeWindows];
                    result.put(gpc.id, timeWindowVolumes);
                }
                int minutes = timeDelta.getMinutes();
                int n = index = Math.min(minutes / activeTimespan, timeWindowVolumes.length - 1);
                timeWindowVolumes[n] = timeWindowVolumes[n] + gpc.stats.hits;
            }
        }
        return result;
    }

    private static String ps(Stats stats) {
        if (stats == null) {
            return "(null)";
        }
        return "(" + stats.hits + "/" + stats.invocations + ")";
    }

    private static REGRESSION processNewsIssue(EventResult activeEvent, DateTime activeFrom, int minVolumeThreshold, double minErrorRateThreshold, Collection<String> criticalExceptionTypes, RateRegressionBuilder rateRegression, PrintStream printStream, boolean verbose) {
        boolean isNew;
        DateTime firstSeen = ISODateTimeFormat.dateTimeParser().parseDateTime(activeEvent.first_seen);
        boolean isEventNew = firstSeen.isAfter((ReadableInstant)activeFrom);
        boolean hasOlderSmiliarEvent = RegressionUtil.hasOlderRelatedEvents(activeEvent, printStream, verbose);
        boolean bl = isNew = isEventNew && !hasOlderSmiliarEvent;
        if (isNew) {
            rateRegression.addNewEvent(activeEvent.id, activeEvent);
            boolean isUncaught = activeEvent.type.equals("Uncaught Exception");
            boolean isCriticalEventType = criticalExceptionTypes.contains(activeEvent.name);
            if (isUncaught || isCriticalEventType) {
                rateRegression.addCriticalNewEvent(activeEvent.id, activeEvent);
                if (printStream != null) {
                    printStream.println(RegressionUtil.printEvent(activeEvent) + " is critical new event with " + activeEvent.stats.hits);
                }
                return REGRESSION.YES;
            }
        }
        if (activeEvent.stats == null || activeEvent.stats.invocations == 0L || activeEvent.stats.hits == 0L) {
            if (verbose && printStream != null) {
                printStream.println("No stats " + RegressionUtil.ps(activeEvent.stats) + RegressionUtil.printEvent(activeEvent));
            }
            return REGRESSION.NO_DATA;
        }
        double activeEventRatio = (double)activeEvent.stats.hits / (double)activeEvent.stats.invocations;
        if (activeEventRatio < minErrorRateThreshold || activeEvent.stats.hits < (long)minVolumeThreshold) {
            if (verbose && printStream != null) {
                printStream.println("Min thrs " + RegressionUtil.ps(activeEvent.stats) + RegressionUtil.printEvent(activeEvent) + "fails hits" + activeEvent.stats.hits + "ratio: " + activeEventRatio);
            }
            return REGRESSION.NO_DATA;
        }
        if (isNew) {
            rateRegression.addExceddedNewEvent(activeEvent.id, activeEvent);
            if (printStream != null) {
                printStream.println(RegressionUtil.printEvent(activeEvent) + " is new with ER: " + activeEventRatio + " hits: " + activeEvent.stats.hits);
            }
            return REGRESSION.YES;
        }
        return REGRESSION.NO;
    }

    private static RegressionStats.SeasonlityResult calculateSeasonality(EventResult activeEvent, Map<String, long[]> periodVolumes) {
        long[] eventPeriodVolumes = periodVolumes.get(activeEvent.id);
        long largerVolumePeriod = -1L;
        int largerVolumePriodIndex = -1;
        long halfVolumePeriods = 0L;
        if (eventPeriodVolumes != null) {
            for (int index = 0; index < eventPeriodVolumes.length; ++index) {
                long periodVolume = eventPeriodVolumes[index];
                if (periodVolume > activeEvent.stats.hits) {
                    largerVolumePriodIndex = index;
                    largerVolumePeriod = periodVolume;
                    break;
                }
                if (periodVolume <= activeEvent.stats.hits / 2L) continue;
                ++halfVolumePeriods;
            }
        }
        return new RegressionStats.SeasonlityResult(largerVolumePeriod, halfVolumePeriods, largerVolumePriodIndex);
    }

    private static REGRESSION processVolumeRegression(EventResult activeEvent, int activeTimespan, int baselineTimespan, Map<String, RegressionStats> regressionsStats, Map<String, long[]> periodVolumes, double reggressionDelta, double criticalRegressionDelta, boolean applySeasonality, RateRegressionBuilder rateRegression, PrintStream printStream, boolean verbose) {
        boolean isCriticalRegression;
        if (reggressionDelta == 0.0) {
            return REGRESSION.NO;
        }
        RegressionStats regressionStats = regressionsStats.get(activeEvent.id);
        if (regressionStats == null) {
            if (verbose && printStream != null) {
                printStream.println("No regression stats " + RegressionUtil.printEvent(activeEvent));
            }
            return REGRESSION.NO_DATA;
        }
        double normalizedActiveVolume = (double)activeEvent.stats.hits / (double)activeTimespan;
        double normalizedBaselineVolume = (double)regressionStats.hits / (double)baselineTimespan;
        double volRateDelta = normalizedActiveVolume / normalizedBaselineVolume - 1.0;
        double normalizedActiveInv = (double)activeEvent.stats.invocations / (double)activeTimespan;
        double normalizedBaselineInv = (double)regressionStats.invocations / (double)baselineTimespan;
        double invRateDelta = normalizedActiveInv / normalizedBaselineInv - 1.0;
        boolean isRegression = volRateDelta - Math.max(invRateDelta * 2.0, 0.0) > reggressionDelta;
        boolean bl = isCriticalRegression = volRateDelta - Math.max(invRateDelta * 2.0, 0.0) > criticalRegressionDelta;
        if (!isRegression) {
            if (verbose && printStream != null) {
                printStream.println("Not regressed " + RegressionUtil.printEvent(activeEvent));
            }
            return REGRESSION.NO;
        }
        RegressionStats.SeasonlityResult seasonlityResult = applySeasonality ? RegressionUtil.calculateSeasonality(activeEvent, periodVolumes) : null;
        if (printStream != null) {
            printStream.println(RegressionUtil.printEvent(activeEvent) + " regression\nRelHit: " + RegressionUtil.f(normalizedBaselineVolume) + " -> " + RegressionUtil.f(normalizedActiveVolume) + "\nRelInv: " + RegressionUtil.f(normalizedBaselineInv) + " -> " + RegressionUtil.f(normalizedActiveInv) + "\nVolDel: " + RegressionUtil.f(volRateDelta) + ", InvDel " + RegressionUtil.f(invRateDelta) + "\nhits: " + RegressionUtil.f(regressionStats.hits) + " -> " + RegressionUtil.f(activeEvent.stats.hits) + "\ninv: " + RegressionUtil.f(regressionStats.invocations) + " -> " + RegressionUtil.f(activeEvent.stats.invocations));
        }
        if (applySeasonality && seasonlityResult.largerVolumePeriod >= 0L) {
            if (printStream != null) {
                printStream.println("Period " + seasonlityResult.largerVolumePriodIndex + " = " + seasonlityResult.largerVolumePeriod + " > active volume. Aborting regression\n");
            }
            return REGRESSION.NO;
        }
        if (applySeasonality && seasonlityResult.halfVolumePeriods >= 2L) {
            if (printStream != null) {
                printStream.println(seasonlityResult.halfVolumePeriods + " periods > 50% active volume detected. Aborting regression\n");
            }
            return REGRESSION.NO;
        }
        rateRegression.addRegression(activeEvent.id, activeEvent, regressionStats.hits, regressionStats.invocations);
        if (isCriticalRegression && criticalRegressionDelta > 0.0) {
            rateRegression.addCriticalRegression(activeEvent.id, activeEvent, regressionStats.hits, regressionStats.invocations);
        }
        if (printStream != null) {
            printStream.println("\n");
        }
        return REGRESSION.YES;
    }

    public static RateRegression calculateRateRegressions(ApiClient apiClient, String serviceId, String viewId, int activeTimespan, int baselineTimespan, int minVolumeThreshold, double minErrorRateThreshold, double reggressionDelta, double criticalRegressionDelta, boolean applySeasonality, Collection<String> criticalExceptionTypes, PrintStream printStream, boolean verbose) {
        Map<String, long[]> periodVolumes;
        Map<String, RegressionStats> regressionsStats;
        EventsVolumeResult activeEventVolume;
        RateRegressionBuilder result = new RateRegressionBuilder();
        DateTime fromTime = DateTime.now().minusWeeks(1);
        DateTime activeFrom = fromTime.minusMinutes(activeTimespan);
        DateTime baselineFrom = fromTime.minusMinutes(baselineTimespan);
        if (printStream != null) {
            printStream.print("Begin regression analysis");
        }
        if ((activeEventVolume = ApiViewUtil.getEventsVolume(apiClient, serviceId, viewId, activeFrom, fromTime)) == null || activeEventVolume.events == null) {
            if (printStream != null) {
                printStream.println("SEVERE: Could not get event volume for " + serviceId + " " + viewId);
            }
            return result.build();
        }
        Graph baselineGraph = ApiViewUtil.getEventsGraph(apiClient, serviceId, viewId, baselineTimespan / activeTimespan * 2, baselineFrom, activeFrom);
        if (baselineGraph != null) {
            regressionsStats = RegressionUtil.processEventsGraph(baselineGraph);
            periodVolumes = RegressionUtil.getPeriodVolumes(fromTime, baselineGraph, activeTimespan, baselineTimespan);
        } else {
            regressionsStats = null;
            periodVolumes = null;
        }
        ArrayList<EventResult> nonRegressions = new ArrayList<EventResult>();
        for (EventResult activeEvent : activeEventVolume.events) {
            REGRESSION regResult;
            REGRESSION isNewIssue = RegressionUtil.processNewsIssue(activeEvent, activeFrom, minVolumeThreshold, minErrorRateThreshold, criticalExceptionTypes, result, printStream, verbose);
            if (isNewIssue.equals((Object)REGRESSION.YES)) continue;
            if (isNewIssue.equals((Object)REGRESSION.NO_DATA)) {
                nonRegressions.add(activeEvent);
                continue;
            }
            if (baselineGraph == null || (regResult = RegressionUtil.processVolumeRegression(activeEvent, activeTimespan, baselineTimespan, regressionsStats, periodVolumes, reggressionDelta, criticalRegressionDelta, applySeasonality, result, printStream, verbose)).equals((Object)REGRESSION.YES)) continue;
            nonRegressions.add(activeEvent);
        }
        if (verbose) {
            RegressionUtil.printNonRegressions(nonRegressions, printStream);
        }
        return result.build();
    }

    private static void printNonRegressions(List<EventResult> nonRegressions, PrintStream printStream) {
        if (printStream != null) {
            nonRegressions.sort(new Comparator<EventResult>(){

                @Override
                public int compare(EventResult o1, EventResult o2) {
                    return (int)o1.stats.hits - (int)o2.stats.hits;
                }
            });
            printStream.println("\nNon regressions:\n");
            for (EventResult event : nonRegressions) {
                printStream.println(event.stats.hits + " " + RegressionUtil.printEvent(event));
            }
        }
    }

    private static Map<String, RegressionStats> processEventsGraph(Graph graph) {
        HashMap rawData = Maps.newHashMap();
        int pointsCount = graph.points.size();
        for (int i = 0; i < pointsCount; ++i) {
            Graph.GraphPoint currentPoint = (Graph.GraphPoint)graph.points.get(i);
            if (CollectionUtil.safeIsEmpty((Collection)currentPoint.contributors)) continue;
            for (Graph.GraphPointContributor contributor : currentPoint.contributors) {
                if (contributor.stats == null) continue;
                Pair eventData = (Pair)rawData.get(contributor.id);
                if (eventData == null) {
                    eventData = Pair.of((Object)new long[pointsCount], (Object)new long[pointsCount]);
                    rawData.put(contributor.id, eventData);
                }
                ((long[])eventData.getFirst())[i] = contributor.stats.hits;
                ((long[])eventData.getSecond())[i] = contributor.stats.invocations;
            }
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)rawData.size());
        for (Map.Entry entry : rawData.entrySet()) {
            result.put(entry.getKey(), RegressionUtil.buildRegressionStats((Pair<long[], long[]>)((Pair)entry.getValue())));
        }
        return result;
    }

    private static RegressionStats buildRegressionStats(Pair<long[], long[]> eventStats) {
        long[] hitsArr = (long[])eventStats.getFirst();
        long[] invocationsArr = (long[])eventStats.getSecond();
        double[] rateArr = RegressionUtil.getRateArr(hitsArr, invocationsArr);
        long hitsSum = MathUtil.sum(hitsArr);
        long invocationsSum = MathUtil.sum(invocationsArr);
        double overallRate = invocationsSum == 0L ? 0.0 : (double)hitsSum / (double)invocationsSum;
        double hitsAvg = MathUtil.avg(hitsArr);
        double invocationsAvg = MathUtil.avg(invocationsArr);
        double rateAvg = MathUtil.avg(rateArr);
        double hitsAvgStdDev = MathUtil.stdDev(hitsArr);
        double invocationsAvgStdDev = MathUtil.stdDev(invocationsArr);
        double rateAvgStdDev = MathUtil.stdDev(rateArr);
        return RegressionStats.of(hitsSum, invocationsSum, overallRate, hitsAvg, invocationsAvg, rateAvg, hitsAvgStdDev, invocationsAvgStdDev, rateAvgStdDev);
    }

    public static double[] getRateArr(long[] hits, long[] invocations) {
        double[] result = new double[hits.length];
        for (int i = 0; i < hits.length; ++i) {
            long curHits = hits[i];
            long curInvocations = invocations[i];
            result[i] = curInvocations == 0L ? 0.0 : (double)curHits / (double)curInvocations;
        }
        return result;
    }

    static enum REGRESSION {
        YES,
        NO,
        NO_DATA;

    }

    public static class RateRegression {
        private final Map<String, EventResult> allNewEvents;
        private final Map<String, RegressionResult> allRegressions;
        private final Map<String, RegressionResult> criticalRegressions;
        private final Map<String, EventResult> exceededNewEvents;
        private final Map<String, EventResult> criticalNewEvents;

        RateRegression(Map<String, EventResult> allNewEvents, Map<String, RegressionResult> allRegressions, Map<String, RegressionResult> criticalRegressions, Map<String, EventResult> exceededNewEvents, Map<String, EventResult> criticalNewEvents) {
            this.allRegressions = Collections.unmodifiableMap(allRegressions);
            this.criticalNewEvents = Collections.unmodifiableMap(criticalNewEvents);
            this.exceededNewEvents = Collections.unmodifiableMap(exceededNewEvents);
            this.allNewEvents = Collections.unmodifiableMap(allNewEvents);
            this.criticalRegressions = Collections.unmodifiableMap(criticalRegressions);
        }

        public Map<String, EventResult> getAllNewEvents() {
            return this.allNewEvents;
        }

        public Map<String, RegressionResult> getAllRegressions() {
            return this.allRegressions;
        }

        public Map<String, RegressionResult> getCriticalRegressions() {
            return this.criticalRegressions;
        }

        public Map<String, EventResult> getExceededNewEvents() {
            return this.exceededNewEvents;
        }

        public Map<String, EventResult> getCriticalNewEvents() {
            return this.criticalNewEvents;
        }
    }

    public static class RateRegressionBuilder {
        private final Map<String, EventResult> allNewEvents;
        private final Map<String, RegressionResult> allRegressions = Maps.newHashMap();
        private final Map<String, RegressionResult> criticalRegressions;
        private final Map<String, EventResult> exceededNewEvents;
        private final Map<String, EventResult> criticalNewEvents = Maps.newHashMap();

        RateRegressionBuilder() {
            this.exceededNewEvents = Maps.newHashMap();
            this.allNewEvents = Maps.newHashMap();
            this.criticalRegressions = Maps.newHashMap();
        }

        public void addNewEvent(String id, EventResult event) {
            this.allNewEvents.put(id, event);
        }

        public void addExceddedNewEvent(String id, EventResult event) {
            this.exceededNewEvents.put(id, event);
        }

        public void addCriticalNewEvent(String id, EventResult event) {
            this.criticalNewEvents.put(id, event);
        }

        public void addRegression(String id, EventResult event, long baselineHits, long baselineInvocations) {
            this.allRegressions.put(id, RegressionResult.of(event, baselineHits, baselineInvocations));
        }

        public void addCriticalRegression(String id, EventResult event, long baselineHits, long baselineInvocations) {
            this.criticalRegressions.put(id, RegressionResult.of(event, baselineHits, baselineInvocations));
        }

        public RateRegression build() {
            return new RateRegression(this.allNewEvents, this.allRegressions, this.criticalRegressions, this.exceededNewEvents, this.criticalNewEvents);
        }
    }

    public static class RegressionStats {
        public final long hits;
        public final long invocations;
        public final double rate;
        public final double hitsAvg;
        public final double invocationsAvg;
        public final double rateAvg;
        public final double hitsAvgStdDev;
        public final double invocationsAvgStdDev;
        public final double rateAvgStdDev;

        private RegressionStats(long hits, long invocations, double rate, double hitsAvg, double invocationsAvg, double rateAvg, double hitsAvgStdDev, double invocationsAvgStdDev, double rateAvgStdDev) {
            this.hits = hits;
            this.invocations = invocations;
            this.rate = rate;
            this.hitsAvg = hitsAvg;
            this.invocationsAvg = invocationsAvg;
            this.rateAvg = rateAvg;
            this.hitsAvgStdDev = hitsAvgStdDev;
            this.invocationsAvgStdDev = invocationsAvgStdDev;
            this.rateAvgStdDev = rateAvgStdDev;
        }

        static RegressionStats of(long hits, long invocations, double rate, double hitsAvg, double invocationsAvg, double rateAvg, double hitsAvgStdDev, double invocationsAvgStdDev, double rateAvgStdDev) {
            return new RegressionStats(hits, invocations, rate, hitsAvg, invocationsAvg, rateAvg, hitsAvgStdDev, invocationsAvgStdDev, rateAvgStdDev);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("hits = ");
            result.append(this.hits);
            result.append(", invocations = ");
            result.append(this.invocations);
            result.append(", rate = ");
            result.append(this.rate);
            result.append(", hitsAvg = ");
            result.append(this.hitsAvg);
            result.append(", invocationsAvg = ");
            result.append(this.invocationsAvg);
            result.append(", rateAvg = ");
            result.append(this.rateAvg);
            result.append(", hitsAvgStdDev = ");
            result.append(this.hitsAvgStdDev);
            result.append(", invocationsAvgStdDev = ");
            result.append(this.invocationsAvgStdDev);
            result.append(", rateAvgStdDev = ");
            result.append(this.rateAvgStdDev);
            return result.toString();
        }

        public static class SeasonlityResult {
            public final long largerVolumePeriod;
            public final long halfVolumePeriods;
            public final int largerVolumePriodIndex;

            private SeasonlityResult(long largerVolumePeriod, long halfVolumePeriods, int largerVolumePriodIndex) {
                this.largerVolumePeriod = largerVolumePeriod;
                this.halfVolumePeriods = halfVolumePeriods;
                this.largerVolumePriodIndex = largerVolumePriodIndex;
            }
        }
    }

    public static class RegressionResult {
        private EventResult event;
        private long baselineHits;
        private long baselinInvocations;

        public EventResult getEvent() {
            return this.event;
        }

        public long getBaselineHits() {
            return this.baselineHits;
        }

        public long getBaselineInvocations() {
            return this.baselinInvocations;
        }

        public static RegressionResult of(EventResult event, long baselineHits, long baselinInvocations) {
            RegressionResult result = new RegressionResult();
            result.event = event;
            result.baselineHits = baselineHits;
            result.baselinInvocations = baselinInvocations;
            return result;
        }
    }
}

