/*
 * Decompiled with CFR 0.152.
 */
package com.overops.common.api.util;

import com.google.common.collect.Maps;
import com.takipi.common.api.ApiClient;
import com.takipi.common.api.data.metrics.Graph;
import com.takipi.common.api.data.view.SummarizedView;
import com.takipi.common.api.data.view.ViewFilters;
import com.takipi.common.api.data.view.ViewInfo;
import com.takipi.common.api.request.category.CategoryAddViewRequest;
import com.takipi.common.api.request.intf.ApiGetRequest;
import com.takipi.common.api.request.intf.ApiPostRequest;
import com.takipi.common.api.request.metrics.GraphRequest;
import com.takipi.common.api.request.view.CreateViewRequest;
import com.takipi.common.api.request.view.ViewsRequest;
import com.takipi.common.api.request.volume.EventsVolumeRequest;
import com.takipi.common.api.result.metrics.GraphResult;
import com.takipi.common.api.result.view.CreateViewResult;
import com.takipi.common.api.result.view.ViewsResult;
import com.takipi.common.api.result.volume.EventsVolumeResult;
import com.takipi.common.api.url.UrlClient;
import com.takipi.common.api.util.CollectionUtil;
import com.takipi.common.api.util.Pair;
import com.takipi.common.api.util.ValidationUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class ApiViewUtil {
    private static final DateTimeFormatter fmt = ISODateTimeFormat.dateTime().withZoneUTC();

    public static void createLabelViewsIfNotExists(ApiClient apiClient, String serviceId, Collection<Pair<String, String>> viewsAndLabels, String categoryId) {
        Map<String, SummarizedView> views = ApiViewUtil.getServiceViewsByName(apiClient, serviceId);
        for (Pair<String, String> pair : viewsAndLabels) {
            String viewName = (String)pair.getFirst();
            String labelName = (String)pair.getSecond();
            SummarizedView view = views.get(viewName);
            if (view != null) {
                System.out.println("view " + viewName + " found with ID " + view.id);
                continue;
            }
            ViewInfo viewInfo = new ViewInfo();
            viewInfo.name = viewName;
            viewInfo.filters = new ViewFilters();
            viewInfo.filters.labels = Collections.singletonList(labelName);
            viewInfo.shared = true;
            CreateViewRequest createViewRequest = CreateViewRequest.newBuilder().setServiceId(serviceId).setViewInfo(viewInfo).build();
            UrlClient.Response viewResponse = apiClient.post((ApiPostRequest)createViewRequest);
            if (viewResponse.isBadResponse() || viewResponse.data == null) {
                System.err.println("Cannot create view " + viewName);
                continue;
            }
            System.out.println("Created view " + ((CreateViewResult)viewResponse.data).view_id + " for label " + labelName);
            CategoryAddViewRequest categoryAddViewRequest = CategoryAddViewRequest.newBuilder().setServiceId(serviceId).setViewId(((CreateViewResult)viewResponse.data).view_id).setCategoryId(categoryId).build();
            UrlClient.Response categoryAddViewResponse = apiClient.post((ApiPostRequest)categoryAddViewRequest);
            if (!categoryAddViewResponse.isBadResponse()) continue;
            System.out.println("Error adding view " + viewName + " to category " + categoryId);
        }
    }

    public static Map<String, SummarizedView> getServiceViewsByName(ApiClient apiClient, String serviceId) {
        ViewsRequest viewsRequest = ViewsRequest.newBuilder().setServiceId(serviceId).build();
        UrlClient.Response viewsResponse = apiClient.get((ApiGetRequest)viewsRequest);
        if (viewsResponse.isBadResponse() || viewsResponse.data == null || ((ViewsResult)viewsResponse.data).views == null) {
            System.err.println("Can't list views");
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMap();
        for (SummarizedView view : ((ViewsResult)viewsResponse.data).views) {
            result.put(view.name, view);
        }
        return result;
    }

    public static SummarizedView getServiceViewByName(ApiClient apiClient, String serviceId, String viewName) {
        ViewsRequest viewsRequest = ViewsRequest.newBuilder().setServiceId(serviceId).setViewName(viewName).build();
        UrlClient.Response viewsResponse = apiClient.get((ApiGetRequest)viewsRequest);
        if (viewsResponse.isBadResponse() || viewsResponse.data == null || ((ViewsResult)viewsResponse.data).views == null || ((ViewsResult)viewsResponse.data).views.size() == 0) {
            return null;
        }
        SummarizedView result = (SummarizedView)((ViewsResult)viewsResponse.data).views.get(0);
        return result;
    }

    public static EventsVolumeResult getEventsVolume(ApiClient apiClient, String serviceId, String viewId, DateTime from, DateTime to) {
        EventsVolumeRequest eventsVolumeRequest = EventsVolumeRequest.newBuilder().setServiceId(serviceId).setViewId(viewId).setFrom(from.toString(fmt)).setTo(to.toString(fmt)).setVolumeType(ValidationUtil.VolumeType.all).build();
        UrlClient.Response eventsVolumeResponse = apiClient.get((ApiGetRequest)eventsVolumeRequest);
        if (eventsVolumeResponse.isBadResponse()) {
            return null;
        }
        EventsVolumeResult eventsVolumeResult = (EventsVolumeResult)eventsVolumeResponse.data;
        if (eventsVolumeResult == null) {
            return null;
        }
        if (eventsVolumeResult.events == null) {
            return null;
        }
        return eventsVolumeResult;
    }

    public static Graph getEventsGraph(ApiClient apiClient, String serviceId, String viewId, int pointsCount, DateTime from, DateTime to) {
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime().withZoneUTC();
        GraphRequest graphRequest = GraphRequest.newBuilder().setServiceId(serviceId).setViewId(viewId).setGraphType(ValidationUtil.GraphType.view).setFrom(from.toString(fmt)).setTo(to.toString(fmt)).setVolumeType(ValidationUtil.VolumeType.all).setWantedPointCount(pointsCount).build();
        UrlClient.Response graphResponse = apiClient.get((ApiGetRequest)graphRequest);
        if (graphResponse.isBadResponse()) {
            return null;
        }
        GraphResult graphResult = (GraphResult)graphResponse.data;
        if (graphResult == null) {
            return null;
        }
        if (CollectionUtil.safeIsEmpty((Collection)graphResult.graphs)) {
            return null;
        }
        Graph graph = (Graph)graphResult.graphs.get(0);
        if (!viewId.equals(graph.id)) {
            return null;
        }
        if (CollectionUtil.safeIsEmpty((Collection)graph.points)) {
            return null;
        }
        return graph;
    }
}

