/*
 * Decompiled with CFR 0.152.
 */
package com.overops.plugins.jenkins.query;

import com.overops.plugins.jenkins.query.QueryOverOps;
import com.takipi.common.api.ApiClient;
import com.takipi.common.api.url.UrlClient;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.Secret;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;

@Extension
@Symbol(value={"OverOpsQuery"})
public final class DescriptorImpl
extends BuildStepDescriptor<Publisher> {
    private String overOpsURL;
    private String overOpsSID;
    private Secret overOpsAPIKey;

    public DescriptorImpl() {
        super(QueryOverOps.class);
        this.load();
    }

    public boolean isApplicable(Class<? extends AbstractProject> aClass) {
        return true;
    }

    public String getDisplayName() {
        return "Query OverOps";
    }

    public boolean configure(StaplerRequest req, JSONObject formData) {
        formData = formData.getJSONObject("QueryOverOps");
        this.overOpsURL = formData.getString("overOpsURL");
        this.overOpsSID = formData.getString("overOpsSID");
        this.overOpsAPIKey = Secret.fromString((String)formData.getString("overOpsAPIKey"));
        this.save();
        return false;
    }

    public String getOverOpsURL() {
        return this.overOpsURL;
    }

    public String getOverOpsSID() {
        return this.overOpsSID;
    }

    public Secret getOverOpsAPIKey() {
        return this.overOpsAPIKey;
    }

    @POST
    public FormValidation doTestConnection(@QueryParameter(value="overOpsURL") String overOpsURL, @QueryParameter(value="overOpsSID") String overOpsSID, @QueryParameter(value="overOpsAPIKey") Secret overOpsAPIKey) {
        if (overOpsURL == null || overOpsURL.isEmpty()) {
            return FormValidation.error((String)"OverOps URL is empty");
        }
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        try {
            boolean success;
            String apiKey = Secret.toString((Secret)overOpsAPIKey);
            ApiClient apiClient = ApiClient.newBuilder().setHostname(overOpsURL).setApiKey(apiKey).build();
            UrlClient.Response response = apiClient.testConnection();
            boolean bl = success = response != null && !response.isBadResponse();
            if (success) {
                return FormValidation.ok((String)"Connection Successful.");
            }
            int code = response != null ? response.responseCode : -1;
            return FormValidation.error((String)("Unable to connect to API server. Code: " + code));
        }
        catch (Exception e) {
            return FormValidation.error((Throwable)e, (String)("REST API error : " + e.getMessage()));
        }
    }
}

