/*
 * Decompiled with CFR 0.152.
 */
package org.overops.plugins.overops;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import hudson.util.Secret;
import java.io.IOException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Response;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.overops.plugins.overops.DescriptorImpl;
import org.overops.plugins.overops.OOReportEvent;
import org.overops.plugins.overops.OverOpsBuildAction;

public class QueryOverOps
extends Recorder
implements SimpleBuildStep {
    private final String deployName;
    private final String OOappName;
    private final int maxEventCount;
    private final int maxNewEventCount;
    private final int queryLookback;
    private final int RetryCount;
    private final int RetryInt;
    private final boolean markUnstable;
    private final boolean showResults;

    @DataBoundConstructor
    public QueryOverOps(String OOappName, String deployName, int queryLookback, int RetryCount, int RetryInt, int maxEventCount, int maxNewEventCount, boolean markUnstable, boolean showResults) {
        this.OOappName = OOappName;
        this.deployName = deployName;
        this.queryLookback = queryLookback;
        this.maxEventCount = maxEventCount;
        this.maxNewEventCount = maxNewEventCount;
        this.RetryInt = RetryInt;
        this.RetryCount = RetryCount;
        this.markUnstable = markUnstable;
        this.showResults = showResults;
    }

    public String getOOappName() {
        return this.OOappName;
    }

    public String getdeployName() {
        return this.deployName;
    }

    public int getqueryLookback() {
        return this.queryLookback;
    }

    public int getmaxEventCount() {
        return this.maxEventCount;
    }

    public int getmaxNewEventCount() {
        return this.maxNewEventCount;
    }

    public int getRetryInt() {
        return this.RetryInt;
    }

    public int getRetryCount() {
        return this.RetryCount;
    }

    public boolean getmarkUnstable() {
        return this.markUnstable;
    }

    public boolean getshowResults() {
        return this.showResults;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        String authorizationHeaderValue;
        String keyName;
        EnvVars env = run.getEnvironment(listener);
        String deployNameEnv = env.expand(this.deployName);
        String OverOpsURL = this.getDescriptor().getOverOpsURL();
        String OverOpsSID = this.getDescriptor().getOverOpsSID();
        String OverOpsUser = this.getDescriptor().getOverOpsUser();
        String OverOpsPWD = Secret.toString((Secret)this.getDescriptor().getOverOpsPWD());
        String OOAPIKey = Secret.toString((Secret)this.getDescriptor().getOOAPIKey());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm").withZone(ZoneId.of("UTC"));
        Calendar now = Calendar.getInstance();
        now.setTime(new Date());
        now.add(12, 10);
        String toStamp = formatter.format(now.getTime().toInstant());
        Calendar before = Calendar.getInstance();
        before.setTime(new Date());
        before.add(11, -this.queryLookback);
        String fromStamp = formatter.format(before.getTime().toInstant());
        Client OverOpsApiClient = ClientBuilder.newClient();
        ArrayList<OOReportEvent> EventList = new ArrayList<OOReportEvent>();
        ArrayList<OOReportEvent> NewEventList = new ArrayList<OOReportEvent>();
        String usernameAndPassword = OverOpsUser + ":" + OverOpsPWD;
        String ViewID = null;
        int x = 1;
        if (OOAPIKey == null || OOAPIKey.isEmpty()) {
            keyName = "Authorization";
            authorizationHeaderValue = "Basic " + Base64.getEncoder().encodeToString(usernameAndPassword.getBytes("utf-8"));
        } else {
            keyName = "X-API-Key";
            authorizationHeaderValue = OOAPIKey;
        }
        try {
            Response getViewResponse = OverOpsApiClient.target(OverOpsURL).path("api/v1/services/" + OverOpsSID + "/views").request(new String[]{"application/json"}).header(keyName, (Object)authorizationHeaderValue).get();
            if (getViewResponse.getStatus() == 200) {
                JSONObject getViewResult = (JSONObject)getViewResponse.readEntity(JSONObject.class);
                JSONArray ViewsArray = getViewResult.getJSONArray("views");
                for (int i = 0; i < ViewsArray.size(); ++i) {
                    if (!ViewsArray.getJSONObject(i).get("name").equals("All Events")) continue;
                    ViewID = ViewsArray.getJSONObject(i).getString("id");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.showResults) {
            listener.getLogger().println("Connecting to " + OverOpsURL + "/api/v1/services/" + OverOpsSID + "/views/" + ViewID + "/metrics/view/graph");
        }
        listener.getLogger().println("Checking OverOps for errors in deployment " + deployNameEnv);
        while (x <= this.RetryCount) {
            EventList.clear();
            NewEventList.clear();
            int totalEvents = 0;
            listener.getLogger().println("\nOverOps Query  #" + x + " from OverOps Jenkins Plugin");
            listener.getLogger().println("Waiting " + this.RetryInt + " seconds.");
            TimeUnit.SECONDS.sleep(this.RetryInt);
            try {
                Response response = OverOpsApiClient.target(OverOpsURL).path("api/v1/services/" + OverOpsSID + "/views/" + ViewID + "/metrics/view/graph").queryParam("from", new Object[]{fromStamp}).queryParam("to", new Object[]{toStamp}).queryParam("points", new Object[]{12}).queryParam("deployment", new Object[]{deployNameEnv}).queryParam("app", new Object[]{this.OOappName}).request(new String[]{"application/json"}).header(keyName, (Object)authorizationHeaderValue).get();
                if (response.getStatus() == 200) {
                    JSONObject result = (JSONObject)response.readEntity(JSONObject.class);
                    JSONArray Points = result.getJSONArray("graphs").getJSONObject(0).getJSONArray("points");
                    if (this.showResults) {
                        listener.getLogger().println(Points.size() + " Points");
                        listener.getLogger().println(Points);
                    }
                    for (int i = 0; i < Points.size(); ++i) {
                        int value = Points.getJSONObject(i).getInt("value");
                        if (value <= 0) continue;
                        JSONArray Contributors = Points.getJSONObject(i).getJSONArray("contributors");
                        for (int j = 0; j < Contributors.size(); ++j) {
                            String eventsID = Contributors.getJSONObject(j).getString("id");
                            Response eventResponse = OverOpsApiClient.target(OverOpsURL).path("api/v1/services/" + OverOpsSID + "/events/" + eventsID).request(new String[]{"application/json"}).header(keyName, (Object)authorizationHeaderValue).get();
                            JSONObject eventResult = (JSONObject)eventResponse.readEntity(JSONObject.class);
                            if (this.showResults) {
                                listener.getLogger().println(eventResult);
                            }
                            String tpkString = OverOpsSID + "#" + eventsID + "#1";
                            String tpkLink = Base64.getEncoder().encodeToString(tpkString.getBytes("utf-8"));
                            String eventOOURL = OverOpsURL.replaceAll("api.overops.com", "app.overops.com");
                            String eventString = eventResult.get("summary") + " Introduced by: " + eventResult.get("introduced_by") + " " + eventOOURL + "/tale.html?event=" + tpkLink;
                            EventList.add(new OOReportEvent(eventResult.get("summary").toString(), eventResult.get("introduced_by").toString(), eventOOURL + "/tale.html?event=" + tpkLink));
                            totalEvents += value;
                            if (!this.deployName.equals(eventResult.get("introduced_by"))) continue;
                            NewEventList.add(new OOReportEvent(eventResult.get("summary").toString(), eventResult.get("introduced_by").toString(), eventOOURL + "/tale.html?event=" + tpkLink));
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            listener.getLogger().println("OverOps found " + EventList.size() + " events in " + this.OOappName + " deployment " + deployNameEnv);
            if (EventList.size() > this.maxEventCount && this.maxEventCount != -1) {
                listener.getLogger().println("\n");
                listener.getLogger().println("Event threshold " + this.maxEventCount + " Exceeded");
                if (this.markUnstable) {
                    listener.getLogger().println("OverOps Query results in Unstable build");
                    run.setResult(Result.UNSTABLE);
                }
                for (int i = 0; i < EventList.size(); ++i) {
                    listener.getLogger().println(EventList.get(i));
                }
                x = this.RetryCount;
            }
            listener.getLogger().println("OverOps found " + NewEventList.size() + " new events in " + this.OOappName + " deployment " + deployNameEnv);
            if (NewEventList.size() > this.maxNewEventCount && this.maxNewEventCount != -1) {
                listener.getLogger().println("\n");
                listener.getLogger().println("New Event threshold " + this.maxNewEventCount + " Exceeded");
                if (this.markUnstable) {
                    listener.getLogger().println("OverOps Query results in Unstable build");
                    run.setResult(Result.UNSTABLE);
                }
                for (int i = 0; i < NewEventList.size(); ++i) {
                    listener.getLogger().println(NewEventList.get(i).geteventSummary() + " Intooduced by:  " + NewEventList.get(i).getintroducedBy() + "   " + NewEventList.get(i).getARCLink());
                }
                x = this.RetryCount;
            }
            listener.getLogger().println("New Events Introduced by " + deployNameEnv + ": " + NewEventList.size());
            ++x;
        }
        OverOpsBuildAction buildAction = new OverOpsBuildAction(EventList, NewEventList, run);
        run.addAction((Action)buildAction);
        listener.getLogger().println();
        listener.getLogger().println("Total Events found in OverOps for build " + deployNameEnv + ": " + EventList.size());
        listener.getLogger().println("New Events Introduced by" + deployNameEnv + ": " + NewEventList.size());
    }
}

