/*
 * Decompiled with CFR 0.152.
 */
package org.overops.plugins.overops;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.IOException;
import java.util.Base64;
import javax.servlet.ServletException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Response;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;
import org.overops.plugins.overops.QueryOverOps;

@Extension
@Symbol(value={"OverOpsQuery"})
public final class DescriptorImpl
extends BuildStepDescriptor<Publisher> {
    private String OverOpsURL;
    private String OverOpsUser;
    private Secret OverOpsPWD;
    private String OverOpsSID;
    private Secret OOAPIKey;

    public DescriptorImpl() {
        super(QueryOverOps.class);
        this.load();
    }

    public boolean isApplicable(Class<? extends AbstractProject> aClass) {
        return true;
    }

    public String getDisplayName() {
        return "Query OverOps";
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        formData = formData.getJSONObject("QueryOverOps");
        this.OverOpsURL = formData.getString("OverOpsURL");
        this.OverOpsUser = formData.getString("OverOpsUser");
        this.OverOpsPWD = Secret.fromString((String)formData.getString("OverOpsPWD"));
        this.OverOpsSID = formData.getString("OverOpsSID");
        this.OOAPIKey = Secret.fromString((String)formData.getString("OOAPIKey"));
        this.save();
        return false;
    }

    public String getOverOpsURL() {
        return this.OverOpsURL;
    }

    public String getOverOpsUser() {
        return this.OverOpsUser;
    }

    public Secret getOverOpsPWD() {
        return this.OverOpsPWD;
    }

    public String getOverOpsSID() {
        return this.OverOpsSID;
    }

    public Secret getOOAPIKey() {
        return this.OOAPIKey;
    }

    public void setOverOpsURL(String OverOpsURL) {
        this.OverOpsURL = OverOpsURL;
    }

    public void setOverOpsUser(String OverOpsUser) {
        this.OverOpsUser = OverOpsUser;
    }

    public void setOverOpsPWD(Secret OverOpsPWD) {
        this.OverOpsPWD = OverOpsPWD;
    }

    public void setOverOpsSID(String OverOpsSID) {
        this.OverOpsSID = OverOpsSID;
    }

    public void setOOAPIKey(Secret OOAPIKey) {
        this.OOAPIKey = OOAPIKey;
    }

    @POST
    public FormValidation doTestConnection(@QueryParameter(value="OverOpsURL") String OverOpsURL, @QueryParameter(value="OverOpsUser") String OverOpsUser, @QueryParameter(value="OverOpsPWD") Secret OverOpsPWD, @QueryParameter(value="OOAPIKey") Secret OOAPIKey) throws ServletException, IOException, InterruptedException {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        try {
            String authorizationHeaderValue;
            String keyName;
            Client OverOpsApiClient = ClientBuilder.newClient();
            String usernameAndPassword = OverOpsUser + ":" + Secret.toString((Secret)OverOpsPWD);
            if (Secret.toString((Secret)OOAPIKey) == null || Secret.toString((Secret)OOAPIKey).isEmpty()) {
                keyName = "Authorization";
                authorizationHeaderValue = "Basic " + Base64.getEncoder().encodeToString(usernameAndPassword.getBytes("utf-8"));
            } else {
                keyName = "X-API-Key";
                authorizationHeaderValue = Secret.toString((Secret)OOAPIKey);
            }
            Response response = OverOpsApiClient.target(OverOpsURL).path("api/v1/services/" + this.OverOpsSID + "/views").request(new String[]{"application/json"}).header(keyName, (Object)authorizationHeaderValue).get();
            if (response.getStatus() == 200) {
                JSONObject result = (JSONObject)response.readEntity(JSONObject.class);
                JSONArray Views = result.getJSONArray("views");
                System.out.println("Found " + Views.size() + " Views in OverOps service " + this.OverOpsSID);
                return FormValidation.ok((String)("Connection Successful.  \n Found " + Views.size() + " Views in OverOps service: " + this.OverOpsSID));
            }
            return FormValidation.error((String)("REST API error : " + response.getStatus() + " " + response.getStatusInfo()));
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e.getMessage() != null) {
                return FormValidation.error((String)("REST API error : " + e.getMessage()));
            }
            return null;
        }
    }
}

