/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl.client;

import java.io.IOException;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.net.HttpServletRequestResponseContext;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.RequestContextBuilder;
import org.opensaml.profile.action.ActionTestingSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.impl.client.AbstractBaseClientStorageServiceTest;
import org.opensaml.storage.impl.client.ClientStorageSaveContext;
import org.opensaml.storage.impl.client.ClientStorageService;
import org.opensaml.storage.impl.client.ClientStorageServiceOperation;
import org.opensaml.storage.impl.client.SaveCookieBackedClientStorageServices;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SaveCookieBackedClientStorageServicesTest
extends AbstractBaseClientStorageServiceTest {
    private ProfileRequestContext prc;
    private ClientStorageSaveContext saveCtx;
    private SaveCookieBackedClientStorageServices action;

    @BeforeClass
    public void setUpClass() throws ComponentInitializationException {
        this.init();
    }

    @BeforeMethod
    public void setUp() {
        this.prc = new RequestContextBuilder().buildProfileRequestContext();
        this.saveCtx = new ClientStorageSaveContext();
        this.prc.addSubcontext((BaseContext)this.saveCtx);
        this.action = new SaveCookieBackedClientStorageServices();
    }

    @Test
    public void testNoServices() throws ComponentInitializationException {
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
    }

    @Test
    public void testNoContext() throws ComponentInitializationException {
        this.action.setStorageServices(Collections.singletonList(this.getStorageService()));
        this.action.initialize();
        this.prc.removeSubcontext((BaseContext)this.saveCtx);
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidProfileContext");
    }

    @Test
    public void testNoCookieSources() throws ComponentInitializationException {
        ClientStorageService ss = this.getStorageService();
        this.action.setStorageServices(Collections.singletonList(ss));
        this.action.initialize();
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        this.saveCtx.getStorageOperations().add(new ClientStorageServiceOperation(ss.getId(), ss.getStorageName(), "value", ClientStorageService.ClientStorageSource.HTML_LOCAL_STORAGE));
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertNull((Object)this.saveCtx.getParent());
        Assert.assertEquals((int)((MockHttpServletResponse)HttpServletRequestResponseContext.getResponse()).getCookies().length, (int)0);
    }

    @Test
    public void testSave() throws ComponentInitializationException, IOException {
        ClientStorageService ss = this.getStorageService();
        this.action.setStorageServices(Collections.singletonList(ss));
        this.action.initialize();
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        this.saveCtx.getStorageOperations().add(new ClientStorageServiceOperation(ss.getId(), ss.getStorageName(), "the value", ClientStorageService.ClientStorageSource.COOKIE));
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertNull((Object)this.saveCtx.getParent());
        MockHttpServletResponse response = (MockHttpServletResponse)HttpServletRequestResponseContext.getResponse();
        Assert.assertEquals((int)response.getCookies().length, (int)1);
        Assert.assertEquals((String)response.getCookies()[0].getName(), (String)ss.getStorageName());
        Assert.assertEquals((String)response.getCookies()[0].getValue(), (String)"the+value");
    }
}

